/*
 * File......: AND.C
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: 30/03/93
 * Revision..: 1.0
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

// NOTE: This code has been written for and compiled with Borland C++
//       Version 3.1
//

#include <extend.h>

/*  $DOC$
 *  $FUNCNAME$
 *      GT_AND()
 *  $CATEGORY$
 *      Maths
 *  $ONELINER$
 *      Perform a bit-wise AND operation.
 *  $SYNTAX$
 *      GT_And(<nNumber1>,<nNumber2>) --> nResult
 *  $ARGUMENTS$
 *      <nNumber1> and <nNumber2> are two numbers that you whish to
 *      AND together.
 *  $RETURNS$
 *      The result of <nNumeric1> AND <nNumeric2>.
 *  $DESCRIPTION$
 *      GT_And() can be used for any bit oriented masking operation. GT_And()
 *      is the functional equivlant of the AND instruction in assembler and
 *      the & operator in C.
 *  $EXAMPLES$
 *      ? GT_And(131,15)           // Print the value of the top nibble.
 *  $SEEALSO$
 *      GT_OR() GT_XOR()
 *  $END$
 */

CLIPPER GT_And()
{
        if (PCOUNT == 2 && ISNUM(1) && ISNUM(2))
        {
                _retnl((long) _parnl(1) & (long) _parnl(2));
        }
        else
        {
                _retnl(0L);
        }
}
