;  File......: CAPLOCK.ASM
;  Author....: Andy M Leighton
;  BBS.......: The Dark Knight Returns
;  Net/Node..: 050/069
;  User Name.: Andy Leighton
;  Date......: $Date$
;  Revision..: $Rev$
;
;  This is an original work by Andy Leighton and is placed in the public
;  domain.
;
;  Modification history:
;  ---------------------
;
;  $Log$
;
;
;
;   $DOC$
;   $FUNCNAME$
;       GT_ISCAPLOCK()
;   $CATEGORY$
;       Keyboard
;   $ONELINER$
;       Checks Caps Lock
;   $SYNTAX$
;       GT_isCapLock() --> lRet
;   $ARGUMENTS$
;       None
;   $RETURNS$
;       lRet    -       TRUE if caps lock is on, otherwise FALSE
;   $DESCRIPTION$
;       Checks status of Caps Lock
;   $EXAMPLES$
;       ? "Caps Lock Is Turned " + if(GT_isCapLock(), "On", "Off")
;   $END$
;

; This has been written using TASM
; If you are using MASM you might have to change things
; around a little
; look for comments telling you what to do
;

;MASM   remove next line

                IDEAL


Public          GT_ISCAPLO

Extrn           __RetL:Far

;MASM change next line to
;               GtLibrary       SEGMENT WORD  "CODE"
Segment         GtLibrary       Word    "CODE"
                Assume          CS:GtLibrary

;MASM change next line to
;               GT_ISCAPLO      PROC FAR
Proc            GT_ISCAPLO      Far

                PUSH    ES                         ; save for later
; set up ES:[BX] to point to the address 0x00000417
                MOV     AX,40H
                MOV     ES,AX
                MOV     BX,17H

                XOR     AH,AH                      ; clear high byte of AX
                MOV     AL,BYTE PTR ES:[BX]        ; Get keyboard flags
                AND     AL,40H                     ; isolate bit 7
                PUSH    AX
                CALL    __RETL                     ; set up CLIPPER return
                ADD     SP, 2                      ; reset stack ptr
                POP     ES                         ; restore ES
                RET

;MASM change next line to
;               Gt_ISCAPLO      ENDP
EndP            GT_ISCAPLO

;MASM change next line to
;               GtLibrary       ENDS
EndS            GtLibrary

                End
