/*
 * File......: ELEMENT.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_ELEMENT()
 *  $CATEGORY$
 *      String
 *  $ONELINER$
 *      Return an element of a delimited string
 *  $SYNTAX$
 *      GT_Element( cString , nElement )
 *  $ARGUMENTS$
 *      cString  - Delimited string
 *      nElement - Number of element to find
 *  $RETURNS$
 *      The required element of the string
 *  $DESCRIPTION$
 *      Finds an element in a delimited string.  The string should be
 *      delimited by it's first character.
 *  $EXAMPLES$
 *      Return the third element of a string :
 *
 *          cString := GT_Element( cBigString , 3 )
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_LIB.ch"

FUNCTION GT_Element( cString , nElement )

/****************************************************************************
 Purpose - Find the nCount element of cString - delimited by "!"
 Returns - The substring
 Author  - Martin Colloby
 Created - 29/8/90
******************************************************************************
 Parameters - cString    - "!" delimited string
              nElement   - Element to find
 Privates   - cDelimiter - Delimiting character
              nCount     - Counting variable
 Externals  - None
****************************************************************************/

LOCAL cDelimiter := SUBSTR( cString , 1 , 1 )
LOCAL nCount     := 0

* Ignore the first character
cString := SUBSTR( cString , 2 , LEN( cString ) )

IF nElement > 1
    * Remove nElement - 1 substrings from cString
    FOR nCount := 1 TO nElement - 1
        cString := SUBSTR( cString , AT( cDelimiter , cString ) + 1 ,;
                           LEN( cString ) - AT( cDelimiter , cString ) )
    NEXT nCount
ENDIF

* Return the next available string
RETURN( SUBSTR( cString , 1 , AT( cDelimiter , cString ) - 1 ) )
*
