/*****************************************************************************
* Function: _GT_Internal_Directory()                                         *
* Syntax..: int _GT_Internal_Directory(char DirCall)                         *
* Usage...: Internal function for doing a Mk/Ch/RmDir call.                  *
* By......: David A Pearson                                                  *
*****************************************************************************/

#include <extend.h>
#include "gt_mem.h"

void _GT_Internal_Directory(char DirCall)
{
        Boolean Result    = FALSE;
        int     ErrorCode = 0;
        char    *Path;
        int     PathSeg;
        int     PathOff;

        if (PCOUNT >= 1 && ISCHAR(1))
        {
                Path    = _parc(1);
                PathSeg = _GT_FP_SEG(Path);
                PathOff = _GT_FP_OFF(Path);

                asm     Push    DS
                asm     Mov     AH,DirCall
                asm     Mov     DS,PathSeg
                asm     Mov     DX,PathOff
                asm     Int     0x21
                asm     Jnc     NoProblem
                asm     Mov     ErrorCode,AX
NoProblem:
                asm     Pop     DS
                if (ErrorCode)
                {
                        if (PCOUNT == 2 && ISNUM(2) && ISBYREF(2))
                        {
                                _storni(ErrorCode,2);
                        }
                }
                else
                {
                        Result = TRUE;
                }
        }
        _retl(Result);
}
