/*
 * File......: GTMATH01
 * Author....: Philip Ide
 * BBS.......: Dark Knight Returns
 * Net/Node..:
 * User Name.: Philip Ide
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Philip Ide and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *      GT_BINARY()
 *  $CATEGORY$
 *      Maths
 *  $ONELINER$
 *      Turn a charcter string into a binary number
 *  $SYNTAX$
 *      GT_Binary(<cString>) -> <cBinary>
 *  $ARGUMENTS$
 *      <cString> is any text string of alphanumerics
 *  $RETURNS$
 *      <cBinary> is a string.  Each byte represents one bit.
 *                Eight 'bits' make up the ascii number (in
 *                binary) of the original string.
 *  $DESCRIPTION$
 *      Turns a character string into a binary number, where
 *      every eight bits represents the ascii value of one
 *      byte from the original string, in binary notation.
 *
 *      This can be used for encryption, bit twiddling,
 *      bit stripping etc.
 *  $EXAMPLES$
 *      GT_Binary('AB') -> '0100000101000010'
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

//   GT_Binary( <cString> )

Function GT_Binary(x)
         local y, result := "", z := 8

         FOR y := 1 TO Len(x)
             result += SubStr(Replicate('0',z)+;
                       GT_DToB(Asc(SubStr(x,y))),-z)
         Next

Return (result)
