/*
 * File......: GTMATH07
 * Author....: Philip Ide
 * BBS.......: Dark Knight Returns
 * Net/Node..:
 * User Name.: Philip Ide
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Philip Ide and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *      GT_B36TOD()
 *  $CATEGORY$
 *      Maths
 *  $ONELINER$
 *      Turns a Base36 number into a decimal
 *  $SYNTAX$
 *      GT_B36ToD(<cB36Num>) --> <nDec>
 *  $ARGUMENTS$
 *      <cB36Num> is a character string representing a Base36 number
 *                This need to be in upper case.
 *  $RETURNS$
 *      <nDec>    is a decimal integer
 *  $DESCRIPTION$
 *      This function provides a method of unpacking numbers stored in
 *      Base36 format to decimal integers.  Base36 allows large numbers
 *      to be stored using very few bytes. Four bytes could hold a number
 *      as high as 1,679,615.  Useful for lookup table ID's.
 *
 *  $EXAMPLES$
 *      ? GT_B36ToD('ZZZZ')       // 1679615
 *
 *      ? GT_B36ToD('11')         // 37
 *  $SEEALSO$
 *      GT_DTOB36()
 *  $INCLUDE$
 *
 *  $END$
 */

STATIC B36 := '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'

FUNCTION GT_B36toD( n )    // n=Base36 number
LOCAL x, y := 0, z, a := 1
FOR x := 1 TO Len(n)                        // once per byte
    z := AT(SubStr(n,-x,1),B36)-1           // get 1 byte, start at far end
    IF x > 1                                // miss this the first time...
       a *= 36                              // exponentiate by 36
    Endif
    y += (a*z)                              // exponentiate the byte,
Next                                        // add to result.
Return (y)
