/*
    File......: GT_Error.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 05/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 05/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_ERROR()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      Display an error message on the screen and wait for response
 *  $SYNTAX$
 *      GT_Error([<cMessage>]) -> lSuccess
 *  $ARGUMENTS$
 *      <cMessage> is a charater string todisplay.
 *  $RETURNS$
 *      lSuccess
 *  $DESCRIPTION$
 *      To display an error message on the screen, wait for
 *      the user to respond and remove the message.
 *  $EXAMPLES$
 *      IF .NOT. lSuccess
 *          GT_Error("It didn't Work !")
 *      ENDIF
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_Error(cMessage)

LOCAL aErrors := {  'An invalid Function number' ;
    ,'A file could not be found' ;
    ,'A path could not be found' ;
    ,'Too many open files (No handle left)' ;
    ,'Access being denied' ;
    ,'An invalid handle' ;
    ,'Memory control blocks being destroyed' ;
    ,'Insufficient memory' ;
    ,'An invalid memory block address' ;
    ,'An invalid environment' ;
    ,'An invalid format' ;
    ,'An invalid access code' ;
    ,'Some invalid data' ;
    ,'A reserved DOS error' ;
    ,'An invalid drive being specIfied' ;
    ,'An attempt to remove the current directory' ;
    ,'A "NOT SAME DEVICE" error' ;
    ,'No more files available' ;
    ,'An attempt to write to a write protected diskette' ;
    ,'An unknown unit' ;
    ,'The drive not being ready' ;
    ,'An unknown command' ;
    ,'A data error (CRC)' ;
    ,'A bad request structure length' ;
    ,'A seek error' ;
    ,'An unknown media type' ;
    ,'A sector not found error' ;
    ,'The printer being out of paper' ;
    ,'A write fault' ;
    ,'A read fault' ;
    ,'A general failure' ;
    ,'A sharing violation' ;
    ,'A lock violation' ;
    ,'An invalid disk change' ;
    ,'No FCB available' ;
    ,'A sharing buffer overflow' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'An unsupported network request' ;
    ,'The remote computer not listening' ;
    ,'A duplicate name on the network' ;
    ,'The network name not found' ;
    ,'The network being busy' ;
    ,'The network device no longer exists' ;
    ,'The network BIOS command limit exceeded' ;
    ,'A network adaptor hardware error' ;
    ,'An incorrect response from the network' ;
    ,'An unexpected network error' ;
    ,'An incompatible remote adaptor' ;
    ,'The print queue being full' ;
    ,'Insufficient space for print file' ;
    ,'The print file being deleted (not enough space)' ;
    ,'The network name being deleted' ;
    ,'Access being denied' ;
    ,'A network device type error' ;
    ,'The network name cound not be found' ;
    ,'The network name limit has been exceeded' ;
    ,'The network BIOS session limit has been exceeded' ;
    ,'A temporary pause' ;
    ,'The network refusing a request' ;
    ,'A print or disk redirection being paused' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'A reserved DOS error' ;
    ,'The file currently existing' ;
    ,'A reserved DOS error' ;
    ,'Not being able to make a directory entry' ;
    ,'Failing on interrupt 24H' ;
    ,'Too many redirections' ;
    ,'A duplicate redirection' ;
    ,'An invalid password' ;
    ,'An invalid parameter' ;
    ,'A network device fault' }

LOCAL cCause := CRLF + CRLF + 'Cause: '
LOCAL cClose := ')'
LOCAL cDosError := '. (DOS error '
LOCAL cPressKey := CRLF + CRLF + ;
    'Press any key to continue'

LOCAL cProblem := ''
LOCAL cScreen := SAVESCREEN(00,00,MAXROW(),MAXCOL())
LOCAL lSuccess := .T.
LOCAL nCursor := GT_Nocursor()
LOCAL nError := Max(FERROR(),DOSERROR())
LOCAL nTimeOut := 120

DOSERROR(0)

IF nError > 0

    cProblem := cCause + aErrors[nError] + cDosError + ;
        LTRIM(STR(nError)) + cClose

ENDIF

GT_Message(cMessage + cProblem + cPressKey,'Error',NIL, ;
    BOX_SS)

//  Wait and blank keyboard buffer
GT_Beep()
INKEY(nTimeOut)
KEYBOARD CHR(0)
INKEY()
RESTSCREEN(00,00,MAXROW(),MAXCOL(),cScreen)
SETCURSOR(nCursor)

/*
    End of GT_Error()
*/
RETURN(lSuccess)

