/*
    File......: GT_IsField.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 11/03/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 11/03/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *       GT_ISFIELD()
 *  $CATEGORY$
 *       General
 *  $ONELINER$
 *       Validate a Get for a valid field name.
 *  $SYNTAX$
 *       GT_IsField(<oGet>) -> lSuccess
 *  $ARGUMENTS$
 *       <oGet> Get object.
 *  $RETURNS$
 *       lSuccess
 *  $DESCRIPTION$
 *       Validate a Get for a valid field name.
 *  $EXAMPLES$
 *  $END$
 */

#include "GTClippe.ch"

FUNCTION GT_IsField(oGet)

LOCAL cData := ''
LOCAL cLegal := '1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ_'
LOCAL lSuccess := .T.
LOCAL nCount := 0

Default oGet to NIL

IF oGet = NIL

    lSuccess := .F.

ELSE

    cData := ALLTRIM(UPPER(EVAL(oGet:Block)))
    nCount := 1
    DO WHILE nCount <= LEN(cData) .AND. lSuccess

        // ?
        lSuccess := SUBSTR(cData,nCount++,1) $ cLegal

    ENDDO


ENDIF

IF .NOT. lSuccess
    GT_AskUser('Illegal Name !')
ENDIF

/*
    End of GT_IsField()
*/
RETURN(lSuccess)
