/*
    File......: GT_MemRest.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_MEMREST()
 *  $CATEGORY$
 *      File I/O
 *  $ONELINER$
 *      To Restore variables from a .mem file
 *  $SYNTAX$
 *      GT_MemRest(<cFile>,[<cFilter>],[<bFunc>], ;
 *      [<nSeconds>],[<nPause>]) => lSuccess
 *  $ARGUMENTS$
 *      <cFile> is the name, including path and extention,
 *      of the file to Restore from.
 *
 *      <cFilter> is the specification of the variables to
 *      Save again if using the code block function.
 *
 *      <bFunc> is an optional code block to evaluate. If
 *      this is evaluated then the same specifications are
 *      used to re-save the file.
 *
 *      <nSeconds> is the time to wait.
 *
 *      <nPause> is the time interval between attempts.
 *  $RETURNS$
 *      .T. / .F.
 *  $DESCRIPTION$
 *      To Restore variables from a .mem file
 *  $EXAMPLES$
 *      // Where pCount is PRIVATE ....
 *      IF .NOT. GT_MemRest('System.mem','p*',{ | | pCount ++ })
 *          ? 'Error'
 *      ENDIF
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

#define HEIGHT  06
#define WIDTH   16

FUNCTION GT_MemRest(cFile,cFilter,bFunc,nSeconds,nPause)

LOCAL cScreen := ''
LOCAL nBottom := INT((MAXROW() + HEIGHT)/2)
LOCAL nKey := 0
LOCAL nLeft := INT((MAXCOL() - WIDTH)/2)
LOCAL nRight := nLeft - WIDTH
LOCAL nTop := nBottom - HEIGHT
Local lMessage := .F.
Local lSuccess := .F.

Default cFile to 'System.mem'
Default cFilter to '*'
Default bFunc to NIL
Default nSeconds to 120
Default nPause to 0.5

DO WHILE (.NOT. lSuccess) .AND. (nSeconds > 0) .AND. ;
    (nKey != K_ESC)

    // Restore ?
    RESTORE FROM (cFile) ADDITIVE
    lSuccess := (FERROR() == 0)

    IF .NOT. lSuccess

        // Wait and retry
        IF .NOT. lMessage

            // Rest
            cScreen := RestSCREEN(nTop,nLeft,nBottom,nRight)

            // Display
            GT_Window(nTop,nLeft,nBottom,nRight,BOX_SS, ;
                NIL,'Saving ....',.T.)

            // Position for message
            @ nTop+02, nLeft+02 SAY 'Timeout:'
            @ nTop+04, nLeft+02 SAY ;
                PADC('EscExit',WIDTH-03)

            lMessage := .T.

        ENDIF

        @ nTop+02, nLeft+09 SAY PADR(INT(nSeconds),3)
        nKey := INKEY(nPause)
        nSeconds -= nPause

    ENDIF

ENDDO

IF lMessage
    RESTSCREEN(nTop,nLeft,nBottom,nRight,cScreen)
ENDIF


IF lSuccess .AND. bFunc != NIL
    EVAL(bFunc)
    lSuccess := GT_MemSave(cFile,cFilter)
End If

/*
    End of GT_MemRest()
*/
RETURN(lSuccess)
