/*
    File......: GT_Open.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 09/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 09/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_OPEN()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Open a DBF file with indexes, allowing reindexing, etc.
 *  $SYNTAX$
 *      GT_Open(<cFile>,[<aIndex>],[<cAlias>],[<lFix>], ;
 *              [<lPack>],[<aStruct>]) -> cAlias
 *  $ARGUMENTS$
 *      <cFile> is the name of the file to open.
 *
 *      <aIndex> is an array of text strings representing
 *      index keys.
 *
 *      <cAlias> is the alias to use if successful.
 *
 *      <lFix> Rebuild the indexes ?
 *
 *      <lPack> Pack the  file ?
 *
 *      <aStruct> is the array defining the database
 *      structure if the file is to be built from scratch.
 *  $RETURNS$
 *      cAlias
 *  $DESCRIPTION$
 *      Open a DBF file with indexes, allowing reindexing,
 *      packing and returning the alias.
 *  $EXAMPLES$
 *      // Open customer invoices file indexed on invoice
 *      // number and customer account number, returing the
 *      // alias of INVOICES
 *      IF EMPTY(GT_Open('INVS0293', ;
 *          {'INVS','UPPER(CUSTOMER)'},'INVOICES'))
 *
 *          ? 'Error'
 *
 *      ENDIF
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */
#include "GT_LIB.ch"

MEMVAR cIndexKey

FUNCTION GT_Open(cFile,aIndex,cAlias,lFix,lPack,aStruct)

LOCAL abAssigns := { ;
    { | | cIndex1 := cNtxName + '1' }, ;
    { | | cIndex2 := cNtxName + '2' }, ;
    { | | cIndex3 := cNtxName + '3' }, ;
    { | | cIndex4 := cNtxName + '4' }, ;
    { | | cIndex5 := cNtxName + '5' }, ;
    { | | cIndex6 := cNtxName + '6' }, ;
    { | | cIndex7 := cNtxName + '7' }, ;
    { | | cIndex8 := cNtxName + '8' }, ;
    { | | cIndex9 := cNtxName + '9' } }

LOCAL cBrightMnu := GT_Hilite(SETCOLOR(),'+')
LOCAL cColour := SETCOLOR()
LOCAL cComplete := 'Complete'
LOCAL cFlashMnu := GT_Hilite(SETCOLOR(),'*')
LOCAL cIndex1 := ''
LOCAL cIndex2 := ''
LOCAL cIndex3 := ''
LOCAL cIndex4 := ''
LOCAL cIndex5 := ''
LOCAL cIndex6 := ''
LOCAL cIndex7 := ''
LOCAL cIndex8 := ''
LOCAL cIndex9 := ''
LOCAL cNtxName := ''
LOCAL cPointer := ' ->'
LOCAL cScreen := ''
LOCAL cTitle := ' Mending Datafile '
LOCAL cWorkWait := 'Working'
LOCAL lSuccess := .F.
LOCAL nBottom := 16
LOCAL nCount := 0
LOCAL nIndexes := 0
LOCAL nLeft := 26
LOCAL nRight := 54
LOCAL nTop := 08

PRIVATE cIndexKey := ""

Default cFile to ''
Default aIndex to {}
Default cAlias to ''
Default lFix to .F.
Default lPack to .F.
Default aStruct to {}

nIndexes := LEN(aIndex)
cAlias := UPPER(cAlias)

//  Trim for index name
cNtxName := SUBSTR(cFile,1,RAT('\',cFile)+7)
nCount := AT('.',cNtxName)
IF nCount > 0
    cNtxName := SUBSTR(cNtxName,1,nCount-1)
ENDIF

BEGIN SEQUENCE

    // Select new file handle
    SELECT(0)

    // Extention
    IF .NOT. ('.' $ cFile)
        cFile += '.DBF'
    ENDIF

    // Exists ?
    DO CASE

        CASE FILE(cFile)
            // File found
            lSuccess := .T.

        CASE EMPTY(aStruct)
            // Can't build
            GT_Error('Unable to find <' + cFile + '>')

        OTHERWISE
            // Build
            IF UPPER(CHR(GT_AskUser('The file <' + cFile + ;
                '> does not exists. Do you wish to ' + ;
                'create it? Please check with your ' + ;
                'system manager if you are unsure. (Y/N)', ;
                {ASC('Y'),ASC('N'),ASC('y'),ASC('n')}, ;
                'File Not found', ;
                SETCOLOR(),BOX_DS))) == 'Y'

                // Create
                DBCREATE(cFile,aStruct)
                lSuccess := FILE(cFile)

            ENDIF

    ENDCASE

    // Open file
    IF lSuccess
        lSuccess := (GT_Use(cFile,.T.,cAlias) == cAlias)
    ENDIF

    // Failure
    IF .NOT. lSuccess
        BREAK(NIL)
    ENDIF

    // Indexes exist ?
    FOR nCount := 1 TO nIndexes
        IF .NOT. FILE(cNtxName + STR(nCount,1,0) + '.NTX')
            lFix := .T.
            EXIT
        ENDIF
    NEXT

    IF lFix .OR. lPack
        // Box
        cScreen := SAVESCREEN(00,00,MAXROW(),MAXCOL())
        GT_Window(nTop,nLeft,nBottom,nRight,BOX_SS, ;
            SETCOLOR(),'Updating ....',.T.)

        @ nTop, nLeft + 02 SAY cTitle
        @ nTop + 02, nLeft + 02 SAY 'File: ' + cFile
        @ nTop + 06, nLeft + 02 SAY 'Indexing 0 of ' + ;
            STR(nIndexes,1)

    ENDIF
    IF lPack

        @ nTop + 04, nLeft + 02 SAY 'Packing '  + ;
            STR(LASTREC(),7) + cPointer

        SETCOLOR(cFlashMnu)
        @ nTop + 04, nLeft + 20 SAY cWorkWait
        PACK
        DBGOTOP()
        SETCOLOR(cBrightMnu)

        @ nTop + 04, nLeft + 20 SAY ;
            PADR(LTRIM(STR(LASTREC())),7)

        lFix := .T.

    ENDIF

    // Any indexes
    IF nIndexes > 0

        // Assign Index variables
        AEVAL(abAssigns, { | bData, nElem | EVAL(bData) }, ;
            1,nIndexes)

        IF lFix
            SETCOLOR(cFlashMnu)
            FOR nCount := 1 TO nIndexes
                @ nTop + 06, nLeft + 11 SAY STR(nCount,1)
                cIndexKey := aIndex[nCount]

                INDEX ON &cIndexKey TO (cNtxName + ;
                        STR(nCount,1,0))

            NEXT
            SETCOLOR(cBrightMnu)
            @ nTop + 06, nLeft + 11 SAY cComplete

        ENDIF
        SET INDEX TO (cIndex1), (cIndex2), (cIndex3), ;
            (cIndex4), (cIndex5), (cIndex6), (cIndex7), ;
            (cIndex8), (cIndex9)

    ENDIF

    // Worked ok
    DBGOTOP()
    lSuccess := .T.

ENDSEQUENCE

//  Restore screen
IF lFix .OR. lPack
    RESTSCREEN(00,00,MAXROW(),MAXCOL(),cScreen)
ENDIF

//  Close due to failure
IF .NOT. lSuccess
    USE // Nothing
ENDIF

SETCOLOR(cColour)

/*
    End of GT_Open()
*/
RETURN(UPPER(ALIAS()))
