/*
    File......: GT_Str2a.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_STR2A()
 *  $CATEGORY$
 *      Array
 *  $ONELINER$
 *      Function to convert a string of data to an array.
 *  $SYNTAX$
 *      GT_Str2a(<cString>,<bConvert>],<nLength>) -> aReturn
 *  $ARGUMENTS$
 *      <cString> is a Character string containing fixed
 *      length sub-strings. These sub-strings will be
 *      extracted to be used to form the array.
 *
 *      <bConvert> is the code block which will be passed
 *      the extracted substring and return the converted
 *      data.
 *
 *      <nLength> is the length of each sub-string.
 *  $RETURNS$
 *      GT_Str2a() returns the new array.
 *  $DESCRIPTION$
 *      Function to convert a string of data to an array.
 *      This is generally used to extract data that has
 *      been put into a string for the purposes of storage
 *      to a .mem file. The data can be put into the string
 *      using GT_a2Str().
 *  $EXAMPLES$
 *      // To convert a string of numbers to an array of
 *      // numbers
 *      cNumbers := '112834456378990'
 *
 *      aNumbers := GT_Str2a( ;
 *                      cNumbers, ;
 *                      { | cData | Val(cData) }, ;
 *                      3)
 *
 *      // Giving {112,834,456,378,990}
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION gt_str2a(cString,bConvert,nLength)

Local aResult  := {}
Local nCount := 0
Local nItems := 0
LOCAL nPos := 1

Default cString to ''
Default bConvert to { | | NIL }
Default nLength to 1

//  How many items ?
nItems := LEN(cString) / nLength

//  Create array
aResult := ARRAY(nItems)

//  For each ....
FOR nCount := 1 TO nItems

    // Extract
    aResult[nCount] := EVAL(bConvert, ;
        SUBSTR(cString,nPos,nLength))

    // Next
    nPos += nLength

NEXT

/*
    Complete
*/
RETURN(aResult)
