/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: iplodasc.prg
 * Author....: Andy M Leighton
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Andy Leighton
 * Date......: $Date$
 * Revision..: $Revision$
 *
 * This is an original work by Andy Leighton and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *       GT_IMPLODEASCII()
 *  $CATEGORY$
 *       String
 *  $ONELINER$
 *       Implode an array of ascii values to form a string
 *  $SYNTAX$
 *       GT_ImplodeAscii(<aAscVals>) --> cStr
 *  $ARGUMENTS$
 *       <aAscVals> -  An array of ascii values
 *  $RETURNS$
 *       <cStr>     -  The resultant string
 *  $DESCRIPTION$
 *       Implode an array of ascii values to form a string
 *  $EXAMPLES$
 *       aAscVals := {  72, 101, 108, 108,     ;
 *                     111,  32,  87, 111,     ;
 *                     114, 108, 100        }
 *
 *       ? GT_ImplodeAscii(aAscVals)     // should print Hello World
 *  $SEEALSO$
 *       GT_EXPLODEASCII()
 *  $END$
 */

#include "gt_LIB.ch"

function GT_ImplodeAscii(aAscVals)
   local cStr := ''
   local i

   for i := 1 to len(aAscVals)
      cStr += chr(aAscVals[i])
   next

return cStr
