/*
 * File......: LASTREC.PRG
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "gt_lib.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      GT_LASTREC()
 *  $CATEGORY$
 *      File I/O
 *  $ONELINER$
 *      Get the count of records in a DBF file.
 *  $SYNTAX$
 *      GT_LastRec(<cFileName>) --> nNumberOfRecords
 *  $ARGUMENTS$
 *      <cFileName> is the name of the DBF file. If the name has no
 *      extension it defaults to DBF.
 *  $RETURNS$
 *      The number of records in the DBF file.
 *  $DESCRIPTION$
 *      GT_LastRec() is designed to be the same as the Clipper function
 *      LastRec(). The main change is that it works on un-opened database
 *      files.
 *  $EXAMPLES$
 *      // Print the number of records in a database file.
 *
 *      ? GT_LastRec("Life")
 *  $END$
 */

function GT_LastRec(cFileName)
local nFile    := 0     ,;
      cLastRec := "    ",;
      nLastRec := 0
if valtype(cFileName) == TYPE_CHAR
   if GT_IsDbf(cFileName)
      cFileName := GT_DefExt(cFileName,"Dbf")
      if (nFile := fopen(cFileName,FO_READ)) != F_ERROR
         fseek(nFile,4,FS_SET)
         if fread(nFile,@cLastRec,4) == 4
            nLastRec := bin2l(cLastRec)
         endif
         fclose(nFile)
      endif
   endif
endif
return(nLastRec)
