/*
 * File......: OCCURS.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_OCCURS()
 *  $CATEGORY$
 *      String
 *  $ONELINER$
 *      Count the number of occurences of a character in a string
 *  $SYNTAX$
 *      GT_Occurs( cChar , cString )
 *  $ARGUMENTS$
 *      cChar   - Character to find
 *      cString - String to search
 *  $RETURNS$
 *      The number of occurences
 *  $DESCRIPTION$
 *      Count the number of occurences of a character in a string
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_LIB.ch"

FUNCTION GT_Occurs( cChar , cString )

/****************************************************************************
 Purpose - Count number of occurences of cChar in cString
 Returns - Number of occurences
 Author  - Martin Colloby
 Created - 8/1/91
******************************************************************************
 Parameters - cChar   - Character to find
              cString - String to search
 Privates   - nCount  - Counting variable
              nCount1 - Counting variable
 Externals  - None
****************************************************************************/

LOCAL nCount  := 0
LOCAL nCount1 := 0

FOR nCount1 := 1 TO len( cString )
    IF SUBSTR( cString , nCount1 , 1 ) == cChar
        nCount ++
    ENDIF
NEXT nCount

* Return the count
RETURN( nCount )
*
