/*
 * File......: SERIALNO.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_SERIALNUMBER()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Generate a serial number i.e. the next number in a series.
 *  $SYNTAX$
 *      GT_SerialNumber( cAlias , lError )
 *  $ARGUMENTS$
 *      cAlias - Alias of table
 *      lError - If .T. generate an error message if failed
 *  $RETURNS$
 *      The next serial number in the sequence
 *      -1 if the record could not be locked
 *  $DESCRIPTION$
 *      Generate a serial number i.e. the next number in a series.
 *      Assumes that cAlias is a table containing one field - a numeric
 *      of unspecified name, and only one record.
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */
*
#include "GT_lib.ch"

FUNCTION GT_SerialNumber( cAlias , lError )

/*****************************************************************************
 Purpose - Generate a serial number i.e. the next number in a series.
           Assumes that cAlias is a table containing one field - a numeric
           of unspecified name, and only one record.
 Returns - A numeric that is one greater than the contents of the field
           If the record could not be locked, -1 is returned.
 Author  - Log
 Created - 26/10/92
******************************************************************************
 Parameters - cAlias - Table to take field from
              lError - If .T., display an error message
 Privates   - None
 Locals     - nValue - Value to return
 Externals  - None
*****************************************************************************/

LOCAL cCurrent := ALIAS()
LOCAL xReturn

DEFAULT lError TO .F.

* Select the work area
SELECT ( cAlias )

* Try to lock the record
IF GT_RecLock( 0 )
    * Record locked, so increment the field
    FIELDPUT( 1 , FIELDGET( 1 ) + 1 )

    * Unlock the record
    UNLOCK

    * Return the value
    xReturn := FIELDGET( 1 )
ELSE
    * Do we generate an error message ?
    IF lError
        GT_Warning( { "Could not get serial number" } )
    ENDIF

    * Return the error value
    xReturn := -1
ENDIF

SELECT ( cCurrent )

RETURN( xReturn )
*
