/*
 * File......: SETFATTR.C
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

// NOTE: This code has been written for and compiled with Borland C++
//       Version 3.1
//

#include "gt_mem.h"
#include <extend.h>

// Prototype internal functions.

int     _GetFileAttrs(char *);
Boolean _SetFileAttrs(char *, int);

/*  $DOC$
 *  $FUNCNAME$
 *      GT_FATTRIB()
 *  $CATEGORY$
 *      File I/O
 *  $ONELINER$
 *      Set the attributes of a file.
 *  $SYNTAX$
 *      GT_FAttrib(<cFileName>,<cAttributes>) --> lChangedOk
 *  $ARGUMENTS$
 *      <cFileName> is the name of the file who's attributes are to be
 *      changed.
 *
 *      <cAttributes> are the attributes to be set.
 *  $RETURNS$
 *      A logical value, .T. if the file attributes were changed ok, .F.
 *      if not.
 *  $DESCRIPTION$
 *      GT_FAttrib() can be used to set the attributes of a file.
 *
 *      The available attributes that can be changed are:
 *
 *                     
 *                     Character       Attribute
 *                     
 *                     A               Archive
 *                     H               Hidden
 *                     S               System
 *                     R               Read Only
 *                     
 *
 *      To set an attribute on use the upper case letter, to set the
 *      attribute off use the lower case letter. Any attribute that
 *      is not included in the attribute string is left as it is.
 *  $EXAMPLES$
 *      // Make a file read only.
 *
 *      lOk := GT_FAttrib("Life.42","R")
 *
 *      // Turn on the archive attribute and the hidden attrubite, and
 *      // turn off the read only attribute.
 *
 *      lOk := GT_FAttrib("Life.42","AHr")
 *  $END$
 */

CLIPPER GT_FAttrib()
{
        Boolean AllOk       = FALSE;
        int     Attrs       = 0;
        char    *FileName   = NULL;
        char    *Attributes = NULL;
        int     CharCount;
        int     MaxAttr;

        if (PCOUNT >= 2 && ISCHAR(1) && ISCHAR(2))
        {
                FileName   = _parc(1);
                Attributes = _parc(2);
                MaxAttr    = _parclen(2);
                Attrs      = _GetFileAttrs(FileName);
                if (Attrs != -1)
                {
                        for (CharCount = 0; CharCount < MaxAttr; CharCount++)
                        {
                                switch (Attributes[CharCount])
                                {
                                        case 'a' : Attrs &= (~0x20) ; break;
                                        case 'A' : Attrs |= 0x20    ; break;
                                        case 'h' : Attrs &= (~0x2)  ; break;
                                        case 'H' : Attrs |= 0x2     ; break;
                                        case 'r' : Attrs &= (~0x1)  ; break;
                                        case 'R' : Attrs |= 0x1     ; break;
                                        case 's' : Attrs &= (~0x4)  ; break;
                                        case 'S' : Attrs |= 0x4     ; break;
                                }
                        }
                        AllOk = _SetFileAttrs(FileName,Attrs);
                }
        }
        _retl(AllOk);
}

/*****************************************************************************
* Function: _GetFileAttrs()                                                  *
* Syntax..: int _GetFileAttrs(char *FileName)                                *
* Usage...: Internal function to get the attributes of a file.               *
* By......: David A Pearson                                                  *
*****************************************************************************/

static int _GetFileAttrs(char *FileName)
{
        int     FileNameSeg = _GT_FP_SEG(FileName);
        int     FileNameOff = _GT_FP_OFF(FileName);
        int     Attrs       = 0;

        asm     Push    DS
        asm     Mov     AH,0x43
        asm     Mov     AL,0h
        asm     Mov     DS,FileNameSeg
        asm     Mov     DX,FileNameOff
        asm     Int     0x21
        asm     Jc      BadFile
        asm     Mov     Attrs,CX
        asm     Jmp     AllDone
BadFile:
        Attrs = -1;
AllDone:
        asm     Pop     DS
        return(Attrs);
}

/*****************************************************************************
* Function: _SetFileAttrs()                                                  *
* Syntax..: int _SetFileAttrs(char *FileName, int Attrs)                     *
* Usage...: Internal function to set the attributes of a file.               *
* By......: David A Pearson                                                  *
*****************************************************************************/

static Boolean _SetFileAttrs(char *FileName, int Attrs)
{
        int     FileNameSeg = _GT_FP_SEG(FileName);
        int     FileNameOff = _GT_FP_OFF(FileName);
        Boolean AllOk       = FALSE;

        asm     Push    DS
        asm     Mov     AH,0x43
        asm     Mov     AL,0x01
        asm     Mov     CX,Attrs
        asm     Mov     DS,FileNameSeg
        asm     Mov     DX,FileNameOff
        asm     Int     0x21
        asm     Jc      BadFile
        AllOk = TRUE;
BadFile:
        asm     Pop     DS
        return(AllOk);
}
