/*
 * File......: STRZERO.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *      GT_STRZERO()
 *  $CATEGORY$
 *      String
 *  $ONELINER$
 *      Convert a numeric to a string padded with leading zeros
 *  $SYNTAX$
 *      GT_StrZero( nNumber , nLength , nDecimals )
 *  $ARGUMENTS$
 *      nNumber   - Number to convert
 *      nLength   - Length of string required - Optional if nDecimals noy used
 *      nDecimals - Number of decimals to simulate - Optional
 *  $RETURNS$
 *      A string padded with zeroes to the left
 *  $DESCRIPTION$
 *      Takes a number and converts it to a string.  If nLength is specified
 *      the string is left padded with zeroes.
 *      If nDecimals is specified, the string will have that many decimal
 *      places
 *  $EXAMPLES$
 *      GT_StrZero( 5 , 2 )       -> "05"
 *      GT_StrZero( 300 , 8 , 2 ) -> "00300.00"
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */
*
FUNCTION GT_StrZero( nNumber , nLength , nDecimals )

/*****************************************************************************
 Purpose - Convert a numeric to a string padded with leading zeros
 Returns - None
 Author  - Martin Colloby
 Created - 05/08/92
******************************************************************************
 Parameters - None
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

LOCAL cNumber:= ""

DO CASE
    CASE PCOUNT() == 3
        cNumber := STR( nNumber , nLength , nDecimals )
    CASE PCOUNT() == 2
        cNumber := STR( nNumber , nLength )
    CASE PCOUNT() == 1
        cNumber := STR( nNumber )
ENDCASE

IF "-" $ cNumber
    // Negative number, move the minus sign in front of zeros
    RETURN "-" + REPLICATE( "0" , LEN( cNumber ) - LEN( LTRIM( cNumber ) ) ) + ;
           SUBSTR( cNumber , AT( "-" , cNumber ) + 1 )
ENDIF

// Positive number
RETURN REPLICATE( "0" , LEN( cNumber ) - LEN( LTRIM( cNumber ) ) ) + ;
       LTRIM( cNumber )
*
