/*
--------------------------------------------------------------------------
KERNEL.H (Image Processing System Kernel header file)

AUTHOR:  Craig Muller 1991,1992,1993

Description:

This header file is designed for those modules which are system independent,
that is they can be compiled for DOS or Windows Applications without any
changes. DO NOT MODIFY THESE INCLUDES! otherwise they may loose
compatibility with the rest of the system.

This file includes the general equates used for all of the image processing
code in part two of Craig Lindley's book 'Practical Image Processing in C'.
--------------------------------------------------------------------------
*/
#if !defined( KERNEL_H )               // Prevent multiple includes

#define KERNEL_H

#define  PI      3.14159
#define  TRUE        1
#define  FALSE       0

#define  VIDEO    0x10
#define  MAXW      1024                // Maximum image width in pixels
#define  MAXH      1024                // Maximum image height in pixels

// Backward compatibility defines for older versions of IWF
#define  FB       IMAGE

// Common Macros
#define  MK_HPIMAGE(image,hp,x,y)  (BYTE huge *)(hp+(DWORD)(image->vres-1-y)*image->scansize+x)
#define  MIN(a,b) ((a)>(b)) ? (b):(a)
#define  MAX(a,b) ((a)>(b)) ? (a):(b)
#define  SQUARE(x) (x)*(x)


// The following code is unique to windows programs developed using this library.

#if !defined(__WINDOWS_H)

#ifndef __BOOL
	#define __BOOL
	typedef int BOOL;
#endif

#ifndef __BYTE
   #define __BYTE
   typedef unsigned char BYTE;
#endif

#ifndef __WORD
   #define __WORD
   typedef unsigned WORD;
#endif

#ifndef __DWORD
   #define __DWORD
   typedef unsigned long DWORD;
#endif

typedef struct tagPOINT
  {
  int x;
  int y;
  } POINT;

typedef struct tagRECT
  {
	 int  left;
	 int  top;
	 int  right;
	 int  bottom;
  } RECT;

#endif


//-------------------------------------
// Image file profile structure
//-------------------------------------
typedef struct tag_profile
	{
	int hsize;
	int width;
	int height;
	int depth;

	} PROFILE;

//-------------------------------------
// Image data structure
//-------------------------------------
typedef struct tag_IMAGE                         // Image structure
   {
   char fspec[80];                               // File path specifier
   char comment[80];                             // Comments about the image

   int encode;                                   // Compression flag
   int color;                                    // Color palette flag
   int scansize;                                 // # bytes per scan line
   int palsize;                                  // Palette size
   int hres;                                     // Hres of image        
   int vres;                                     // Vres of image        
	int depth;                                    // Pixel depth

	float gamma;                                  // Gamma value

   RECT    rc;                                   // Processing rectangle
   HANDLE  hData;                                // Handle to pixel data  
	WORD    ILUT[256];                            // Input lookup table

	PALETTEENTRY Pal[256];                        // Base palette data
	PALETTEENTRY LUT[256];                        // Display Look Up Table data
	} IMAGE;

typedef struct tag_filter
   {
   char name[20];
   int  width;
   int  height;
   int  divisor;
   int  scale;
   int  absolute;
   int  data[3][3];
   } FILTER;


//--------------------------------------------------------------------------
// Global function declarations.
//--------------------------------------------------------------------------

// Image input and output functions (IMAGEIO.C)
IMAGE *CreateImage(int hres,int vres);
IMAGE *DestroyImage(IMAGE *image);
IMAGE *MirrorImage(IMAGE *origin);
IMAGE *FlipImage  (IMAGE *origin);
IMAGE *ReduceImage(IMAGE *image,int reduction);
IMAGE *ScaleImage (IMAGE *origin,int w,int h);
IMAGE *RotateImage(IMAGE *origin,int dir);
IMAGE *DuplicateImage(IMAGE *fb_old);
void ClearImage   (IMAGE *image);
void CopyImageData(IMAGE *image_src,IMAGE *image_dst);
void CopyImagePal (IMAGE *fbsrc,IMAGE *fbdst);
int  GetImagePixel(IMAGE *image,int x,int y,BYTE *dn);
int  SetImagePixel(IMAGE *image,int x,int y,BYTE  dn);
int  GetImageScan (IMAGE *image,int y,BYTE *dn);
int  GetImageRow  (IMAGE *image,int x,int y,BYTE *dn,int cb);
int  PutImageRow  (IMAGE *image,int x,int y,BYTE *dn,int cb);
int  SetImageRow  (IMAGE *image,int x,int y,int Length,BYTE  dn);
int  GetImageCol  (IMAGE *image,int x,int y,BYTE *dn,int cb);
int  PutImageCol  (IMAGE *image,int x,int y,BYTE *dn,int cb);
int  SetImageCol  (IMAGE *image,int x,int y,int Length,BYTE  dn);
int  GetImageRect (IMAGE *image,RECT *r,BYTE *buf);
int  PutImageRect (IMAGE *image,RECT *r,BYTE *buf);
int  SetImageRect (IMAGE *image,RECT *r,BYTE dn);

// Image file loading and saving procedures
IMAGE *LoadMTX(char *fspec);
IMAGE *LoadPIC(char *fspec);
IMAGE *LoadPCX(char *fspec);
IMAGE *LoadIMG(char *fspec);
IMAGE *LoadFTS(char *fspec,int pshift);
IMAGE *LoadSBI(char *fspec,int pshift);
IMAGE *LoadUSR(char *fspec,int hsize,int width,int height,int depth,int pshift);
int  SaveMTX(IMAGE *image,char *fspec);
int  PCXSave(IMAGE *image,char *fspec);

// Image area operations (AREA.C)
int  FBArMedian    (IMAGE *image_src,RECT *r,WORD NeighCols,WORD NeighRows,IMAGE *image_dst);
int  FBArSobelEdge (IMAGE *image_src,RECT *r,WORD Threshold,BOOL Overlay,IMAGE *image_dst);

// MATROX Data transfer functions.
int im_PasteFromMem(BYTE huge *hpData,int fbx);
int im_CopyToMem(int fbx,BYTE huge *hpData);

// MATROX Frame buffer functions.
void im_getraster(int fbx,int y,BYTE far *raster);
void im_getpixel (int fbx,int x,int y,WORD *dn);
void im_setpixel (int fbx,int x,int y,WORD dn);
void im_getrow   (int fbx,int x,int y,int cb,BYTE far *colbuf);
void im_getcol   (int fbx,int x,int y,int cb,BYTE far *colbuf);
void im_View     (int fbx);
void im_Rectangle(int fbx,int x0, int y0, int w, int h);

// MATROX Lookup Table operations.
int LUTXColorOverlay(void);
int LUTXLoad();

#endif

