// ----------------------------------------------------------------------------
// (c) 1,994 Juan Miguel Sosso Prieto - Todos los derechos reservados
// Autor...: Juan Miguel Sosso
// Proyecto: Sosso's Professional Tools
// Mdulo..: Demostracin
// Fecha...: Thu  28-04-94
// Hora....: 15:56:21

#include "inkey.ch"
#include "sptools.ch"

// ----------------------------------------------------------------------------

proc Main()

   INICIALIZE SYSTEM COLOR "W+/N*" ;
                     CLOCK ;
                     CALCULATOR KEY K_F2 ;
                     CALENDAR KEY K_F3 ;
                     SAVE DOS SCREEN ;
                     SCREEN BLANK MINUTES 3 MESSAGE "SPTOOLS 1.0/"

   OPEN stock INDEX Stock->cCODIGO

//   FillVideo( "" )

   ACTIVATE MENU oMainMenu()

   CLOSE SYSTEM

return

// ----------------------------------------------------------------------------

static function oMainMenu()

   local oMenu

   MENU oMenu
      MENUITEM " &Stock " MESSAGE "Stock"
      MENU
         MENUITEM " &Stock...   Alt-T " ACTION MnuStock() ;
                                        SHORTCUT K_ALT_T ;
                                        MESSAGE "Stock maintenance"
         MENUITEM " &Error "            ACTION DevOut( Str( "not a number" ) ) ;
                                        MESSAGE "Produce an error, see ERROR.LOG file"
         SEPARATOR
         MENUITEM " E&xit       Alt-X " ACTION oMenu:lEnd := .t. ;
                                        SHORTCUT K_ALT_X ;
                                        MESSAGE "Exit the demostration program"
      ENDMENU

      MENUITEM " &Utilities " MESSAGE "Miscelaneous utilities"
      MENU
         MENUITEM " Calculator   F&2 " ACTION Calculator() ;
                                       MESSAGE "Calculator"
         MENUITEM " Calendar     F&3 " ACTION Calendar() ;
                                       MESSAGE "Calendar with appoinments"
      ENDMENU

      MENUITEM " &Credits " MESSAGE "Library credits"
      MENU
         MENUITEM " &About...   F1 " ACTION MnuAbout() ;
                                     SHORTCUT K_F1 ;
                                     MESSAGE "Credits about Sosso's Professional Tools"
      ENDMENU
   ENDMENU

return oMenu

// ----------------------------------------------------------------------------

static proc MnuStock()

   local oBrwStock
   local oMnuStock

   MENU oMnuStock AT MaxRow()
      MENUITEM " &Edit "   ACTION If( lEditArt(), oBrwStock:RefreshAll(), nil )
      MENUITEM " &Add "    ACTION If( lAddArt(), oBrwStock:RefreshAll(), nil )
      MENUITEM " &Delete " ACTION DelArt( oBrwStock )
      MENUITEM " E&xit "   ACTION .t.  // End Browse
   ENDMENU

   oMnuStock:lOpened = .f.

   BROWSE oBrwStock SIZE MaxRow() - 3, 72
      COLUMN "REF."        DATA Stock->cCODIGO ;
                           FOOT "TOTAL:"
      COLUMN "DESCRIPTION" DATA Stock->cDESC ;
                           FOOT Transform( LastRec(), "9,999 recs." )
      COLUMN "PRICE"       DATA Stock->nPRECIO
      COLUMN "IVA"         DATA Stock->nIVA
      COLUMN "TOTAL"       DATA Transform( Stock->nPRECIO + Stock->nPRECIO * ;
                                           Stock->nIVA / 100, "999,999" ) ;
                           COLOR "GR+/B"
      ON DBLCLICK DO If( lEditArt(), oBrwStock:RefreshAll(), nil )
   ENDBROWSE

   ACTIVATE BROWSE oBrwStock ;
      TITLE "STOCK BROWSE" ;
      MENUBAR oMnuStock

return

// ----------------------------------------------------------------------------

static function lEditArt()

   local GetList := {}
   local aFields := {}
   local oWndArt
   local lSaved  := .t.

   DEFINE WINDOW oWndArt SIZE 10, 57 TITLE "EDIT ARTICLE"
   ACTIVATE WINDOW oWndArt

   Stock->( SaveFields( aFields ) )

   @ 2,  2 SAY "REFERENCE..:" GET Stock->cCODIGO ;
                              MESSAGE "Reference of the article"
   @ 3,  2 SAY "DESCRIPTION:" GET Stock->cDESC ;
                              MESSAGE "Full description"
   @ 4,  2 SAY "PRICE......:" GET Stock->nPRECIO ;
                              MESSAGE "Price without taxes"
   @ 5,  2 SAY "I.V.A......:" GET Stock->nIVA ;
                              MESSAGE "I.V.A. (European tax)"
   @ 7, 15 BUTTON "    &OK    " ACTION BTN_OK ;
                                MESSAGE "Save the changes"
   @ 7, 30 BUTTON "  &Cancel  " ACTION BTN_CANCEL ;
                                MESSAGE "Ignore the changes"

   READ

   if LastKey() == K_ESC
      Stock->( RestFields( aFields ) )
      lSaved = .f.
   endif

   DEACTIVATE WINDOW oWndArt

return lSaved

// ----------------------------------------------------------------------------

static function lAddArt()

   local nLast  := Stock->( RecNo() )
   local lAdded := .t.

   Stock->( DbAppend() )

   if ! lEditArt()
      Stock->( DbDelete() )
      Stock->( DbGoto( nLast ) )
      lAdded = .f.
   endif

return lAdded

// ----------------------------------------------------------------------------

static proc DelArt( oBrw )

   if nMsgBox( "Are you sure to delete the record?", ;
               { "  &Delete  ", "  &Cancel  " } ) == 1
      Stock->( DbDelete() )   // Borro el registro
      Stock->( DbSkip() )     // Paso al siguiente
      oBrw:RefreshAll()       // Orden de refrescar el TBrowse
   endif

return

// ----------------------------------------------------------------------------

static proc MnuAbout()

   nMsgBox( "Sosso's Professional Tools 1.0 for CA-Clipper 5.x;" + ;
            cCopyRight() + " 1,994 Juan Miguel Sosso;c/ Mlaga 40, 3;" + ;
            "29600 Marbella (MA);;MARBELLA TRONSOFT BBS  2:341/18.97@fidonet.org;" + ;
            "+34-5-286-2626 (24h) up to 28,800 bps",, ;
            , "About..." )

return

// ----------------------------------------------------------------------------
