// ----------------------------------------------------------------------------
// (c) 1,994 Juan Miguel Sosso Prieto - Todos los derechos reservados
// Autor...: Juan Miguel Sosso
// Proyecto: SixREPORT
// Mdulo..: Include
// Fecha...: Mon  26-09-94
// Hora....: 13:39:50

// ----------------------------------------------------------------------------

#command DEFINE REPORT [ <ReportDef,...> ] ;
      => ;
         REPORT [ <ReportDef> ]

#command REPORT <oRpt> ;
         [ PAGE LEN    <nPageLen> ] ;
         [ LEFT MARGIN <nLeftMargin> ] ;
         [ SEPARATOR   <cSeparator> ] ;
      => ;
         <oRpt> := oRptStartDef( <nPageLen>, <nLeftMargin>, <cSeparator> )

#command HEADER <xHeader> ;
         [ <lCenter: CENTER> ] ;
      => ;
         RptAddHeader( <xHeader>, <.lCenter.> )

#command COLUMN [<cTitle>] PRINT <bData> ;
                         [ FOOT <bFoot> ] ;
                         [ <lCenter: CENTER> ] ;
      => ;
         RptAddColumn( <(cTitle)>, <{bData}>, <{bFoot}>, <.lCenter.> )

#command FOOT <xHeader> ;
         [ <lCenter: CENTER> ] ;
      => ;
         RptAddFoot( <xHeader>, <.lCenter.> )

#command ENDREPORT ;
      => ;
         RptEndDef()

#command END REPORT ;
      => ;
         RptEndDef()

#command ACTIVATE REPORT <oRpt> ;
         [ WHILE <xWhile> ] ;
         [ ACTION <xAction> ] ;
      => ;
         while <xWhile> ;;
            <oRpt>:Run() ;;
            <xAction> ;;
         enddo

// ----------------------------------------------------------------------------

#command ACTIVATE PRINTER ;
      => ;
         SET CONSOLE OFF ;;
         SET PRINT ON ;;
         RedefError( .t. ) ;;
         BEGIN SEQUENCE

#command DEACTIVATE PRINTER ;
      => ;
         END SEQUENCE ;;
         RedefError( .f. ) ;;
         SET PRINT OFF ;;
         SET CONSOLE ON

#command START LISTING ;
         [ HEADER <cCab> ] ;
         [ PAGE LEN <nPageLen> ] ;
         [ PRINT LINE <bPrintLine> ] ;
         [ END CONDITION <bEndCond> ] ;
         [ INIT STRING <cInitCod> ] ;
         [ RESET STRING <cEndCod> ] ;
         [ LEFT MARGIN <nLeft> ] ;
      => ;
         StartList( <cCab>, <nPageLen>, <{bPrintLine}>, <{bEndCond}>, ;
                    <cInitCod>, <cEndCod>, <nLeft> )

// ----------------------------------------------------------------------------
// Cdigos para impresoras matriciales

#define ONE_LINE_DOUBLE Chr( 14 )
#define CONDENSED_ON    Chr( 15 )
#define CONDENSED_OFF   Chr( 18 )

// ----------------------------------------------------------------------------
