// ----------------------------------------------------------------------------
// Mdulo include para SIXWND.LIB
// (c) 1,994 Juan Miguel Sosso - Todos los derechos reservados
// ----------------------------------------------------------------------------

#command DEFINE WINDOW [ <WindowDef,...> ] ;
      => ;
         WINDOW [ <WindowDef> ]

#command WINDOW <oWnd> ;
         [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
         [ SIZE <nAlto>, <nAncho> ] ;
         [ TITLE <cTitle> ] ;
         [ FRAME <cFrame> ] ;
         [ COLOR <cColor> ] ;
      => ;
         <oWnd> := TWindow():New( <nTop>, <nLeft>, <nBottom>, <nRight>, ;
                                  <nAlto>, <nAncho>, <cTitle>, <cFrame>, ;
                                  <cColor> )

#command SHOW WINDOW <oWnd> ;
      => ;
         <oWnd>:Display()

#command ACTIVATE WINDOW <oWnd> ;
      => ;
         <oWnd>:Display() ;;
         <oWnd>:Activate()

#command DEACTIVATE WINDOW <oWnd> ;
      => ;
         <oWnd>:DeActivate() ;;
         <oWnd>:Hide()


#command RELEASE WINDOW <oWnd> ;
      => ;
         <oWnd>:DeActivate() ;;
         <oWnd>:Hide() ;;
         <oWnd> := nil

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

#translate bSETGET( <xVar> ) => { | x | If( x == nil, <xVar>, <xVar> := x ) }

// ----------------------------------------------------------------------------
// @..SAY

#command @ <nRow>, <nCol> SAY <xExp> ;
         [ PICTURE <cPic> ] ;
         [ COLOR <cColor> ] ;
         [ <lAbs:ABSOLUTE> ] ;
      => ;
         DispText( <nRow>, <nCol>, <xExp>, <cPic>, <cColor>, <.lAbs.> )

// ----------------------------------------------------------------------------
// @..GET

#command @ <nRow>, <nCol> GET <var> ;
         [ PICTURE <cPic> ] ;
         [ VALID <bValid> ] ;
         [ WHEN <bWhen> ] ;
         [ SEND <msg> ] ;
         [ MESSAGE <cMsg> ] ;
      => ;
         SetPos( __nTop() + <nRow>, __nLeft() + <nCol> ) ;;
         AAdd( GetList, _GET_( <var>, <(var)>, <cPic>, <{bValid}>, <{bWhen}> ) ) ;;
         MOff() ;;
         ATail( GetList ):ColorSpec := __cClrGET() ;;
         ATail( GetList ):Display() ;
         [; ATail( GetList ):<msg> ] ;
         [; ATail( GetList ):Cargo := <cMsg> ] ;
         ; MOn()

// ----------------------------------------------------------------------------
// @..SAY..GET

#command @ <nRow>, <nCol> SAY <sayxpr> ;
         [ <sayClauses,...> ] ;
         GET <var> ;
         [ <getClauses,...> ] ;
      => ;
         @ <nRow>, <nCol> SAY <sayxpr> [ <sayClauses> ] ;;
         @ Row() - __nTop(), Col() + 1 - __nLeft() GET <var> [ <getClauses> ]

// ----------------------------------------------------------------------------
// @..BUTTON

#command @ <nRow>, <nCol> BUTTON <cPrompt> ;
         [ <action:ACTION,EXECUTE,EXEC> <uAction> ] ;
         [ WHEN <uWhen> ] ;
         [ VALID <uValid> ] ;
         [ COLOR <cColors> ] ;
         [ MESSAGE <cMsg> ] ;
      => ;
         AAdd( GetList, TButton():New( __nTop() + <nRow>, __nLeft() + <nCol>, ;
               <cPrompt>, <{uAction}>, <{uWhen}>, <{uValid}>, <cColors>, ;
               <cMsg> ) ) ;;
         ATail( GetList ):Display()

// ----------------------------------------------------------------------------
// @..CHECK

#command @ <nRow>, <nCol> GET <lVar> CHECK <cPrompt> ;
         [ WHEN <uWhen> ] ;
         [ VALID <uValid> ] ;
         [ COLOR <cColors> ] ;
         [ MESSAGE <cMsg> ] ;
      => ;
         AAdd( GetList, TCheck():New( __nTop() + <nRow>, __nLeft() + <nCol>, ;
               bSETGET( <lVar> ), <cPrompt>, <{uWhen}>, <{uValid}>, <cColors>, ;
               <cMsg> ) ) ;;
         ATail( GetList ):Display()

#command @ <nRow>, <nCol> CHECK <cPrompt> GET <lVar> ;
         [ WHEN <uWhen> ] ;
         [ VALID <uValid> ] ;
         [ COLOR <cColors> ] ;
         [ MESSAGE <cMsg> ] ;
      => ;
         AAdd( GetList, TCheck():New( __nTop() + <nRow>, __nLeft() + <nCol>, ;
               bSETGET( <lVar> ), <cPrompt>, <{uWhen}>, <{uValid}>, <cColors>, ;
               <cMsg> ) ) ;;
         ATail( GetList ):Display()

// ----------------------------------------------------------------------------
// READ

#command READ SAVE ;
         [ ON CLICK <bClick> ] ;
      => ;
         SetCursor( 3 ) ;;
         ReadModal( GetList,, <{bClick}> ) ;;
         SetCursor( 0 ) ;;

#command READ ;
         [ ON CLICK <bClick> ] ;
      => ;
         SetCursor( 3 ) ;;
         ReadModal( GetList,, <{bClick}> ) ;;
         SetCursor( 0 ) ;;
         GetList := {}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// Terminal I/O SETs

#command SET CURSOR <x:ON,OFF,&>                                        ;
      => SetCursor( if(Upper(<(x)>) == "ON", 3, 0) )

#command SET CURSOR (<x>)                                               ;
      => SetCursor( if(<x>, 3, 0) )

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

#xcommand DEFAULT <uVar1> := <uVal1> ;
               [, <uVarN> := <uValN> ] ;
       => ;
          <uVar1> := If( <uVar1> == nil, <uVal1>, <uVar1> ) ;;
          [ <uVarN> := If( <uVarN> == nil, <uValN>, <uVarN> ); ]

#xcommand SET DEFAULT ACTION TO <uAction> ;
       => ;
          SetDefAction( <{uAction}> )

#xcommand SAVE DESKTOP ;
       => ;
          Desktop( .t. )

#xcommand RESTORE DESKTOP ;
       => ;
          Desktop( .f. )

#xcommand INICIALIZE SYSTEM ;
          [ COLOR <cClr> ] ;
          [ <mouse:NOMOUSE> ] ;
       => ;
          _InitSys( <cClr>, <.mouse.> )

#xcommand CLOSE SYSTEM ;
       => ;
          _CloseSys()

// ----------------------------------------------------------------------------

#define WND_CLR_BORDER     1
#define WND_CLR_TITLE      2
#define WND_CLR_TEXT       3
#define WND_CLR_FOCUS      4
#define WND_CLR_GET        5
#define WND_CLR_BUTTON     6
#define WND_CLR_HOT_BUTTON 7
#define WND_CLR_CHECK      8
#define WND_CLR_HOT_CHECK  9

#define BTN_OK     __KeyBoard( Chr( 23 ) )
#define BTN_CANCEL __KeyBoard( Chr( 27 ) )

// ----------------------------------------------------------------------------
