100 'AMORTGW.BAS       Copyright 1993 by JN Goodale
110 'Date: [93-12-20]
111 '
112 '   *** NOTE ***
113 '   This program is included for the purpose of demonstrating BASICXR.
114 '   The program works correctly, but may contain errors if run with
115 '       unusual input.  The author assumes no responsibility for making
116 '       corrections to AMORTGW.BAS!
117 '
120 'Desc: Amortization of a Loan - Find Amount of Level Payment
140 '
150 '      P=Principal
160 '      R=Interest Rate
170 '      I=Interest/Period
180 '      N=Number of Payments (Periods)
190 '      A=Amount of Level Payment
200 '
210 '
220 '
230 '                 P * I
240 '        A =   --------------
250 '                      1
260 '              1 -  --------
270 '                   (1+I) ^N           Where ^N is "to the Nth Power"
280 '
290 '.......................................................................
300 '
310 '
320 DIM TEXT$(24)
330 '               0         1         2         3         4         5
340 '           123456789 123456789 123456789 123456789 123456789 123456789
350 TEXT$(1) = "                             [ LOAN AMORTIZATION ]"
360 TEXT$(2) = " "
370 TEXT$(3) = "      Calculate a Level Loan Payment, given:"
380 TEXT$(4) = "          Loan Principal, nearest full $  (Max 500000)"
390 TEXT$(5) = "          Interest Rate per Year (Max 30.00), Full %, as in 7.75 = 7.75%"
400 TEXT$(6) = "          Number of months to Pay  (Max 480)"
410 TEXT$(7) = "                I.E. 30 Years = 360 Months"
420 TEXT$(8) = "                      4 Years =  48 Months"
430 TEXT$(9) = STRING$(79, 220)
440 TEXT$(10) = "      Enter Amount of PRINCIPAL:             (Q-to Quit)"
450 TEXT$(11) = "          Enter Interest Rate %: "
460 TEXT$(12) = "         Enter Number of Months: "
470 TEXT$(13) = " "
480 TEXT$(14) = "     The MONTHLY Payment on the above loan would be:  $"
490 TEXT$(15) = " "
500 TEXT$(16) = "          V-To View loan schedule"
510 TEXT$(17) = "          Q-To Quit"
520 TEXT$(18) = " "
530 TEXT$(19) = " "
540 TEXT$(20) = "                           Choice ? _"
550 TEXT$(21) = " "
560 TEXT$(22) = " "
570 TEXT$(23) = " "
580 TEXT$(24) = " "
590 '            123456789 123456789 123456789 123456789 123456789 123456789
600 '                0         1         2         3         4         5
610 '
620 DIM HEADING$(3)
630 HEADING$(1) = "              [ Loan Amortization Table ]"
640 HEADING$(2) = "     Payment #   Balance      Interest     Principal"
650 HEADING$(3) = " "
660 '
670 E0$ = "#######": E2$ = "#######.##": EI$ = "####"
720 KEY OFF
750 CLS
760 FOR I = 1 TO 10: PRINT TEXT$(I): NEXT I
770 LOCATE 10, 34: LINE INPUT PRINCIPAL$
780 IF (PRINCIPAL$ = "Q") OR (PRINCIPAL$ = "q") THEN GOTO 1270
790 N = INSTR(PRINCIPAL$, ".")
800 IF N THEN PRINCIPAL$ = LEFT$(PRINCIPAL$, N - 1)
810 PRINCIPAL = VAL(PRINCIPAL$)
820 IF PRINCIPAL < 1 THEN GOTO 750
830 IF PRINCIPAL > 500000! THEN GOTO 750
840 LOCATE 11, 1: PRINT TEXT$(11)
850 '
870 LOCATE 11, 35: LINE INPUT INTERESTRATE$
880 INTERESTRATE = VAL(INTERESTRATE$) / 1200
890 IF (INTERESTRATE > 0) AND (INTERESTRATE < 30 / 1200) THEN GOTO 940
900   LOCATE 11, 35
910   PRINT SPACE$(10);
920   GOTO 870
940 LOCATE 12, 1: PRINT TEXT$(12)
950 '
970  LOCATE 12, 35: LINE INPUT MONTHS$
980  MONTHS% = VAL(MONTHS$) \ 1
990  MONTHS = MONTHS%
1000 IF (MONTHS% > 0) AND (MONTHS% < 481) THEN GOTO 1070
1010   LOCATE 12, 35
1020   PRINT SPACE$(10);
1030   GOTO 970
1050 '
1070 X = (1 + INTERESTRATE) ^ MONTHS%
1080 Y = 1 / X
1090 Z = 1 - Y
1100 AMOUNT = (PRINCIPAL * INTERESTRATE) / Z
1110 '
1130 LOCATE 14, 1
1140 FOR I = 14 TO 20: PRINT TEXT$(I): NEXT I
1150 LOCATE 14, 57: PRINT USING E2$; (AMOUNT);
1160 LOCATE 20, 37
1170 '
1190 K$ = INKEY$
1200 IF K$ = "" THEN GOTO 1190
1210 IF K$ = "q" THEN GOTO 1270
1220 IF K$ = "Q" THEN GOTO 1270
1230 IF K$ = "V" THEN GOSUB 1310
1235 IF K$ = "v" THEN GOSUB 1310
1240 GOTO 750
1250 '
1270 CLS
1280 END
1290 '
1310 GOSUB 1560: BALANCE = PRINCIPAL
1320 FOR I% = 1 TO MONTHS%
1330 INTERESTPAY = BALANCE * INTERESTRATE
1340 PRINCIPALPAY = AMOUNT - INTERESTPAY
1350 BALANCE = BALANCE - PRINCIPALPAY
1360 ROW = ROW + 1
1370 IF ROW > 22 THEN GOSUB 1490
1380 IF K$ = "Q" THEN RETURN
1390 PRINT "          ";
1400 PRINT USING EI$; (I%); : PRINT "   ";
1410 PRINT USING E0$; BALANCE; : PRINT "    ";
1420 PRINT USING E2$; INTERESTPAY; : PRINT "    ";
1430 PRINT USING E2$; PRINCIPALPAY
1440 NEXT I%
1450 GOSUB 1490
1460 RETURN
1470 '
1490 PRINT
1500 PRINT TAB(20); "Q-To Quit,   Any Other Key to Continue ......";
1520 K$ = INKEY$
1530 IF K$ = "" THEN GOTO 1520
1540 IF K$ = "q" THEN K$ = "Q"
1560 CLS
1570 IF K$ = "Q" THEN RETURN
1580 FOR ROW = 1 TO 3: PRINT HEADING$(ROW): NEXT ROW
1590 RETURN

