'AMORTQB.BAS       Copyright 1993 by JN Goodale
'Date: [93-12-20]
'
'   *** NOTE ***
'   This program is included for the purpose of demonstrating BASICXR.
'   The program works correctly, but may contain errors if run with
'       unusual input.  The author assumes no responsibility for making
'       corrections to AMORTQB.BAS!
'
'Desc: Amortization of a Loan - Find Amount of Level Payment
'
'
'      P=Principal
'      R=Interest Rate
'      I=Interest/Period
'      N=Number of Payments (Periods)
'      A=Amount of Level Payment
'
'
'
'                 P * I
'        A =   --------------
'                      1
'              1 -  --------
'                   (1+I) ^N           Where ^N is "to the Nth Power"
'
'.......................................................................


DIM text$(24)
'               0         1         2         3         4         5
'           123456789 123456789 123456789 123456789 123456789 123456789
text$(1) = "                             [ LOAN AMORTIZATION ]"
text$(2) = " "
text$(3) = "      Calculate a Level Loan Payment, given:"
text$(4) = "          Loan Principal, nearest full $  (Max 500000)"
text$(5) = "          Interest Rate per Year (Max 30.00), Full %, as in 7.75 = 7.75%"
text$(6) = "          Number of months to Pay  (Max 480)"
text$(7) = "                I.E. 30 Years = 360 Months"
text$(8) = "                      4 Years =  48 Months"
text$(9) = STRING$(80, 220)
text$(10) = "      Enter Amount of PRINCIPAL:             (Q-to Quit)"
text$(11) = "          Enter Interest Rate %: "
text$(12) = "         Enter Number of Months: "
text$(13) = " "
text$(14) = "     The MONTHLY Payment on the above loan would be:  $"
text$(15) = " "
text$(16) = "          V-To View loan schedule"
text$(17) = "          Q-To Quit"
text$(18) = " "
text$(19) = " "
text$(20) = "                           Choice ? _"
text$(21) = " "
text$(22) = " "
text$(23) = " "
text$(24) = " "
'            123456789 123456789 123456789 123456789 123456789 123456789
'                0         1         2         3         4         5

DIM heading$(3)
heading$(1) = "              [ Loan Amortization Table ]"
heading$(2) = "     Payment #   Balance      Interest     Principal"
heading$(3) = " "

E0$ = "#######": E2$ = "#######.##": EI$ = "####"

StartProcess:
GetPrincipal:
    CLS
    FOR i = 1 TO 10: PRINT text$(i): NEXT i
    LOCATE 10, 34: LINE INPUT Principal$
    IF (Principal$ = "Q") OR (Principal$ = "q") THEN GOTO EndProgram
    n = INSTR(Principal$, ".")
    IF n THEN Principal$ = LEFT$(Principal$, n - 1)
    Principal = VAL(Principal$)
    IF Principal < 1 THEN GOTO StartProcess
    IF Principal > 500000 THEN GOTO StartProcess
    LOCATE 11, 1: PRINT text$(11)

GetInterest:
    LOCATE 11, 35: LINE INPUT InterestRate$
    InterestRate = VAL(InterestRate$) / 1200
    IF (InterestRate < 0) OR (InterestRate > 30 / 1200) THEN
        LOCATE 11, 35
        PRINT SPACE$(10);
        GOTO GetInterest
    END IF
    LOCATE 12, 1: PRINT text$(12)

GetMonthsToPay:
    LOCATE 12, 35: LINE INPUT Months$
    Months% = VAL(Months$) \ 1
    Months = Months%
    IF (Months% < 1) OR (Months% > 480) THEN
        LOCATE 12, 35
        PRINT SPACE$(10);
        GOTO GetMonthsToPay
    END IF

CalculateAmount:
    x = (1 + InterestRate) ^ Months%
    y = 1 / x
    z = 1 - y
    Amount = (Principal * InterestRate) / z

PrintAmount:
    LOCATE 14, 1
    FOR i = 14 TO 20: PRINT text$(i): NEXT i
    LOCATE 14, 57: PRINT USING E2$; (Amount);
    LOCATE 20, 37

GetChoice:
    k$ = INKEY$
    IF k$ = "" THEN GOTO GetChoice
    k$ = UCASE$(k$)
    IF k$ = "Q" THEN GOTO EndProgram
    IF k$ = "V" THEN GOSUB PrintLoanTable
    GOTO StartProcess

EndProgram:
    CLS
    END

PrintLoanTable:
    GOSUB HeadUpTableX: Balance = Principal
    FOR i% = 1 TO Months%
        InterestPay = Balance * InterestRate
        PrincipalPay = Amount - InterestPay
        Balance = Balance - PrincipalPay
        Row = Row + 1
        IF Row > 22 THEN GOSUB HeadUpTable
        IF k$ = "Q" THEN RETURN
        PRINT "          ";
        PRINT USING EI$; (i%); : PRINT "   ";
        PRINT USING E0$; Balance; : PRINT "    ";
        PRINT USING E2$; InterestPay; : PRINT "    ";
        PRINT USING E2$; PrincipalPay
    NEXT i%
    GOSUB HeadUpTable
    RETURN

HeadUpTable:
    PRINT
    PRINT TAB(20); "Q-To Quit,   Any Other Key to Continue ......";
GetAKey:
    k$ = INKEY$
    IF k$ = "" THEN GOTO GetAKey
    k$ = UCASE$(k$)
HeadUpTableX:
    CLS
    IF k$ = "Q" THEN RETURN
    FOR Row = 1 TO 3: PRINT heading$(Row): NEXT Row
    RETURN

