











                                     Install-Pro







                                     User's Guide

                                         and

                                   Reference Manual








                       Copyright 1991-1993 DB/Soft Publishing.
                                 All rights reserved.








                                Printed in the U.S.A.

                             Version 3.00, first printing







          Copyright

          This software is protected under  United States Copyright Law and
          International Treaty provisions.  DB/Soft Publishing reserves all
          rights to Install-Pro except for the following:

          A limited license is hereby granted allowing you use and evaluate
          Install-Pro for up  to 30 days.  You may also distribute unregis-
          tered  copies  of  Install-Pro  in its  entirety  to  any parties
          interested provided no modification of the files in the  Install-
          Pro archive occurs.   The maximum transaction related to  selling
          media containing unregistered copies of Install-Pro (eg Shareware
          vendors)  may not exceed $10.00.  Conversion to a more convenient
          archive format is allowed.  All other uses of Install-Pro violate
          this license and are hereby expressly disallowed.

                     Copyright 1991-1993, by DB/Soft Publishing,
                                 All Rights Reserved.

                    3200 Truxel Rd #199, Sacramento, CA 95833 USA

                              Telephone: (916) 927-6951

                                 BBS: (916) 927-2349

          Limited Warranty

          DB/Soft Publishing  grants no warranties, express  or implied, by
          statute  or otherwise,  regarding this  software and  its related
          materials, their fitness for any purpose, their quality, or their
          merchantability.  In  no way shall  DB/Soft Publishing be  liable
          for  any  special, consequential,  other  damages  for breach  of
          warranty.

          This Statement  shall be  construed, interpreted and  governed by
          the laws of the State of California.

          This  warranty will be replaced by a limited 90-day warranty that
          covers the diskette, software and documentation upon registration
          of Install-Pro.   Further, the limited  license will be  replaced
          with a license that  allows royalty-free distribution of Install-
          Pro with your applications.







          Registering Install-Pro

          Install-Pro is an  example of software marketed  under the Share-
          ware concept.  The premise is  simple:  you may evaluate Install-
          Pro  for a  reasonable period  of time  (30 days  maximum) during
          which you  decide if it is  a program worth owning  and using for
          installing your applications.   If so, you must register Install-
          Pro,  using order.doc  for  ordering information.    If, after  a
          reasonable evaluation period, you decide not to register Install-
          Pro, you then must discontinue its use.

          This provides  me with  a way to  market software  with very  low
          advertising  overhead, which  results in  a price  savings passed
          directly on to you.  And, it provides you with a chance to 'play'
          with my product and decide if it meets your needs. 

          As  an  incentive to  speed  the  registration process,  a  minor
          modification  to Install-Pro  processing occurs in  the Shareware
          version.  Prior  to displaying your  opening screen(s), an  order
          information notice  is displayed.  Other than this single modifi-
          cation, all features that are  included in the registered version
          of Install-Pro are available here.


          Getting Help_____________________________________________________

          There are several ways of contacting the author, Jeff Dunlop, for
          technical assistance if you get stuck.  From cheapest and slowest
          to most expensive and fastest:

               - Fidonet's SHAREWRE echo

               - ILink's Shareware conference

               - Fidonet netmail at 1:203/16

               - Compuserve mail at 72147,3055

               - Internet at 72147.3055@compuserve.com

               - The DB/Soft Online at (916) 927-2349

          The best method of  contacting the author depends on the  type of
          assistance you need.   If it's a rather complicated  problem, you
          will probably be far  better served if  you prepare a message  in
          advance and  upload it with the script in question to the DB/Soft
          Online.  We can then test it and offer suggestions.  If it's just
          a  question  or  suggestion about  Install-Pro  capabilities, the







          ILink  or Fidonet  conferences will work  best.   Fidonet netmail
          privileges can be difficult  to get, but offer excellent  timeli-
          ness at very low connect  time.  Check your local Fidonet  BBS if
          interested.







                                  Table of Contents


               Chapter 1 Introduction .................................. 7
                    Features ........................................... 7
                    Requirements ....................................... 9
                    Getting Started .................................... 10
                    Install-Pro Scripts ................................ 10
                    Documentation Conventions .......................... 11

               Chapter 2 Creating the screens .......................... 13
                    BANNER ............................................. 13
                    HELLO .............................................. 14
                    HELLOBREAK ......................................... 14
                    GOODBYE ............................................ 14
                    GOODBYEBREAK ....................................... 15
                    COLORS ............................................. 15

               Chapter 3 Building the entry forms ...................... 17
                    USER ............................................... 17
                    DESCRIBE ........................................... 20

               Chapter 4 Transferring files ............................ 21
                    SUBDIR ............................................. 21
                    FILE ............................................... 22
                    Splitting Files .................................... 24
                    UNZIP .............................................. 25
                    ATTRIBSAVE ......................................... 27

               Chapter 5 Changing Disks and Terminating ................ 28
                    FIRSTDISK .......................................... 28
                    DISK ............................................... 28
                    END ................................................ 28
                    CHAIN .............................................. 29

               Chapter 6 Verifying the target environment .............. 30
                    SPACE .............................................. 30
                    CPU ................................................ 30
                    FPU ................................................ 30
                    RAM ................................................ 30
                    EMS ................................................ 31
                    VCPI ............................................... 31
                    DPMI ............................................... 31
                    XMS ................................................ 31
                    VER ................................................ 32
                    CONFIGFILES ........................................ 32

                                          5







                    PATH ............................................... 33

                    SET ................................................ 33


               Chapter 7 Running external programs and viewing files ... 34
                    RUN ................................................ 34
                    PRERUN ............................................. 36
                    RUNERRNOTIFY ....................................... 37
                    VIEW ............................................... 37

               Chapter 8 Customizing Install-Pro ....................... 38
                    ONERROR ............................................ 38
                    Linking external text .............................. 38

               Chapter 9 Miscellaneous ................................. 40
                    System Variables ................................... 40
                    Command Line Switches .............................. 41
                    Error Messages ..................................... 40
                    Critical Errors .................................... 46



























                                          6







          Chapter 1

          Introduction_____________________________________________________

          Install-Pro is the flexible and affordable solution to the common
          problem of  transferring an application or  information base from
          distribution  media to its  destination directories.   Typically,
          the options  have been to write  a batch file, to  write a custom
          program or to shell out hundreds of dollars for an anemic instal-
          lation utility.  Until Install-Pro.

          Install-Pro is a script driven  professional installation program
          that will automate the  installation process while providing your
          customers  with a  crisp,  easy-to-use interface.   Unlike  other
          script-driven installation  utilities,  Install-Pro is  heavy  on
          features,  intelligent in  its operation,  and light  on resource
          requirements.   Any application can be ready to install to multi-
          ple directories from  multiple  disks in a matter of minutes.   A
          brief list of features includes: 

               -    Professional look  and feel for a  better first impres-
                    sion.
               
               -    You customize  multiple  welcome screens  and  good-bye
                    screens to your own needs. 

               -    Up to 999 installation disks and unlimited installation
                    files.

               -    Comprehensive environment  detection, including minimum
                    CPU,  floating point  processor, installed  RAM, MS-Dos
                    version, EMS, XMS, VCPI and DPMI.

               -    Powerful system variables for CPU, math coprocessor and
                    video  adapter that allow  your installation  to behave
                    differently depending on the target hardware.

               -    Display your readme files  at the end of the  installa-
                    tion in a nifty file viewer.
            
               -    Intelligent  FILES=,  PATH  and  SET  VAR=  update  for
                    Config.sys and Autoexec.bat.
            
               -    All Install-Pro  text strings may  be optionally  rede-
                    fined via an external file.

               -    Files  may be split into up to  9 pieces for huge files
                    spanning multiple disks.
            

                                                                          7







                               Chapter 1, Introduction
          _________________________________________________________________
                                                                           
                    

               -    Files  in the .zip format may be extracted.  All direc-
                    tories stored in a .zip file are automatically created.
                    There is  an .arj  version of Install-Pro  available on
                    the DB/Soft Online for registered users.
            
               -    You define the  directory prompts and  default destina-
                    tion directories that the user sees.

               -    You optionally define the installation disk names (such
                    as "Utilities Disk" or "Install Disk")
            
               -    You  optionally  specify  the disk  space  requirements
                    associated  with  all  portions  of  the  installation,
                    including  optional  portions. (The  user is  given the
                    option to try to continue with installation if short on
                    disk space.)
            
               -    Up to 8 user-defined destination directories.
            
               -    Unlimited programmer-defined directories child to user-
                    defined directories. 
            
               -    Each  destination  directory may  either  be optionally
                    locked or the user may be allowed to change it.
            
               -    "Run"  commands  allow  your  installation  to  include
                    custom  auxiliary programs  or batch files  to complete
                    special tasks. The installation  diskette directory(s),
                    any  of  the  user-defined directories,  and  any other
                    arguments you  choose can be specified  anywhere on the
                    command line.
            
               -    Portions of an installation may be specified as option-
                    al, prompting  the user  whether  the optional  portion
                    should be installed.
            
               -    Multi-Module installations handled seamlessly.
            
               -    Files may be automatically overwritten, prompted before
                    overwriting  a newer file,  prompted before overwriting
                    any file or protected completely from overwrite.
            
               -    Supports VGA/EGA 50/43 line text modes if detected.
            

          8




                               Chapter 1, Introduction
          _________________________________________________________________
                                                                           
                    

               -    Robust  error  handling,  including  a  custom critical
                    error handler that won't scare the  dickens out of your
                    users, and  including descriptive fatal  error messages
                    (no "error  14 at xxxx:yyyy" found in this program!)


          Requirements_____________________________________________________

          Install-Pro runs  under PC-DOS and MS-DOS versions 3.0 and above.
          A minimum of 220K of  RAM is required.  More memory  is desirable
          if  external  programs  are run  from  Install-Pro,  or if  large
          scripts are processed.

          There is virtually no limit to the size of script files.

          Script preparation  will  require a  text  editor that  does  not
          insert formatting codes into the text.































                                                                          9




                               Chapter 1, Introduction
          _________________________________________________________________
                                                                           
                    

          Getting Started__________________________________________________

          Before you can really  build an installation script, you  need an
          application that needs to  be installed.  Gather enough  disks to
          hold  your  installation, format  them  if needed,  and  copy the
          application files over  to the disks.   Record what files  are on
          which disks for later  reference, and while you're at  it, record
          the  order that the disks are to  be installed.  Included on your
          Install-Pro  disk  are two  files to  aid  you in  recording this
          information.   They are  named MASTER.DOC  and DISKWKS.DOC.   For
          each installation you  should print out  one copy of  MASTER.DOC,
          and  a copy of DISKWKS.DOC  for every disk  in your installation.
          If you'll  be installing your application  from compressed files,
          then  you want to compress your files before transferring them to
          diskettes.

          If  you have huge files that will  need to be split onto multiple
          disks, you may want to take  a peek at the separate documentation
          for split.exe.   All that you  really need to know  is that split
          will  split filename.ext  into filename.ex1,  filename.ex2, etc.,
          and that  filename.ex1 must not  be copied  to a  higher-numbered
          disk than filename.ex2.

          Once you have  a good idea of what files  need to be transferred,
          then you're ready to start planning your installation.


          Install-Pro Scripts______________________________________________

          Install-Pro is script-driven.  That is to say, it looks onto your
          distribution  disks  for instructions  about  how  you want  your
          installation  to behave.  The  required instructions are found in
          script files,  one to a  disk.  The  script file  on Disk One  is
          named  INSTALL.001; the  script file  on the  next disk  is named
          INSTALL.002, and so on.  

          Install-Pro is also largely global in nature.  That is,  it reads
          the  entire script  on the  current distribution  diskette before
          doing  any processing.    Because of  this,  there are  very  few
          restrictions  on the location of most commands.  The major excep-
          tion  is that USER commands  must appear before  any command that
          references  a  label defined  in  that  USER command.    However,
          Install-Pro's  execution  is very  strictly  defined  and can  be
          described as follows:

          Disk 1
          ------

          10




          Equipment checks are performed.
          The opening screen(s) are displayed.
          The optional segments form is displayed.
          The main user entry form is displayed.
          PRERUN commands.
          FILE commands.
          UNZIP commands.
          VIEW commands.
          RUN commands.

          Disk 2 through Disk n - 1 (n = number of disks in installation)
          ---------------------------------------------------------------

          PRERUN commands.
          FILE commands.
          UNZIP commands.
          VIEW commands.
          RUN commands.

          Last Disk
          ---------

          PRERUN commands.
          FILE commands.
          UNZIP commands.
          VIEW commands.
          RUN commands.
          The closing screen(s) are displayed.
          Install-Pro either chains to a new copy of Install-Pro or ends.

          Because  of  this  strict   order  of  operations,  USER,  HELLO,
          HELLOBREAK and  Equipment commands  are legal but  meaningless on
          any  disk other than the  first disk.   GOODBYEBREAK commands are
          legal on any disk, but not processed until the end of the instal-
          lation.


          Documentation conventions________________________________________

          In  general,  command parameters  appear in  three  forms.   If a
          paremeter  appears in square brackets  ( [] ),  that parameter is
          optional.   If it  appears in angle  brackets (  <> ), it  is re-
          quired.   If it appears in quotes ( "" ), it is both required and
          must be surrounded  by quotation marks.  The text that appears in
          brackets may  either be  a sub-command or  a variable  parameter.
          The proper use of  the parameter is determined by looking  up the
          documentation  for  that  particular  parameter  below  the  main
          heading for the command.

          Throughout  the text,  commands  appear as  all capital  letters.
          This is to  remove any ambiguity as to whether  a particular word
          is the name of a command or is being used  in some other context.

                                                                         11




          However, Install-Pro is not case sensitive.  Commands, labels and
          directory  paths can appear in any combination of upper and lower
          case.


















































          12




          Chapter 2

          Creating the Opening and Closing screens_________________________

          All commands that define the opening screen(s), BANNER, HELLO and
          HELLOBREAK,  must appear in a file named INSTALL.001 on the first
          diskette of your installation set.  These commands usually appear
          at the top of INSTALL.001.

          The format of the opening screen is similar to the following:


      
      Ŀ
      Welcome to the Install-Pro Installation Program 
      ٱ
      
      
      
      
      Ŀ
       This program is going to transfer the Install-Pro files from   
       the installation diskette to the directory(s) that you enter   
       on the screen to follow.                                       
                                                                      
                        Press a key to continue.                      
      ٱ
      


          The top message that you see is created with the  BANNER command.
          The  bottom message is created  with a series  of HELLO commands.
          If multiple  HELLO screens are  defined, then each  keypress will
          display the following screen until all have been shown.


          BANNER___________________________________________________________

          Syntax:  BANNER "Any text enclosed in quotes"
            
          The BANNER command identifies the line of text to be shown to the
          user as the program name on the opening screen.  Up to 71 charac-
          ters are allowed, and a box surrounding the text auto-sizes for a
          neat appearance.  If the particular text used  creates unbalanced
          sides, insert  an extra space on  the errant side to  even things
          out.
            
          If quotes are  omitted, only the first word  after BANNER will be
          detected. If  no text is detected after  BANNER, Install-Pro will
          abort with an error  message.  The BANNER command must be defined
          in install.001 to have any effect.
            

                                                                         13




                           Chapter 2, Creating the screens
          _________________________________________________________________

          HELLO____________________________________________________________

          Syntax:  HELLO  "Any text enclosed in quotes"
            
          The HELLO  command identifies a line  of text to be  shown to the
          user on  the welcome screen.  Each line may have a maximum length
          of  71 characters.  Characters in excess of 71 are ignored (trun-
          cated.)  All  of the HELLO text lines are  displayed in the order
          detected in a single window, which automatically  sizes itself to
          the length and height of the combined HELLO display.  If you want
          empty  lines included, indicate this  with a set  of empty quotes
          ("").
            
          Up to 13 HELLO lines will  fit on a single screen.  If  more than
          13  HELLO lines  are defined  without any  intervening HELLOBREAK
          commands  (described below),  the subsequent  lines will  be dis-
          played on the  next screen.   Any number of  HELLO screens  (each
          autosizing, with  a capacity of  up to 13  lines) can be  defined
          within the confines of available memory.
            

          HELLOBREAK_______________________________________________________

          Syntax:  HELLOBREAK
            
          This  command signifies that the following HELLO command is to be
          displayed on  a new screen.  Use this if you have special format-
          ting needs that require fewer than 13 lines to a screen.

          The format of the closing screen is similar to the following:

                   
                   Ŀ
                    The installation has completed normally.   
                                                               
                             Press a key to exit...            
                   ٱ
                   

          This  message that  you  see here  is  created with  a  series of
          GOODBYE  commands.   If multiple-screen  messages  are necessary,
          they can be separated if needed with GOODBYEBREAK commands.


          GOODBYE__________________________________________________________
            
          Syntax: GOODBYE "So-long text goes here"
            


          14




                           Chapter 2, Creating the screens
          _________________________________________________________________

          This  command is  used  to  build  an end-of-install  message  to
          display to  your users  after successful completion  of installa-
          tion.  It  can be up  to 71 characters  long, and like  the HELLO
          lines, the GOODBYE  text is displayed  in an auto-sizing  window.
          If you want to specify an  empty line, use GOODBYE "".  Somewhere
          near the bottom of the GOODBYE text, you should include something
          to the effect that a keypress will exit the program.
            
          Any  number  of GOODBYE  lines can  be  defined, anywhere  in the
          script  file(s). After  14  GOODBYE lines  have been  encountered
          without  an intervening GOODBYEBREAK command (described below), a
          page break is automatically inserted by Install-Pro.
            
          When  an install.??? file is processed that is terminated with an
          END  command, after all  transfers have taken  place, the GOODBYE
          messages are displayed, after which the program terminates.  

          There are two events  that can occur that will  cause the closing
          screen to  not be displayed.   One is if you  choose to terminate
          with a  CHAIN command, which would  load a new installation.   In
          this instance, the closing screen defined with the last installa-
          tion processed  would be the one  displayed.  The other  is if an
          unrecoverable error  occurs.    In  this instance  the  error  is
          described to the extent possible, and Install-Pro terminates (see
          Chapters 8 and 9 for details).
            

          GOODBYEBREAK_____________________________________________________
            
          Syntax: GOODBYEBREAK
            
          This command tells Install-Pro that the next GOODBYE line defined
          in the script is to appear at the top of a new page.

                                New with version 3.00

          COLORS___________________________________________________________

          Syntax: COLORS <Reg Fore>  <Reg Back> <Err Fore> <Err  Back> <Ent
          Fore>  <Ent  Back>  <Bottom  Fore> <Bottom  Back>  <Shadow  Fore>
          <Shadow Back> <Background Fore> <Background Back>

          The COLORS  command requires  exactly twelve  hexadecimal digits,
          from 0 to F, where 0 through F represent the following colors:

          BLACK           0
          BLUE            1
          GREEN           2
          CYAN            3

                                                                         15




          RED             4
          MAGENTA         5
          BROWN           6
          LIGHTGREY       7
          DARKGREY        8
          LIGHTBLUE       9
          LIGHTGREEN      A
          LIGHTCYAN       B
          LIGHTRED        C
          LIGHTMAGENTA    D
          YELLOW          E
          WHITE           F

          The default  COLORS setting for Install-Pro is COLORS 7 1 7 4 0 7
          9 7 8 0 7 1 and is interpreted as:

          Regular Windows, Light Grey on Blue
          Error Windows, Light Grey on Red
          Entry Fields, Black on Light Grey
          Bottom Line, Light Blue on Light Grey
          Shadows, Dark Grey on Black
          Background, Light Grey on Blue

          Each  background color (that is, each second number in the COLORS
          command) must be in the range of 0 through 7.  This is  a limita-
          tion in IBM PC video architecture.



























          16




          Chapter 3

          Building the Entry Forms_________________________________________

         
         Ŀ
                      Optional Installation Selection               
         ٱ
         
         
         Ŀ
         Please press your spacebar to check any of these optional  
         installation segments that you wish to include.            
                                                                    
                    ( ) Sample Files                                
                                                                    
         ٱ
         

    
    Ŀ
         Destination Directory Entry       
    ٱ
    
    
    
    
    
    
    
    Ŀ
                                                                         
    Program Files            C:\INSTPRO\                                 
    Document Files           C:\INSTPRO\                                 
    Sample Files             C:\INSTPRO\SAMPLE\                          
                                                                         
    ٱ
    


          The USER command, which is used to build the Destination Directo-
          ry Entry  form   (and its  accompanying Optional  Selection form)
          must  appear in Install.001 on the first diskette of your instal-
          lation set.

            
          USER_____________________________________________________________
            
          Syntax: [OPTION or ATTACH]  USER <label> "prompt" [default direc-
          tory] [NOMOD]



                                                                         17




                         Chapter 3, Building the Entry Forms
          _________________________________________________________________

          This command  is the  workhorse of Install-Pro.   It  is used  to
          assign a  prompt and  a default  destination to a  label that  is
          specified by you, as well as specify if the files associated with
          it are to  overwrite existing targets.  When the  user inputs his
          destination directory it will be associated with this label name.
          This command also creates the workspace inside Install-Pro needed
          for FILE, RUN and SUBDIR commands to function.

          A discussion of each component of the USER command follows:
            

          [OPTION]
            
          Before he  is shown the  destination directory Entry  Screen, all
          OPTION USER  (and ATTACH USER) lines  will be resolved by  a form
          similar  to the top form shown above.   This form allows the user
          to toggle on or  off any or all of the  optional portions of your
          installation.

          To give  the user the chance  to not install an  unneeded part of
          your application (tutorials, etc.) you only need to prefix a USER
          command with OPTION.  

          [ATTACH]

          Warning:   The  ATTACH  USER command  is  best classified  as  an
          advanced topic.  Neophyte  Install-Pro script-writers might  best
          steer  clear  until the  other  aspects of  Install-Pro  are well
          understood. 

          When using an ATTACH USER command, the syntax is slightly differ-
          ent:

          Syntax: ATTACH USER <label> "prompt" <parent label> [NOMOD]

          Before  he is shown  the destination directory  Entry Screen, all
          ATTACH USER  (and OPTION USER) lines  will be resolved by  a form
          similar to the  top form shown above.  This  form allows the user
          to toggle  on or off any or all of  the optional portions of your
          installation.

          The  way that  ATTACH  differs from  OPTION  is that  instead  of
          displaying a data entry line on the destination directory screen,
          the label instead gets its path from the path associated with the
          parent label.   The  best way to  understand this  is through  an
          example:

          Assume  that  you  want  your  main  program  files  to  go  into
          C:\PROGSYS.  Further, assume you want optional sample files to go

          18




                         Chapter 3, Building the Entry Forms
          _________________________________________________________________

          into  C:\PROGSYS\SAMPLE.  But, you want no chance that the sample
          files  might end up in some other directory, unaccessible to your
          application.  To do that:

          USER prog_files "Program Files" C:\PROGSYS
          ATTACH USER sample_files "Sample Files" prog_files

          SUBDIR sample_files \SAMPLE

          FILE prog_files filename
          FILE sample_files samplefilename

          In  a  line-by-line  synopsis,  and assuming  the  defaults  were
          accepted  by the  user, the  user is  first shown  a radio-button
          screen asking if he wants  to install the sample files.   If yes,
          then all actions with the label sample_files will  occur.  If no,
          none of  those actions occur.   Now, the  user is shown  an entry
          screen  WITH ONLY ONE ENTRY  LINE, for prog_files.   Whatever the
          user types in for that path  will be stored into both  prog_files
          AND sample_files.   Next,  the SUBDIR  command  creates a  SAMPLE
          subdirectory and finally, the FILE commands transfer filename and
          samplefilename over to their respective directories.

          In  a nutshell,  ATTACH USER  commands  allow optional  events to
          occur in  non-optional directories.   In comparison,  OPTION USER
          commands, if  accepted, create  an additional directory  in which
          events are to occur.

          It is illegal to attempt to specify an OPTION USER command as the
          parent label  to an  ATTACH USER command.   The reason  is fairly
          obvious:   if the  OPTION USER  is declined  but the  ATTACH USER
          isn't, there is no way to determine a path to store in the ATTACH
          USER label.

          <label>:

          The label  portion of  the USER  command is  nothing more  than a
          tagname to assign to the information stored by  this command.  In
          some of the other commands you will want to refer to the destina-
          tion directory that this  command creates, but you won't  know if
          that directory will have been changed  by the user.  So, we refer
          to it with  a label instead.  Common labels  might be prog_files,
          help_files, etc.


          "prompt"

          In the above form, "Program  Files", "Sample Files" and "Document
          Files" were the prompt portions of the USER commands that created

                                                                         19




                         Chapter 3, Building the Entry Forms
          _________________________________________________________________

          the  form.   Each line  of the  Destination Directory  Entry form
          consists of a prompt and its corresponding entry field.  


          [default directory]

          If you  want the user  to be presented  with a default  directory
          when the Destination Directory Entry  form is displayed, then you
          can do so.  It must be in  the form of a legal DOS path.  In  the
          above form, the default directories were C:\INSTPRO  (twice)  and
          C:\INSTPRO\SAMPLE.   A default  directory is optional  unless you
          want to specify a NOMOD directory (described next).


          [NOMOD]

          Sometimes, you are going to want a specific directory path not to
          be  changed by the user  during installation.   For instance, you
          may  want  a \SYS  directory to  exist  on the  installation hard
          drive.  NOMOD makes this possible.  If  you tack NOMOD on the end
          of a USER command, the entry form displays "The directory portion
          of this field  cannot be  changed" whenever the  user is  editing
          this USER entry.  Since it is not possible to  know ahead of time
          what drive letters a  target computer will have available,  it is
          not allowed to freeze the destination drive, only the destination
          directory.

                                New with version 3.00

          DESCRIBE_________________________________________________________

          Syntax: DESCRIBE <label_name> "Description for this label"

          The  DESCRIBE command allows  you to dedicate  a line of  text to
          describe what class  of files the specified  label will transfer.
          As a typical example:

          USER prog_files "Program Files" c:\progsys
          DESCRIBE prog_files "These are the main program files"

          In both the OPTION USER pre-entry  form and main entry form,  the
          DESCRIBE text  is popped up in a one-line window at the bottom of
          the screen whenever the user is accessing that particular line of
          the form.  In most cases you will either want to  describe all of
          the lines of your forms  or none of them, but consistency  is not
          required.




          20




          Chapter 4

          Transferring and Decompressing Files

          SUBDIR___________________________________________________________
            
          Syntax: SUBDIR <label_name> <dirname>
            
          When you define an entry form with USER commands, the directories
          that the  user enters during the  installation will automatically
          be created by Install-Pro.  However, if you have directories that
          you want created child to the user-defined directories, you build
          them  with SUBDIR commands.  The components of the SUBDIR command
          are now discussed:


          <label_name>:
            
          The  label name specified here  MUST have been previously defined
          with a USER command.  The subdirectory will be created as a child
          to the  directory entered by  the user  on the line  of the  form
          associated with this label.


          <dirname>:
            
          This is the name of  the child subdirectory.  It does  not matter
          how long  it is (as long  as the total directory  length is below
          the DOS maximum of 65 characters)  or how many directories are in
          the chain.  That is, \SUB1\SUB2\SUB3 is a legal directory name if
          you wanted a  long chain  created child to  a main  subdirectory.
          There is no requirement that the directory(s) begin or end with a
          backslash.

          SUBDIR lines may exist anywhere in any install.??? file, but must
          precede the  first use  of its created  directory or  Install-Pro
          will be unable to continue.

          Example 1:
            
          USER label_1 "Data Files" C:\MYAPP\DATA
          SUBDIR label_1 \MOREDATA
            
          If  the user  accepted the  default, the  C:\MYAPP\DATA directory
          would be  created.  Also,  as a  result of the  SUBDIR line,  the
          C:\MYAPP\DATA\MOREDATA directory would be created.
            
            
          Example 2:
            
          USER label_1 "Data Files" C:\MYAPP\DATA
          SUBDIR label_1 \DATA1\DATA2\DATA3

                                                                         21




                            Chapter 4, Transferring Files
          _________________________________________________________________

            
          If the  user accepted the  default above, C:\MYAPP\DATA  would be
          first created,  and then the -entire-  chain of DATA1\DATA2\DATA3
          would be created as a child.  The resultant chain would thus be
            
          C:\MYAPP\DATA\DATA1\DATA2\DATA3
            
          CAUTION:  The DOS limit for subdirectory length is 65 characters,
          including drive and colon.  Keep in mind the maximum user-entered
          directory is up to 40 characters, leaving you up to 24 characters
          with  any margin of safety.   If the total exceeds 65 characters,
          DOS returns a directory creation error.
            

          FILE_____________________________________________________________

          Syntax: FILE <label_name> <filename> [UPGRADE, VERIFY or PROTECT]

          This  command  transfers a  file  from  the current  installation
          diskette to the directory  associated with labelname.  Since  the
          file must be on the current diskette, this command must appear in
          the script on  the same diskette.   Thus, if you  want a file  on
          diskette  #2 to be transferred,  the FILE command  must appear in
          install.002 on that diskette.  The components of FILE are:

            
          <label_name>:
            
          The label  name specified  here MUST  already  have been  created
          with a USER command.  This determines the destination directory.


          <filename>:
            
          The filespec  can take  one of  two forms.   First,  it can be  a
          regular dos filename, in which case it will be transferred to the
          directory associated with the specified label.  Alternatively, it
          can include  an optional directory  chain child to  the directory
          associated with the  specified label,  in which case  it will  be
          transferred to that child directory.  For that child directory to
          exist,  it must  first  be created  a  SUBDIR command,  described
          previously. 


          [UPGRADE]:
            
          This  modifier indicates that any files newer than the file being
          transferred  are to be overwritten only with permission  from the


          22




                            Chapter 4, Transferring Files
          _________________________________________________________________

          user.  Therefore the  user's machine must have a  functional (and
          accurate) clock.


          [VERIFY]:
            
          This modifier directs Install-Pro  to verify all file overwrites,
          even if the file being overwritten is older than the installation
          file.

                                New with version 3.00

          [PROTECT]:

          This modifier prevents an existing file from being overwritten by
          Install-Pro.  If the file exists, the copy does not occur.


          Example:
           
          USER label_1 "Data Files" C:\DATA
          FILE label_1 main.exe
          FILE label_1 main2.exe
            
          This partial  script would  transfer main.exe and  main2.exe from
          the root  directory of the  current installation diskette  to the
          directory that the user entered when prompted  with "Data Files",
          perhaps the default directory presented to him, "C:\DATA".
            
          Now, consider this more advanced example:
            
          USER label_1 "Data Files" C:\DATA
          SUBDIR label_1 \HELP
          FILE label_1 main.exe  
          FILE label_1 main2.exe
          FILE label_1 help\help.dat
            
          Assuming that the user  accepts the default C:\DATA, this  script
          will transfer main.exe  and main2.exe from the  root directory of
          the  current  installation diskette  to C:\DATA,  just as  in the
          previous  example.  Also, as child  to the user-entered directory
          will  be created a help  directory, to which  will be transferred
          help.dat.
            
          The final structure if all defaults are accepted by the user is:
            
          C:\DATA\MAIN.EXE
          C:\DATA\MAIN2.EXE
          C:\DATA\HELP\HELP.DAT

                                                                         23




                            Chapter 4, Transferring Files
          _________________________________________________________________

          If the destination file already exists, its attribute is  changed
          to  read/write  before  the transfer  is  attempted.    After the
          transfer  has completed,  if ATTRIBSAVE  has been  specified, the
          attribute of the destination file is changed to match the attrib-
          ute of the source file.
            

          Splitting Files__________________________________________________
            
          If  you have  files  that just  cannot  fit onto  a  distribution
          diskette,  Install-Pro has  the  ability to  handle split  files.
          First an example of how to tell Install-Pro what you want:
            
          FILE label_1 main.ex1e
          FILE label_1 main.ex2e
            
          These two FILE commands lines would cause Install-Pro to create a
          file  called main.exe in  the label_1  directory, from  TWO files
          main.ex1 and main.ex2.   What Install-Pro does is looks to see if
          an extra character has been added to a  filename.  If there is an
          extra character:
            
          1. The source (distribution disk) filename is assigned  an exten-
          sion of the  first three characters of the  filename's extension.
          This file should exist on the current distribution diskette.
            
          2. The destination filename has the third character replaced with
          the fourth, and the fourth character is removed.
            
            
          Please note that:
            
          1.  main.ex1e and main.ex2f would  not cause an  append to occur.
          The filenames (with  the exception  of the third  character of  a
          four-character  extension) MUST  match.   In this  case, main.exe
          would  be created from main.ex1, but main.exf would NOT be creat-
          ed.
            
          2. The  files MUST have the  same label name assigned  to each of
          them.  If main.ex1e and main.ex2e were assigned different labels,
          \directory1\main.exe would be  created, but  \directory2\main.exe
          would NOT.
            
            
          The append/create decision is resolved as follows:
            
          1. If  third character of the  extension is a '1'  and the fourth
          character exists, the file is CREATED.
            

          24




                            Chapter 4, Transferring Files
          _________________________________________________________________

          2. If the third character is greater than a '1', then Install-Pro
          checks to make  sure that the preceding portion   of the file was
          copied before proceeding.  If so, the file is APPENDED.  

          3.  If the third  character is a number,  but no fourth character
          exists, no split-file decision occurs - the file will be created.
            
          This type of  file transfer can be especially touchy if the order
          of  files transferred  and then  appended is  incorrect.   If you
          split files,  I strongly  recommend  that you  debug your  script
          carefully and compare the  created file with the original  (using
          the DOS program 'COMP') to be sure that they are identical before
          releasing your application.

          There  is an  accompanying  utility called  split.exe which  will
          split  your large files for you if needed.  It comes with its own
          documentation.


          UNZIP____________________________________________________________

          Syntax: UNZIP <labelname> <zipfile> [VERIFY, UPGRADE or PROTECT]

          This  command specifies a zip file that needs to be decompressed.
          The following assumptions are made with this command:

          1.  If the zip  file is in  a destination  directory it is  to be
          deleted  after  decompression.   (Under  no  circumstances is  it
          possible to delete a zip file on the distribution disk.)

          2. The  base destination  for the  extracted files  is to  be the
          directory associated  with  labelname.    That  is,  subdirectory
          information stored  in the zip file is to be used relative to the
          current zip file directory.

          3. The filename's default extension is 'zip'.

          4. The file was  compressed with a supported version  of PKWare's
          PKZip  or 100%  compatible.   Currently, all  compression methods
          through 2.04c are supported.  See the read.me file for updates on
          more recent releases.

          5. The file was NOT encrypted with a password.

          6. The file is not part of a multiple-volume archive.


          The  components of  the UNZIP  command should  be interpreted  as
          follows:

                                                                         25




                            Chapter 4, Transferring Files
          _________________________________________________________________


          <labelname>:

          The  labelname,  which must  be  previously defined  with  a USER
          command, defines the base directory for the decompression.


          <zipfile>:

          The zipfile may be  transferred first with a FILE command,  or it
          may be decompressed from  the installation diskette.  In  perfor-
          mance, both  methods are identical.   However, if  you decompress
          from the  diskette, extra care must  be taken to  ensure that the
          UNZIP  command occurs in the script on  the current diskette.  If
          you  transfer with a file command and decompress from the instal-
          lation directory, then  the UNZIP command can come anytime after-
          wards, even on the last diskette.


          [UPGRADE]:

          This modifier indicates that any files newer than the file  being
          transferred  are to be overwritten only  with permission from the
          user.  This modifier is  reliant on the user's machine   having a
          functional clock,  and  that  the files  on  the  user's  machine
          reflect actual dates.


          [VERIFY]:

          This modifier directs Install-Pro to verify all file overwrites.

          Any  directory information packed in an zip file is automatically
          created as needed during the unzip process. Under no circumstanc-
          es will a file stored in a zip file with subdirectory information
          be unpacked into the current directory.

                                New with version 3.00

          [PROTECT]:

          This modifier prevents any file in the destination directory from
          being overwritten by a file in the .zip file.  


          Example:

          UNZIP label1 zipfile


          26




                            Chapter 4, Transferring Files
          _________________________________________________________________

          would unzip zipfile.zip in the directory associated with label1.

          If  UNZIP refers to an OPTIONal label,  the UNZIP will only occur
          if the user chose to include that part of the installation.

          Since  an error  extracting  a zip  file  must be  considered  as
          dangerous  as an error copying an installation file, crc or other
          unzip errors must be treated as fatal errors, with program abort,
          so double-check the integrity of your .zip files before distribu-
          tion.

          If the destination file already  exists, its attribute is changed
          to  read/write  before  the transfer  is  attempted.   After  the
          transfer  has completed,  if ATTRIBSAVE  has been  specified, the
          attribute of the destination file is changed to match the attrib-
          ute of the source file.


          ATTRIBSAVE_______________________________________________________

          Syntax: ATTRIBSAVE

          This command states that you want attributes assigned to files on
          your  distribution  disks and  attributes  of  files within  your
          compressed  archives to  be preserved  after they  have  been in-
          stalled in the destination directories.  Even if you install
          read-only files, however, Install-Pro will be able to overwrite
          them during subsequent installs.                                 






















                                                                         27




          Chapter 5

          Changing Disks and Terminating___________________________________


          FIRSTDISK________________________________________________________

          Syntax: FIRSTDISK [disk name]

          This command allows you  to name the first disk  of the installa-
          tion something  besides the default  "Disk 1" (for  example, "In-
          stall Disk").  Other than slightly changing screen appearance and
          prompts, this  command does not affect the  physical operation of
          Install-Pro in any  way.   If no argument  follows the  FIRSTDISK
          command, the default of "Disk 1" will be used.  

          FIRSTDISK MUST appear in install.001 to have any affect.


          DISK_____________________________________________________________
            
          Syntax: DISK [disk name]
            
          This command specifies that when  processing for the current disk
          has  finished, the  user  is to  be prompted  to insert  the next
          numbered disk (as opposed to terminating the installation).   The
          extension  of the  script  file increments  with each  successive
          disk.  For example, if the disk being processed is disk 1 with i-
          nstall.001, specifying DISK  would cause the user  to be prompted
          to insert disk #2.  If the user presses enter and the disk in the
          drive in which  install.exe exists does  not have install.002  in
          the  current directory, the user will be instructed to try again.
          This  loop repeats  until the  user inserts  the correct  disk or
          until the user presses Escape, which would terminate the program.
            
          The  optional [disk name] argument allows you to name the follow-
          ing  disk something besides "Disk n".  Common uses are "Utilities
          Disk","Fonts  Disk"  or what-have-you.    If  you adopt  this  or
          another naming  convention,  be sure  to  look up  the  FIRSTDISK
          command for instructions on naming the FIRST disk (since the DISK
          command always names the FOLLOWING disk.)
            

          END______________________________________________________________

          Syntax: END
            
          This command  indicates  that the  end of  the last  installation
          script has been reached.  Just like DISK, END forces all informa-
          tion stored in all labels to be processed.  However, unlike DISK,
          when this processing has been completed, the program displays the
          GOODBYE messages and exits.

          28




                       Chapter 5, Changing Disks & Terminating
          _________________________________________________________________

            
          This command is mutually exclusive of the DISK command.  Whichev-
          er  is encountered first on  any given diskette  will dictate the
          processing that will occur, and the other will be ignored.


          CHAIN____________________________________________________________

          Syntax: CHAIN
            
          This command  indicates that  the end  of  the last  installation
          script  has been reached,  just like END.   When this  command is
          reached, all work accumulated is processed.  Unlike END, however,
          CHAIN  is a  conditional  installation terminator.   The  user is
          presented  with "Do you wish to install another module (Yes/No)".
          If the user selects NO, then the GOODBYE  screen is displayed and
          Install-Pro terminates.
            
          If  the user  selects YES,  then  he is  prompted  to insert  the
          Install Disk of the next module and Install-Pro transfers control
          to another copy of itself  on the new diskette, and the  old copy
          of Install-Pro in memory  is discarded.  Any GOODBYE  screen will
          be handled by the new copy of Install-Pro.
            
          The actual filename that  is looked for with CHAIN is the identi-
          cal path and filename of the currently executing process.  So, if
          you have renamed one copy of Install-Pro to INSTALL.EXE, they all
          must be renamed that way.
            
          The traditional use for this type  of termination is in the  case
          of integrated accounting software, where it is unknown at runtime
          how  many modules  (General Ledger,  System Manager,  Accounts R-
          eceivable,etc.) have been purchased.

















                                                                         29




          Chapter 6

          Verifying the target environment_________________________________


          SPACE____________________________________________________________

          Syntax: SPACE <label_name> <nnnnn>
            

          If you  would like  the destination  drive checked  for available
          disk  space before proceeding (often a good idea) you define your
          space requirements with this command.  It is not foolproof, since
          it is  possible that the  installation will go  on top of  an old
          one, but  it provides you with an opportunity to warn the user if
          his disk is almost full.

          Each SPACE command must  reference a defined label (via  the USER
          command.)    After the  user  chooses his  destination  drive and
          directories  in the  entry screen,  all labels  that access  each
          drive are added together  to determine if enough free  disk space
          exists.
            
          The disk check(s) occur directly after the user has finished with
          the destination  directory entry screen.   Any OPTIONal installa-
          tion segments that are declined by the user are not counted  when
          determining adequate disk space.


          CPU______________________________________________________________

                              486 new with version 3.00

          Syntax: CPU <86, 286, 386 or 486>

          This command can be used to warn the  user that his machine has a
          processor that will not run your application.  This is treated as
          a warning,  and the user is  allowed to try to  continue.  Please
          note that this  detection is  not 100% reliable  due to the  huge
          number of computers available.


          FPU______________________________________________________________

          Syntax: FPU
            
          This command will  warn the  user that your  application needs  a
          math  co-processor installed to function.   This is  treated as a
          warning, and the user is allowed to try to continue.


          RAM______________________________________________________________

          30




                           Verifying the Target Environment
          _________________________________________________________________

            
          Syntax: RAM <nnn>

                          Changed starting with version 3.00

          This command will warn  the user if the installation  machine has
          less  ram (in kilobytes) available than would be required by your
          application.   This  is  handled by  Install-Pro calculating  its
          program  size  and adding  the amount  of  free ram  available to
          Install-Pro.  It is  fairly safe to assume that  this calculation
          will be accurate if  your application had been loaded  instead of
          Install-Pro.


          EMS______________________________________________________________

          Syntax: EMS <nnnn>

                                New with version 3.00

          This command will warn  the user if less available EMS  (LIM 3.0-
          compatible  expanded memory,  in kilobytes)  is detected  than is
          required by your application.


          VCPI_____________________________________________________________

          Syntax: VCPI

                                New with version 3.00

          This command  will warn the  user if there  is not a  VCPI server
          installed.


          DPMI_____________________________________________________________

          Syntax: DPMI <nnn>

                                New with version 3.00

          This  command will warn  the user if  there is not  a DPMI server
          installed greater than  or equal  to the version  specified.   If
          your application requires DPMI 0.90  or newer, you would indicate
          this with DPMI 090 (or just 90).  That is, two decimal points are
          implied in the version specified.


          XMS______________________________________________________________

                                                                         31




                           Verifying the Target Environment
          _________________________________________________________________

          Syntax: XMS <nnnn>

                                New with version 3.00

          This command will warn  the user if less available  XMS (extended
          memory,  in  kilobytes) is  detected  than  is  required by  your
          application.
           

          VER______________________________________________________________

          Syntax: VER <n.nn>
            
          This command will  warn the user if the version  of MS-Dos on the
          installation machine  is less than required  by your application.
          This is treated as  a warning, and the user is allowed  to try to
          continue.


          CONFIGFILES______________________________________________________

          Syntax: CONFIGFILES <nn>
            
          This command follows the following logic:

            
          1.   Attempt to determine the boot disk.  

          2.   If the boot disk is found, try to find Config.sys.

          3.   If Config.sys has been found, read the FILES= statement.  

          4.   If Config.sys  cannot be  found, or if  Config.sys has  been
               found but with FILES=  too low, ask the user  for permission
               to update  Config.sys.   If permission  is granted,  ask the
               user  for the path  to Config.sys if  Config.sys hasn't been
               found.

          5.   Back  up Config.sys  to Config.nnn  where nnn  is the  first
               available non-existant file  starting with  Config.001.   No
               more than one backup of Config.sys will occur  per installa-
               tion.

          6.   Modify Config.sys if given permission.

          Please note that the goal here is to:
            
          1.   Only  disturb the user if unable to determine that FILES= is
               okay.

          32




                           Verifying the Target Environment
          _________________________________________________________________

          2.   Never modify Config.sys without permission.

          3.   Don't  access a  Bios-reported  floppy  diskette unless  the
               user inputs it as the boot disk.
            
          A  message is  displayed notifying  the  user whether  the update
          occurred, or whether it wasn't needed after all.


          PATH_____________________________________________________________

          Syntax: PATH <labelname>

          This command allows a path associated with a label to be inserted
          into  the path statement in Autoexec.bat.  If the particular path
          entry  is found in the PATH statement in Autoexec.bat, no attempt
          is made to add it again.   Like with Config.Sys, the user is only
          disturbed  if Install-Pro is  unable to  determine that  the PATH
          setting is okay.  If Autoexec.bat is to be modified,  it is first
          backed up to Autoexec.nnn.


          SET______________________________________________________________

          Syntax: SET <ENVVAR>=<value>

                                New with version 3.00

          This  command allows  you to  place any value  you wish  into the
          user's Autoexec.bat.   <ENVVAR> is  your environmental  variable.
          <value>  is the value you wish to  place in the environment.  All
          instances of a label name prepended with an exclamation point (eg
          !label_name)  are directly replaced  with the path  that the user
          types  in for the USER  command associated with  that label name.
          Trailing  backslashes on  that  path are  always stripped  before
          passed to the SET command.

          If <ENVVAR> is already  in Autoexec.bat, it is replaced  with the
          new value.  If Autoexec.bat is to be modified, it is first backed
          up to Autoexec.nnn.










                                                                         33





          Chapter 7

          Running External Programs________________________________________


          RUN______________________________________________________________

          Syntax: RUN "any command line in quotes" [log-to directory]
            
          This command defines  a command line to  be built to  execute any
          special programs or batch  files that are needed to  customize an
          installation.  One  use for  this might  be to  run a  config.exe
          program that  will bring the  user straight into  configuring the
          application he is  installing.   Another use might  be to  create
          application  menu  definition files  that  couldn't  be built  at
          install-time otherwise.

                                New with version 3.00

          [Optional Directory]

          If an  optional directory is specified, then Install-Pro will log
          onto that directory (it can even be  on a different drive) before
          executing the  command.   If  you want  to log  onto  one of  the
          directories  entered by the user  on the entry  form, indicate it
          with  an  exclamation  point  followed  by  the  label  name  (eg
          !prog_files).   If you  want an  absolute directory logged  onto,
          just specify the directory  verbatim (eg c:\progsys).  Specifying
          an absolute directory is risky, as there is  no guarantee that it
          exists!
            

          "any command line in quotes"

          Run works by one of two methods.  If the command specified on the
          command line has the  extension ".EXE" or ".COM", the  program is
          executed directly by Install-Pro.   If no .EXE or  .COM extension
          is specified, your command is run by invoking a command processor
          shell and  passing it the command  line that you specify.   There
          must be enough memory to load both your  program or command shell
          in addition to that used by Install-Pro.
            
          Run command  lines of  longer than one  word MUST be  enclosed in
          quotes.  
            
          Further, the  directory(s) that  the user  enters at  runtime are
          available on the  RUN command  lines.  Simply  specify any  label
          with  a  preceding exclamation  point  (!)  and the  user-entered
          directory will  be directly substituted  for that portion  of the
          text.   The directory is inserted without any leading or trailing


          34




                         Chapter 7, Running External Programs
          _________________________________________________________________

          spaces, but the  spaces on  the RUN command  line are  UNTOUCHED.
          Some examples follow:
            
          RUN "dir !label_1"
          RUN "!label_1\myprog.exe" !label_1

          This example would first  change to the directory entered  by the
          user for label_1 before executing myprog.exe.

          RUN "copy !label_1\this.fil !label_2"

          RUN "anydir\anyprog.exe" c:\progsys

          This  example would log into c:\progsys  before attempting to run
          c:\progsys\anydir\anyprog.exe.  
            
          Finally, a  special sequence, !home,  signifies that you  wish to
          specify the installation directory of the installation disk.  For
          obvious reasons,  don't create any labels called  'home' with the
          USER command, or  the !home sequence will no longer  point at the
          home directory, but rather  at the directory entered by  the user
          for this labelname.
            
          RUN "!home\myprog.exe"

            
          would  execute  myprog from  the  installation  directory of  the
          installation disk.
            
          When a RUN command is executed,  the screen is saved and  cleared
          first.  After it has completed, the screen is restored.
            
          If the command shell attempt fails, the user will  be notified of
          the reason (usually  memory) but the INSTALLATION WILL NOT ABORT.
          If there is a critical part of your installation occurring with a
          RUN command, be sure  to document it in your  manual installation
          instructions for the user.
            
          A few points to keep in mind:
            
          1.   The error trapping is much more solid if Install-Pro direct-
               ly executes your program.   This is due to the fact  that if
               the command  shell is used instead,  success constitutes the
               shell having successfully loaded.  Whether enough ram exist-
               ed for your program or your program was found is not detect-
               able by Install-Pro.   What's  worse, in the  case of  older
               versions  of  the alternative  command  processor  4Dos, the
               command shell load process  occurs in two parts.   The first


                                                                         35




                         Chapter 7, Running External Programs
          _________________________________________________________________

               part of 4dos can load successfully but fail to load the rest
               of itself and still return success to Install-Pro.
            
          2.   Memory requirements  for command  shell RUN commands  can be
               significantly  higher,  especially  if  COMMAND.COM  is  the
               target of COMSPEC (about 27k).
            
          3.   A single RUN  command in .EXE mode is allowed  up to 9 argu-
               ments. Additional  arguments are ignored.   In command shell
               mode, there is no limit to the number of arguments allowed.
            
          4.   A single  RUN command in .EXE mode is allowed a length of up
               to 256 characters.  The length of any single argument is re-
               stricted to  128 characters.   If argument zero  (the direc-
               tory,  path and filename of the executing program) is longer
               than  128 characters, DOS will  return an error message back
               to  Install-Pro.  If any  other argument is  longer than 128
               characters, the argument will be truncated.
            
          5.   A  single RUN  command in  command shell  mode is  allowed a
               total length of up to 256 characters,  but keep in mind that
               the  widely-used command  interpreter COMMAND.COM  will only
               allow  128 characters total.  4dos,  among others, allows up
               to 256 characters.
            
          6.   RUN commands  MAY access OPTIONal directories.   However, if
               any of the optional directories listed in a RUN command line
               were not accepted by the user (even if the directory already
               exists),  the command  will  be ignored.    This allows  RUN
               commands to  be conditional  on whether  an OPTION  has been
               accepted.   If an OPTION is  declined, you can be  sure that
               the associated RUN commands will not be executed.


          PRERUN___________________________________________________________

          Syntax: PRERUN "any command-line in quotes" [log-to directory]

                                New with version 3.00

          This command is identical to the  RUN command, except that it  is
          processed BEFORE  any  FILE, UNZIP  or  VIEW commands  have  been
          executed.   If you have a task  that needs to be completed before
          any  work  has been  actually started  on  the current  disk, use
          PRERUN.  For example, if you would like to back some files before
          installing  an  upgrade,  you  could  do  so  with  this command.
          RUNERRNOTIFY affects PRERUN just as it does RUN.



          36




          RUNERRNOTIFY_____________________________________________________

          Syntax: RUNERRNOTIFY

                                New with version 3.00

          Ordinarily,  Install-Pro only  notices whether  or not  a program
          executed  with a  RUN command  successfully loaded,  ignoring the
          return value.  Including  RUNERRNOTIFY notifies Install-Pro  that
          you want any non-zero errorlevel exits of your RUN commands to be
          flagged as an error.  Thus,  you can force non-zero exits to have
          the  same warning message displayed that is shown on program load
          errors.  Just like regular RUN error processing, the installation
          still attempts to continue.


          VIEW_____________________________________________________________

          Syntax: VIEW [filename]

                                New with version 3.00

          This command allows a very nice scrollable window to be popped up
          with your read.me files.  Just like  with the RUN command, labels
          can be used  in the path.   For example, to  view read.me on  the
          distribution diskette:

          VIEW !HOME\READ.ME

          Just as  a side note:   the functionality of the  VIEW command is
          generally  available to C  programmers through DB/Soft's ViewLib,
          which  is  a library  that brings  flexible  report viewing  to C
          object-compatible programs.  An evaluation version of ViewLib can
          be downloaded from the DB/Soft Online.



















                                                                         37





          Chapter 8

          Customizing Install-Pro__________________________________________


          ONERROR__________________________________________________________

          Syntax: ONERROR "Any text in quotes"

          If an error occurs, you may have a specific suggestion that you'd
          like to  present your customer, for example a number to call.  If
          ONERROR is defined in install.001, the unrecoverable message text
          "Please  refer to  your manual  installation instructions  if the
          problem cannot be corrected."  is directly replaced with whatever
          text you specify.   The text in quotes  may be up to  200 charac-
          ters.


          Linking external text____________________________________________

          Distributed with Install-Pro  comes a  file called  EXTERNAL.LNG.
          This  optional file,  if found  in the Install-Pro  directory, is
          used  to  replace the  internally  defined  text strings.    This
          feature allows  total prompt  redefinition for  specialized needs
          such as foreign language translations.  The linkage occurs before
          ONERROR text  is read  into memory, so  ONERROR takes  precedence
          over its counterpart in the redefinition file.
            
          If  EXTERNAL.LNG is  found,  Install-Pro inserts  the text  found
          directly into the  program space, and  will behave as  if it  had
          been developed with that text.   The file is read on a one-to-one
          correspondence  to internal  string space.   That  is, each  line
          replaces  a specific string of text.  In  the case of some of the
          longer  strings, you may specify a line continuation with the '\'
          (backslash) character.  Thus, 
           
          "String definition 1 " \
          "String definition continued"
            
          would be treated as the following single definition:
            
          "String definition 1 String definition continued"
            
          Don't forget that you  probably want a space character  after the
          last word of  continued string definitions.  The quotations marks
          are mandatory.   Please be  aware that there is  a slight perfor-
          mance penalty involved in reading the definition file.  If you do
          not  want redefinition  to take  place, remove  external.lng from
          your Install-Pro directory.



          38




                          Chapter 8, Customizing Install-Pro
          _________________________________________________________________

          Lines beginning  with a  semicolon  or empty  lines are  ignored.
          Liberal use  of semicolon-preceded comments will  greatly aid the
          redefinition  process, especially  when translating  between lan-
          guages.
            
          Some of the string definitions are included with %s or  %d format
          specifiers.   If you are  not familiar with  the programming lan-
          guage C, these  are used to insert variable text into the string.
          When  you redefine  a string,  you must  remember to  include the
          format specifiers in  a similar position in  the new string.   If
          you include  more format specifiers in the string than originally
          defined, garbage will display in your string at runtime.  If  you
          display fewer format specifiers,  important information will  not
          be displayed to your users.
            
          Some of the text strings are menu items (they are labeled as such
          in external.lng.)  They  must be preceded with a  space character
          (e.g. " Yes " for the menu hotkeys to work correctly.
            
          The order of  the string  definitions is significant.   You  must
          redefine all of the text if you redefine any of it.
            
          When  redefining text, I strongly suggest  that the original text
          definitions provided in the  sample be commented out and  left in
          the file for reference.   Generally, the new definitions  need to
          be  approximately the same length as the originals.  Where possi-
          ble (e.g. some of the longer messages) I  have allowed some extra
          leeway  by implementing  word-wrap  in  the  message box  and  by
          leaving  extra space.  Generally,  if a text  redefinition is too
          long, the part that is  too long will either be truncated  or run
          into menu selection bars.  If  you cannot satisfactorily redefine
          a line, please contact us.


















                                                                         39




          Chapter 9

          Miscellaneous____________________________________________________


          System Variables_________________________________________________

          For  all  of  Install-Pro's  flexibility, there  are  still  some
          decisions  that  cannot be  made ahead  of  time.   The following
          system  variables  are defined  at runtime,  and  can be  used to
          modify the  installation depending  on the  destination hardware.
          The system variables available are:

          IS86   - True if the processor is a 8086 or higher.
          IS286  - True if the processor is a 80286 or higher.
          IS386  - True if the processor is a 80386 or higher.
          IS486  - True if the processor is a 80486 or higher.
          ISFPU  - True if a math coprocessor is installed.
          ISMONO - True if the video adapter is monochrome.
          ISVGA  - True if the video adapter is EGA, VGA or higher.
          ISCGA  - True if not ISMONO and not ISVGA.

          It  is never  the case  that  more than  one of  the three  video
          adapter system variables will be true.

          Using system variables is easy: just precede ANY command with the
          appropriate  system  variable,  and  that command  will  only  be
          executed if the system variable is TRUE.  Assume as an example:

          IS386 FILE prog_files progfile.zip
          IS386 UNZIP prog_files progfile

          If  this were  run on  a 80386  computer, both of  these commands
          would be executed.  On any  other computer, neither of them would
          be. 

          Further,  the complement of each of these system variables can be
          achieved with  the keyword NOT.   For instance, if  you wanted to
          transfer  a file to the  destination directory only  if the video
          hardware is not monochrome, you would use a command like this:

          NOT ISMONO FILE prog_files colorset.dat

          Note  that a NOT <sysvar> <command> in conjunction with an accom-
          panying <sysvar> <command> provides 100% coverage of the hardware
          in question -- video, processor or math coprocessor.  

          Also note that it is not usually necessary and often dangerous to
          precede a  USER command with a [NOT] <sysvar> prefix.  The reason
          is that the  USER command disappears if the prefix  is false.  If
          the USER command disappears, then  ANY command that accesses that


          40




                                    Miscellaneous
          _________________________________________________________________

          USER  command's label  is  illegal  unless  the command  has  the
          identical prefix that the USER command has. 

          It  is legal  to  stack multiple  system  variables on  a  single
          command, for instance:

          IS286 NOT ISVGA <command>

          would be exceuted on a computer with a 80286 or greater processor
          and no VGA adapter installed.  

          If  you have candidates for other system variables that you would
          like considered, please notify us.


          Command Line Switches____________________________________________

          The following command line switches are supported:

          -m - use black and white colors.  

          Install-Pro should display correctly on all video adapter/monitor
          combinations.   It  has been  tested with  a wide  combination of
          adapters, including  CGA lcd  laptops and VGA  mono workstations,
          and the display has  always proved to be crisp and readable (even
          if  by chance  Install-Pro thinks  it's using  a color  monitor).
          But,  if a customer reports to you  that he is unable to read the
          text,  this switch  will throw Install-Pro  into black  and white
          regardless of the adapter  it is writing to.   This switch should
          be mentioned in the installation literature that accompanies your
          application whenever possible.   Selecting -m disables any COLORS
          command in  your script,  which is  just as well  as it  was your
          COLORS command  that  made the  screen  unreadable in  the  first
          place.  The -m switch does NOT affect the ISMONO system variable.


          -a=root - use alternate script file name.

          The  syntax  supported  has  a  certain  degree  of  flexibility.
          /A=root,  /a=root, /a:root and -a:root will all work.  Use which-
          ever style you are most comfortable with.  You cannot specify the
          extension  of your scriptfiles  (they always start  with .001 and
          continue), but you can specify the root  (base) name of the file.
          Some examples  might be NETINST  or UPGRADE.  This  gives you the
          flexibility of containing multiple installation procedures on the
          same  distribution diskettes.   For  instance, you  might include
          instructions  for  current  users  of your  application  to  type
          A:UPGRADE  instead  of  A:INSTALL,  and in  a  batch  file  named


                                                                         41




                                    Miscellaneous
          _________________________________________________________________

          UPGRADE.BAT on  your distribution disk you  yourself could handle
          the syntax INSTPRO -a=upgrade. 


          Error Messages___________________________________________________

          The following are the standard error messages built into Install-
          Pro.  The  nature of these errors is such that Install-Pro cannot
          continue, so these error messages  can probably be classified  as
          Fatal Errors.   The message the  user sees is similar  to the one
          that follows:

                
                Ŀ
                 The following unrecoverable error has  occurred:  
                                                                   
                             Error opening install.001             
                                                                   
                                                                   
                 Please refer to your documentation for manual     
                 installation instructions if the problem cannot   
                 corrected                                         
                                                                   
                              Press a key to terminate...          
                
                

          As previously mentioned, the instructions can be modified with an
          ONERROR command.
            

          DOS version 3.0 or higher required
            
          A  DOS version prior to  3.0 was detected.   Install-Pro requires
          MS-DOS 3.0 or later.

            
          Error opening install.001
            
          INSTALL.001 was not found  in the same directory  as Install-Pro,
          or there were no file handles available.

            
          Token was expected but not found: line nn

          A token  was expected but not  found on the  indicated line. This
          usually means that one or more words is missing on this line.



          42




                                    Miscellaneous
          _________________________________________________________________

          Memory allocation error

          A request for more memory was denied.  This is extremely unlikely
          to occur, as Install-Pro requires under 200k of free RAM.


          Error copying xxxxxxx

          DOS returned  an  error while  trying to  transfer the  indicated
          file.


          Cannot copy a file onto itself

          The user specified the installation diskette as the destination.


          Error creating directory: zzzzzzz

          DOS  returned  an  error while  trying  to  create  the indicated
          directory.  The most likely cause is if the user tries to install
          the  application to  a  directory that  is  the same  name as  an
          existing file.


          Authorization Error

          Install-Pro detected an authorization code that did not match the
          accompanying script  file (install.001).   Run  Install-Pro again
          with your key to authorize your script.
            

          Executable integrity error - bad executable

          Install-Pro detected  internal  errors in  its  executable  file.
          This usually means that  the file has become corrupted.   Restore
          an original from your backup and retry.


          Label not found: xxxxx, line nn

          The token in the <label name> position on the specified line does
          not  correspond to a previously defined label name created with a
          USER command.


          Invalid Disk Space Number



                                                                         43




                                    Miscellaneous
          _________________________________________________________________

          Either  no token,  or an  invalid token,  was detected  after the
          SPACE command.


          Unexpected EOF - AUTHORIZATION, END, CHAIN or DISK expected

          If Install-Pro parses to the end of a script without finding some
          indication of how to terminate, it returns this error.


          Zip output file creation error

          An error was detected while trying to create a file imbedded in a
          zip file.  The usual causes are out of disk space, network rights
          insufficient, or an existing directory of the same name.
            

          Zip file open error

          The zip file was not found, or no file handles were available. 


          Invalid zip file header

          An inconsistency was detected in the zip file.


          Zip file corrupted

          An extracted file's crc did not match its reported crc.


          Zip file encrypted

          Encrypted zip  files (and the  inherent password needed  to build
          the decryption key) are not supported.


          Error chaining to new program

          An error  was encountered  while trying  to load  a  new copy  of
          Install-Pro. Possible causes are  insufficient memory or file not
          found.


          System Error - current directory not available

          Install-Pro requested from DOS the name of the current directory,
          but DOS returned an error.

          44




                                    Miscellaneous
          _________________________________________________________________


          System Error - change directory failed

          An  attempt  by Install-Pro  to change  to another  directory (to
          unzip a file) failed.
            

          Unexpected end of file

          The  end of  an  zip file  was  encountered unexpectedly.    This
          usually means the file is damaged.


          Disk Write Error - target disk full?

          The majority of disk write errors are a full disk, but they could
          also be caused by hard disk  failure or logical errors in the FAT
          table.
            

          Directories must be 65 characters or less

          The  path entered  by the  user  plus the  SUBDIR attached  to it
          exceeded DOS'  maximum.   Don't  define  SUBDIRs longer  than  20
          characters to be safe.


          Unsupported ZIP version

          A  ZIP version of  higher than 2.04  was detected in  a zip file.
          Since  no  release version  of  ZIP greater  than  2.04 currently
          exists, this error may likely indicate zip file corruption.


          Invalid command

          The first token encountered  on the indicated line in  the script
          was not a valid command.












                                                                         45




                                    Miscellaneous
          _________________________________________________________________

          Critical Errors__________________________________________________

          Should a  disk door  be left  open (or  any other critical  error
          trapped by DOS, for  that matter) a Critical Error  handler built
          into  Install-Pro will take control  and provide the  user with a
          menu similar to this one:

                     
                     [DOS Critical Error]Ŀ
                                                             
                        [Abort]  [Retry]  [Ignore]  [Fail]   
                                                             
                     ٱ
                     

          If the user  accepts retry, he  will be in  most cases safe.   Of
          course, if his  computer picked  the exact moment  that he's  in-
          stalling  your application to  crash its hard  drive, no Critical
          Error handler is going to recover very gracefully.































          46
