/*
 Ŀ
  This is a copy of the ft_2clrSet(), ft_2clrMak(), and ft_2clrSay()       
  functions as originally submitted for inclusion in the Nanforum Toolkit. 
                                                                           
  To test the function, compile, link and run as follows (note that        
  "FT_TEST" must be upper case:                                            
                                                                           
    clipper twocolor /n /dFT_TEST                                          
    rtlink fi twocolor                                                     
    twocolor                                                               
                                                                           
  Recompile without the "/dFT_TEST" when you're ready to link it into your 
  program.                                                                 
 
*/


/*
 * File......: TWOCOLOR.PRG
 * Author....: Todd C. MacDonald
 * CIS ID....: 72274,2252 (formerly 73767,2242)
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Todd C. MacDonald and is hereby
 * placed in the public domain.
 *
 * Modification history:
 * ---------------------
 * 04-21-93 01:00am v1.00 TCM - Original version.
 *
 * 11-11-93 01:01am v1.01 TCM - Changed docs to reflect my new CIS ID.
 *
 * $Log$
 *
 */


#define SET_ROW      1
#define SET_COL      2
#define SET_ATTR_LO  3
#define SET_ATTR_HI  4


STATIC nDefRow    := -1   // Default is maxrow()
STATIC nDefCol    := -1   // Default is 0 and centered on nDefRow
STATIC cDefAttrLo := ''  // Default is White
STATIC cDefAttrHi := ''  // Default is Bright White


#ifdef FT_TEST


//--------------------------------------------------------------------------//
  FUNCTION TestDriver
//--------------------------------------------------------------------------//

#translate Say2Color( <list,...> ) => ft_2clrSay( ft_2clrMak( <list> ) )

#include "inkey.ch"
#include "setcurs.ch"

LOCAL nSavCrs := setcursor( SC_NONE )
LOCAL lQuit   := .f.

// create option prompt
LOCAL aOptPrompt := ft_2clrMak( 'F1=Help   Enter=Repeat Demo   ' + ;
  'Esc=Quit', -1, -1, 23, 30 )

LOCAL aPrvSet, aRedRed, nRow, nCol, nKey

WHILE !lQuit

  // set new default row, column, and color attributes
  aPrvSet := ft_2clrSet( { 16, 0, 48, 62 } )

  cls

  ?? 'Previous Default Settings:'
  ?
  ? 'Row     = ', aPrvSet[ SET_ROW ]
  ? 'Col     = ', aPrvSet[ SET_COL ]
  ? 'Lo Attr = ', aPrvSet[ SET_ATTR_LO ]
  ? 'Hi Attr = ', aPrvSet[ SET_ATTR_HI ]
  ?
  ?
  ? 'Current Default Settings:'
  ?
  ? 'Row     = ', ft_2clrSet()[ SET_ROW ]
  ? 'Col     = ', ft_2clrSet()[ SET_COL ]
  ? 'Lo Attr = ', ft_2clrSet()[ SET_ATTR_LO ]
  ? 'Hi Attr = ', ft_2clrSet()[ SET_ATTR_HI ]

  // make and display prompt at default location and in default colors
  Say2Color( 'Press Enter to continue...' )

  WHILE inkey() != K_ENTER; END

  // restore settings to previous state
  ft_2clrSet( aPrvSet )

  @ 16, 0

  ?? 'Restored Default Settings:'
  ?
  ? 'Row     = ', ft_2clrSet()[ SET_ROW ]
  ? 'Col     = ', ft_2clrSet()[ SET_COL ]
  ? 'Lo Attr = ', ft_2clrSet()[ SET_ATTR_LO ]
  ? 'Hi Attr = ', ft_2clrSet()[ SET_ATTR_HI ]

  // make and display prompt at default location and in default colors
  Say2Color( 'Press Enter to continue...' )

  WHILE inkey() != K_ENTER; END

  cls

  // create a new prompt
  aRedRed := ft_2clrMak( ' Reduce Redundancy! ', 0, 0, 71, 76 )

  // show the ability to override the row and column that were stored with the
  // prompt when it was created.
  dispbegin()

  FOR nCol := 0 TO 60 STEP 20

    FOR nRow := 0 TO maxrow() - 1

      ft_2clrSay( aRedRed, nRow, nCol )

    NEXT

  NEXT

  dispend()

  // display option prompt
  ft_2clrSay( aOptPrompt )

  WHILE .t.

    nKey := inkey( 0 )

    DO CASE

      CASE nKey = K_F1

        Say2Color( 'Sorry, no help available (did you ' + ;
          'really expect any? ;-)   Press any key...', -1, -1, 23, 30 )

        inkey( 0 )

        ft_2clrSay( aOptPrompt )

      CASE nKey = K_ENTER

        EXIT

      CASE nKey = K_ESC

        lQuit := .t.

        EXIT

    ENDCASE

  END

END

@ maxrow(), 0

setpos( maxrow() - 1, 0 )

RETURN nil
//--------------------------------------------------------------------------//


#endif


/*  $DOC$
 *  $FUNCNAME$
 *      ft_2clrSet()
 *  $CATEGORY$
 *      To be assigned
 *  $ONELINER$
 *      Set default Row, Col, Lo & Hi attributes for ft_2clrMak().
 *  $SYNTAX$
 *      ft_2clrset( [<aNewSettings>] ) --> aCurrentSettings
 *  $ARGUMENTS$
 *      <aNewSettings> is an array containing 4 optional elements as follows:
 *
 *      Position   Metasymbol
 *         
 *      1          <nRow>
 *      2          <nCol>
 *      3          <nLoAttr>
 *      4          <nHiAttr>
 *
 *      <nRow> is the default screen row where prompts created by ft_2clrMak()
 *      will be placed if no row is specifed when ft_2clrMak() is called.  A
 *      value of -1 indicates that the prompt should be displayed on maxrow().
 *
 *      <nCol> is the default screen column where prompts created by
 *      ft_2clrMak() will be placed if no column is specifed when ft_2clrMak()
 *      is called.  A value of -1 indicates that the prompt should be centered
 *      on <nRow>.
 *
 *      <nLoAttr> is an integer representing the color attribute of text in
 *      the prompt NOT bracketed by chr( 1 )'s.  The carets below the
 *      following sample prompt indicate the text which will be displayed in
 *      <nLoAttr>:
 *
 *      "F1=Help   Enter=Select   Esc=Cancel"
 *           ^^^^^^^^       ^^^^^^^^^^     ^^^^^^^
 *
 *      <nHiAttr> is an integer representing the color attribute of text in
 *      the prompt bracketed by chr( 1 )'s.  The carets below the following
 *      sample prompt indicate the text which will be displayed in <nHiAttr>:
 *
 *      "F1=Help   Enter=Select   Esc=Cancel"
 *        ^^          ^^^^^            ^^^
 *
 *      The formula for color attributes is: nFore + ( nBack * 16 )
 *  $RETURNS$
 *      ft_2clrSet() returns an array containing the current settings of
 *      <nRow>, <nCol>, <nLoAttr>, and <nHiAttr>.  This makes it easy to save
 *      and restore previous settings via a single memory variable.
 *  $DESCRIPTION$
 *      This function optionally sets and retrieves the default values used
 *      by the ft_2clrMak() function.  These default values are used for any
 *      corresponding parameters not passed to the ft_2clrMak() function.
 *  $EXAMPLES$
 *      // set new default row, column, and color attributes
 *      aPrvSet := ft_2clrSet( { 14, 0, 48, 62 } )
 *
 *      cls
 *
 *      ?? 'Previous Default Settings:'
 *      ?
 *      ? 'Row     = ', aPrvSet[ 1 ]
 *      ? 'Col     = ', aPrvSet[ 2 ]
 *      ? 'Lo Attr = ', aPrvSet[ 3 ]
 *      ? 'Hi Attr = ', aPrvSet[ 4 ]
 *      ?
 *      ? 'Current Default Settings:'
 *      ?
 *      ? 'Row     = ', ft_2clrSet()[ 1 ]
 *      ? 'Col     = ', ft_2clrSet()[ 2 ]
 *      ? 'Lo Attr = ', ft_2clrSet()[ 3 ]
 *      ? 'Hi Attr = ', ft_2clrSet()[ 4 ]
 *
 *      // make and display prompt at default location and in default colors
 *      ft_2clrSay( ft_2clrMak( 'Press Enter to continue...' ) )
 *
 *      WHILE inkey() != K_ENTER; END
 *
 *      // restore settings to previous state
 *      ft_2clrSet( aPrvSet )
 *
 *      @ 14, 0
 *
 *      ?? 'Restored Default Settings:'
 *      ?
 *      ? 'Row     = ', ft_2clrSet()[ 1 ]
 *      ? 'Col     = ', ft_2clrSet()[ 2 ]
 *      ? 'Lo Attr = ', ft_2clrSet()[ 3 ]
 *      ? 'Hi Attr = ', ft_2clrSet()[ 4 ]
 *  $SEEALSO$
 *      ft_2clrMak() ft_2clrSay()
 *  $INCLUDE$
 *
 *  $END$
 */


//--------------------------------------------------------------------------//
  FUNCTION ft_2clrSet( aNewSets )
//--------------------------------------------------------------------------//

LOCAL aOldSets := { nDefRow, nDefCol, asc( cDefAttrLo ), asc( cDefAttrHi ) }

IF valtype( aNewSets ) = 'A'

  // set new default row, if passed
  IF ( len( aNewSets ) >= SET_ROW ) .and. ;
    ( valtype( aNewSets[ SET_ROW ] ) = 'N' )

    nDefRow := aNewSets[ SET_ROW ]

  ENDIF

  // set new default column, if passed
  IF ( len( aNewSets ) >= SET_COL ) .and. ;
    ( valtype( aNewSets[ SET_COL ] ) = 'N' )

    // set new default column
    nDefCol := aNewSets[ SET_COL ]

  ENDIF

  // set new default low intensity attribute, if passed
  IF ( len( aNewSets ) >= SET_ATTR_LO ) .and. ;
    ( valtype( aNewSets[ SET_ATTR_LO ] ) = 'N' )

    cDefAttrLo := chr( aNewSets[ SET_ATTR_LO ] )

  ENDIF

  // set new default high intensity attribute, if passed
  IF ( len( aNewSets ) >= SET_ATTR_HI ) .and. ;
    ( valtype( aNewSets[ SET_ATTR_HI ] ) = 'N' )

    cDefAttrHi := chr( aNewSets[ SET_ATTR_HI ] )

  ENDIF

ENDIF

RETURN aOldSets
//--------------------------------------------------------------------------//


/*  $DOC$
 *  $FUNCNAME$
 *      ft_2clrMak()
 *  $CATEGORY$
 *      To be assigned
 *  $ONELINER$
 *      Creates a prompt to be displayed by ft_2clrSay().
 *  $SYNTAX$
 *      ft_2clrMak( <cPrompt>, [<nRow>], [<nCol>], [<nLoAttr>], [<nHiAttr>] )
 *        --> aPrompt
 *  $ARGUMENTS$
 *      <cPrompt> is the character string to be displayed by ft_2clrSay().
 *      Any text within the string bracketed by chr( 1 )'s will be displayed
 *      in <nHiAttr>.  All other text will be displayed in <nLoAttr>.
 *
 *      <nRow> is the row where the prompt is to be displayed.  If no row is
 *      specified, <nRow> will default to whatever ft_2clrSet() currently
 *      reports.  A value of -1 indicates that the prompt should be displayed
 *      on maxrow().
 *
 *      <nCol> is the column where the prompt is to be displayed.  If no
 *      column is specified, <nCol> will default to whatever ft_2clrSet()
 *      currently reports.  A value of -1 indicates that the prompt should be
 *      centered on <nRow>.
 *
 *      <nLoAttr> is an integer representing the color attribute of text in
 *      the prompt NOT bracketed by chr( 1 )'s.  If no low attribute is
 *      specified, <nLoAttr> will default to whatever ft_2clrSet() currently
 *      reports. The carets below the following sample prompt indicate the
 *      text which will be displayed in <nLoAttr>:
 *
 *      "F1=Help   Enter=Select   Esc=Cancel"
 *           ^^^^^^^^       ^^^^^^^^^^     ^^^^^^^
 *
 *      <nHiAttr> is an integer representing the color attribute of text in
 *      the prompt bracketed by chr( 1 )'s.  If no high attribute is
 *      specified, <nHiAttr> will default to whatever ft_2clrSet() currently
 *      reports.  The carets below the following sample prompt indicate the
 *      text which will be displayed in <nHiAttr>:
 *
 *      "F1=Help   Enter=Select   Esc=Cancel"
 *        ^^          ^^^^^            ^^^
 *
 *      The formula for color attributes is: nFore + ( nBack * 16 )
 *  $RETURNS$
 *      ft_2clrMak() returns an array containing the screen image, row, and
 *      column as follows:
 *
 *      { cScrImage, nRow, nCol }
 *  $DESCRIPTION$
 *      This function creates a prompt which may be displayed by the
 *      ft_2clrSay() function.
 *
 *      The array returned by ft_2clrMak() may be saved to a memory variable
 *      for repetitive calls to ft_2clrSay(), or passed directly to
 *      ft_2clrSay() for immediate display.
 *
 *      For the sake of speed when doing multiple screen writes, it is
 *      recommended that the prompts be created and saved to memory variables
 *      beforehand and output in rapid succession via ft_2clrSay() along with
 *      your normal "@ say"'s.  Speed (rather Clipper's lack thereof) is the
 *      reason, in fact, why there are distinct functions for creation and
 *      output.
 *  $EXAMPLES$
 *      LOCAL aPrompt := ft_2clrMak( 'Abort  Retry  Detonate', ;
 *        -1, -1, 23, 30 )
 *
 *      ft_2clrSay( aPrompt )
 *  $SEEALSO$
 *      ft_2clrSet() ft_2clrSay()
 *  $INCLUDE$
 *
 *  $END$
 */


//--------------------------------------------------------------------------//
  FUNCTION ft_2clrMak( cPrompt, nRow, nCol, nAttrLo, nAttrHi )
//--------------------------------------------------------------------------//

LOCAL lCtrIt    := .t.
LOCAL cScrImage := ''
LOCAL nLen      := len( cPrompt )

LOCAL cAttrLo, cAttrHi, cAttr, n, cThisChr, nReps

// set row
IF valtype( nRow ) = 'N'

  nRow := iif( nRow < 0, maxrow(), nRow )

ELSE

  nRow := iif( nDefRow < 0, maxrow(), nDefRow )

ENDIF

// set column and center flag
IF valtype( nCol ) = 'N'

  IF nCol < 0

    nCol := 0

  ELSE

    lCtrIt := .f.

  ENDIF

ELSE

  IF nDefCol < 0

    nCol := 0

  ELSE

    nCol   := nDefCol
    lCtrIt := .f.

  ENDIF

ENDIF

// set low intensity attribute
cAttrLo := iif( valtype( nAttrLo ) = 'N', chr( nAttrLo ), cDefAttrLo )

// set high intensity attribute
cAttrHi := iif( valtype( nAttrHi ) = 'N', chr( nAttrHi ), cDefAttrHi )

// create a screen image of the prompt to be used by the restscreen function
cAttr := cAttrLo

FOR n := 1 to nLen

  cThisChr := substr( cPrompt, n, 1 )

  IF cThisChr = ''

    IF cAttr = cAttrLo

      cAttr := cAttrHi

    ELSE

      cAttr := cAttrLo

    ENDIF

  ELSE

    cScrImage += cThisChr + cAttr

  ENDIF

NEXT

IF lCtrIt

  nReps := int( ( ( maxcol() + 1 ) - ( len( cScrImage ) / 2 ) ) / 2 )

  cScrImage := replicate( ' ' + cAttrLo, nReps ) + cScrImage

  cScrImage += replicate( ' ' + cAttrLo, ;
    maxcol() + 1 - ( len( cScrImage ) / 2 ) )

ENDIF

RETURN { nRow, nCol, cScrImage }
//--------------------------------------------------------------------------//


/*  $DOC$
 *  $FUNCNAME$
 *      ft_2clrSay()
 *  $CATEGORY$
 *      To be assigned
 *  $ONELINER$
 *      Displays a prompt created by ft_2clrMak().
 *  $SYNTAX$
 *      ft_2clrSay( <aPrompt>, [<nRow>], [<nCol>] ) --> NIL
 *  $ARGUMENTS$
 *      <aPrompt> is a prompt created by the ft_2clrMak() function.
 *
 *      <nRow> may be specified to override the row which is stored in
 *      <aPrompt>.  The use of -1 to specify maxrow() is not allowed here.
 *      If you wish to override the row, you must specify a valid screen
 *      position.
 *
 *      <nCol> may be specified to override the column which is stored in
 *      <aPrompt>.  The use of -1 to specify centering is not allowed here.
 *      If you wish to override the column, you must specify a valid screen
 *      position.
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      This function displays a prompt which was created by the ft_2clrMak()
 *      function.
 *  $EXAMPLES$
 *      #translate Say2Color( <list,...> ) => ft_2clrSay( ft_2clrMak( <list> ) )
 *
 *      LOCAL aPrompt := ft_2clrMak( 'F1=Help   F3=Save   Esc=Cancel' )
 *
 *      ft_2clrSay( aPrompt )
 *
 *      inkey( 0 )
 *
 *      // pseudofunction to make one-time prompts a little cleaner
 *      Say2Color( 'Are you sure? [Y/n]', -1, -1, 71, 78 )
 *  $SEEALSO$
 *      ft_2clrSet() ft_2clrMak()
 *  $INCLUDE$
 *
 *  $END$
 */


//--------------------------------------------------------------------------//
  FUNCTION ft_2clrSay( aPrompt, nRow, nCol )
//--------------------------------------------------------------------------//

#define PROMPT_ROW  1
#define PROMPT_COL  2
#define PROMPT_TXT  3

/*

valtype() is not used to check the nRow and nCol parameters for the sake of
speed.  If you pass nRow or nCol, it's up to you to make sure they are
numeric.

*/

IF nRow = nil

  nRow := aPrompt[ PROMPT_ROW ]

ENDIF

IF nCol = nil

  nCol := aPrompt[ PROMPT_COL ]

ENDIF

restscreen( nRow, nCol, nRow, ;
  nCol + ( len( aPrompt[ PROMPT_TXT ] ) / 2 ) - 1, aPrompt[ PROMPT_TXT ] )

RETURN nil
//--------------------------------------------------------------------------//
