@echo off
REM  Installation script for Windev on Windows 3.1 or NT.
REM  Must be run from the installation disk.
REM  Usage: INSTALL [-n or -w] dest-dir

set FILLER=123456789012345678901234567890
if %FILLER% == 123456789012345678901234567890 goto getos
@echo Increase environment space before continuing
goto end

:getos
set FILLER=
if "%1" == "-w" goto win3
if "%1" == "-W" goto win3
if "%1" == "-n" goto nt
if "%1" == "-N" goto nt

if exist win3\windev.exe goto setwin3
if exist nt\windev.exe goto setnt
@echo INSTALL must be run from the root of the installation disk.
goto end

:win3
shift
if exist win3\windev.exe goto setwin3
@echo Cannot find windev.exe for Windows 3.1.
goto end

:setwin3
set os=win3
@echo Installing Windev for Windows 3.1
goto setdest

:nt
shift
if exist nt\windev.exe goto setnt
@echo Cannot find windev.exe for Windows NT.
goto end

:setnt
set os=nt
@echo Installing Windev for Windows NT

:setdest
if not "%1" == "" goto windir
@echo Usage: INSTALL [-n or -w] destination-directory
goto end

:windir
if not "%windir%" == "" goto mkdirs
if exist c:\windows\win.ini goto setwin
@echo Cannot determine Windows installation directory.
@echo Set environment variable WINDIR and start again.
goto end

:setwin
set windir=C:\WINDOWS

:mkdirs
set destdir=%1\windev
mkdir %destdir%
mkdir %destdir%\%os%

REM --- O/S specific, common named files.
@echo Copying to %destdir%\%os% ...
@echo windev.exe...
copy %os%\windev.exe %destdir%\%os%
if not exist %destdir%\%os%\windev.exe goto copyerr
@echo windevx.exe...
copy %os%\windevx.exe %destdir%\%os%
if not exist %destdir%\%os%\windevx.exe goto copyerr
if exist %os%\windev.reg copy %os%\windev.reg %destdir%\%os%

if "%os%" == "nt" goto ntfiles
REM --- Windows 3 specific files.
@echo instw31.txt...
copy instw31.txt %destdir%
if not exist %destdir%\instw31.txt goto copyerr
@echo stbar.dll...
copy %os%\stbar.dll %destdir%\%os%
if not exist %destdir%\%os%\stbar.dll goto copyerr
@echo Copying windevpj.pif to %windir%
copy %os%\windevpj.pif %windir%
if not exist %windir%\windevpj.pif goto copyerr
if exist %windir%\system\ctl3d.dll goto shared
@echo Copying ctl3d.dll to %windir%\system
copy %os%\ctl3d.dll %windir%\system
goto shared

:ntfiles
REM --- Windows NT specific files.
if not exist instaxp.txt goto instnt
@echo instaxp.txt...
copy instaxp.txt %destdir%
if not exist %destdir%\instaxp.txt goto copyerr
:instnt
if not exist instnt.txt goto projexec
@echo instnt.txt...
copy instnt.txt %destdir%
if not exist %destdir%\instnt.txt goto copyerr
:projexec
@echo projexec.exe...
copy %os%\projexec.exe %destdir%\%os%
if not exist %destdir%\%os%\projexec.exe goto copyerr
if exist %windir%\system32\ctl3d32.dll goto shared
if not exist %os%\ctl3d32.dll goto shared
@echo Copying ctl3d32.dll to %windir%\system32
copy %os%\ctl3d32.dll %windir%\system32\ctl3d32.dll

:shared
REM --- Common files.
@echo Copying to %destdir% ...
@echo readme.txt...
copy readme.txt %destdir%
if not exist %destdir%\readme.txt goto copyerr
@echo windev.hlp...
copy windev.hlp %destdir%
if not exist %destdir%\windev.hlp goto copyerr
@echo license.txt...
copy license.txt %destdir%
if not exist %destdir%\license.txt goto copyerr
@echo changes.txt...
copy changes.txt %destdir%
if not exist %destdir%\changes.txt goto copyerr
@echo quickgo.txt...
copy quickgo.txt %destdir%
if not exist %destdir%\quickgo.txt goto copyerr
@echo windevx.txt...
copy windevx.txt %destdir%
if not exist %destdir%\windevx.txt goto copyerr
@echo features.wri...
copy features.wri %destdir%
if not exist %destdir%\features.wri goto copyerr

@echo ---------------------------------------------------------
@echo Windev has been successfully installed in %destdir%
@echo Please read readme.txt before starting use.
@echo Use Program Manager to add %destdir%\%os%\windev.exe
@echo to a program group.
@echo ---------------------------------------------------------
goto end

:copyerr
@echo File copy error, abandoning installation.

:end
