------------------------------------------------------------------------
File      : notgnu.fun
Purpose   : Function descriptions for NotGNU's M-x describe-function.
Created on: Nov 27, 1993 by Tor Slettnes <tor@netcom.com>
Modified  : Nov 27-Dec 5 by Bernie Hayden, Julie Melbin, Tor Slettnes.
            Dec 11, 1993 by Tor Slettnes

NotGNU is Copyright (C) 1993 Julie Melbin.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
------------------------------------------------------------------------

alarms (No default binding)
    Maintenance of NotGNU's alarm/reminder utility, NotAlarm.

append-region-to-buffer (C-x a)
    Append region to specified buffer. If the buffer does not exists,
    create a new one.

apropos (C-h a)
    List all commands containing specified argument. For a list of all
    commands, do M-x apropos RET (C-h a RET).

auto-fill-mode (No default binding)
    Toggle automatic line wrap on/off. If on, inserting a space at a
    column beyond the fill column (see set-fill-column) automatically
    breaks the line at a previous space.  Default: off.
    
auto-indent-mode (No default binding)
    Swap key bindings for LFD (newline-and-indent) and CR (newline),
    i.e. toggle automatic indentation on/off.  Default: off.
    See also: newline, newline-and-indent

backward-char (C-b, Left-Arrow)
    Move cursor one position to the left, or to the end of previous
    line if already at beginning of line.

backward-kill-word (MBackspace)
    Kill word to the left of cursor.

backward-paragraph (M-[, Control-Home)
    Move to the beginning of this or the previous paragraph.

backward-word (M-b, Control-Left)
    Move to the beginning of this or previous word.


________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                              Page 2
------------------------------------------------------------------------

beginning-of-buffer (M-<, Control-PgUp)
    Move cursor to the beginning of current buffer.

beginning-of-line (C-a, Home)
    Move cursor to the beginning of current line.

blink-match (No default binding)
    If character under cursor is one of ()[]{}<>, and there exists a
    match for that character in the current buffer, show the match
    by moving cursor there for about 1/4 second.

blink-matching-paren (No default binding)
    Same as "cmode" currently.

buffer-flush-undo (No default binding)
    Clear the undo stack; free memory.

bury-buffer (No default binding)
    Put BUFFER at the end of the list of all buffers. There it is
    the least likely candidate for `other-window' to return; thus,
    the least likely buffer for C-x b to select by default.

c-indent-off (No default binding)
    Currently unavailable.

c-indent-on (No default binding)
    Currently unavailable.

c-x 4 prefix (C-x 4)
    Apply certain extended commands to other pane/window.
    Example: "C-x 4 d" runs dired-other-window

c-x prefix (C-x)
    Apply extended command to this pane/window.
    Example: "C-x C-c" runs save-buffers-kill-emacs

call-last-kbd-macro (C-x e)
    Execute recorded key sequence. See start-kbd-macro.

capitalize-word (M-c)
    Convert word, beginning with character under cursor, to uppercase,
    and the rest of the word to lowercase.


________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                              Page 3
------------------------------------------------------------------------

center-line (No default binding)
    Center text on current line between left column and fill column.

center-region (No default binding)
    Center all lines that start between cursor and mark.

clear-rectangle (No default binding)
    Fill rectangle region with blanks

cmode (No default binding)
    Toggle parenthesis matching on/off. Default: off
    See also: blink-match

compile (No default binding)
    Spawn an external command with redirection to a log file, then
    optionally insert that log file into a separate buffer.  Default
    command can be specified with the MEMAKE environment variable;
    otherwise it is "nmake" under DOS/Windows, and "make" under
    Unix.

copy-rectangle (C-x r)
    Copy text from rectangle between cursor and mark to the
    rectangle kill buffer.

copy-region-as-kill (M-w)
    Copy region between cursor and mark to kill buffer

copy-region-to-buffer (No default binding)
    Copies region between cursor and mark to specified buffer.
    If buffer already exists, its contents will be erased before
    copying; if not, a new one will be created.

copy-region-to-clipboard (C-x x)
    Copy region to the Windows clipboard or X11 cutbuffer 0.

define-key (No default binding)
    Syntax: (define-key keymap "Sequence" 'extended-command)
    Define a key sequence in specified keymap. Available keymaps
    are: *, fill, indent, C, overwrite, help, dired, blist.

delete-backward-char (Backspace)
    Delete character to the left of cursor.


________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                              Page 4
------------------------------------------------------------------------

delete-blank-lines (C-x C-o)
    On blank line, delete all surrounding blank lines, leaving just
    one. On isolated blank line, delete that one. On nonblank line,
    delete all blank lines that follow it.

delete-char (C-d, Delete)
    Delete character under cursor.

delete-horizontal-space (M-\)
    Delete all spaces and tabs around cursor.

delete-indentation (M-^)
    Join this line to previous and fix up whitespace at join.

delete-line (M-m)
    Kill current line, including the trailing newline character.

delete-rectangle (No default binding)
    Delete text in rectangle (do not save in kill buffer).
    See also: kill-rectangle.

delete-other-windows (C-x 1)
    Remove all screen panes, except the one containing cursor.

delete-window (C-x 0)
    Remove the screen pane that contains the cursor.

describe-bindings (C-h b)
    List all key bindings currently active.

describe-function (C-h f)
    Display the full documentation of a function.

describe-key-briefly (C-h c)
    Print the name of the function that the subsequent key sequence
    invokes.

digit-argument (M-0 .. M-9)
    Part of the numeric argument for the next command





________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                              Page 5
------------------------------------------------------------------------

dired (C-x d)
    Interactive screen mode that lets you edit, view, or delete
    files in a specified directory. The following keymap is
    available in 'dired':
        e = Edit this file
        f = find-file
        v = view-file
        d = Delete this file
        m = Mark file for batch processing.
            Available in single column mode only.
    
    Mouse double-click is equal to find-file.

dired-other-window (C-x 4 d)
    Open a dired buffer in other screen pane. See also: dired

dired-single-column (No default binding)
    Syntax: (dired-single-column 'bool)
    Specify whether to use single columns when listing files in the
    dired buffer.  If 1, all file information is displayed, and the
    'm' (mark for batch) command will be available. If not, multiple
    columns will be used.
    Default: 1

display-filename (No default binding)
    Toggle filename display in modeline on/off.
    Default: on

display-time (No default binding)
    Toggle time display in modeline or titlebar (windowed versions) on/off.
    Default: on

downcase-region (C-x C-l)
    Convert all characters between cursor and mark into lowercase.

downcase-word (M-l)
    Convert the following word, or the rest of the current word,
    into lowercase.

emacs-version (No default binding)
    Print current version of NotGNU, with compile date, in the echo line.



________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                              Page 6
------------------------------------------------------------------------

end-kbd-macro (C-x ))
    End recording key sequence.  See also: start-kbd-macro.

end-of-buffer (M->, Control-PgDn)
    Move cursor to the end of current buffer.

end-of-line (C-e, End)
    Move the cursor the end of current line.

enlarge-window (C-x ^)
    Increase the size of the current screen pane by one line.  If
    called interactively with universal-argument (C-u), increase by
    that number of lines.

esc prefix (Esc)
    Extended command prefix.

eval-expression (No default binding)
    Evaluate (execute) function given as argument;  print result in
    minibuffer. Useful for interactively testing load file syntax of
    a function.

exchange-point-and-mark (C-x C-x)
    Exchange the positions of cursor and mark. If new cursor is
    outside visible screen pane, update display.

execute-extended-command (M-x)
    Execute any emacs command by name.  To go to a specific line,
    type: M-x goto-line <RET>, followed by the line number you want
    to go to.

fill-paragraph (M-q)
    Reformats lines in current paragraph to even out margins based
    on the value of "fill-column".

fill-region (No default binding)
    Reformats lines in all paragraphs between point and mark to even
    out margins based on the value of fill-column.






________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                              Page 7
------------------------------------------------------------------------

find-file (C-x C-f)
    Loads a file for editing.  Autocompletion is available: Press
    the space key after typing in the first few characters of the
    filename, and the filename will be  completed if unique, or a
    new buffer with the list of alternatives will pop up if not.
    See also: view-file

find-file-other-window (C-x 4 C-f)
    Loads a file for editing in other screen pane.
    See also: find-file.

find-first-change (No default binding)
    Go to first line that has been changed since last save.

find-next-change (No default binding)
    Go to next line (from current position) that has been changed
    since last save.

forward-char (C-f)
    Move cursor one position to the right, or to the beginning of
    next line if already at end of line.

forward-paragraph (M-])
    Move cursor to the end of this or next paragraph.

forward-word (M-f, Control-Right)
    Move cursor to the end of this or next word.

global-set-key (No default binding)
    Syntax: (global-set-key "Sequence" 'extended-command)
    Assign specified key sequence to specified command.
    See also: global-set-key

global-unset-key (No default binding)
    Syntax: (global-unset-key "Sequence")
    Unassign specified key sequence from any command.
    See also: global-unset-key

goto-line (No default binding)
    Move cursor to beginning of specified line.




________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                              Page 8
------------------------------------------------------------------------

goto-match (No default binding)
    Move cursor to matching character if one of (){}[]<>, otherwise
    move to the previous occurrence of the same character.

hard-tab (C-TAB)
    Insert a TAB character (^I) in the text at cursor.

help-help (C-h)
    Help prefix.  Default map:
        C-h a = apropos
        C-h b = describe-bindings
        C-h c = describe-key-briefly
        C-h d = list-key-names
        C-h f = describe-function

insert-buffer (No default binding)
    Insert specified buffer into current buffer at cursor position.

insert-chars (No default binding)
    Insert a string into current buffer at cursor position.

insert-file (C-x i)
    Insert a file into buffer at cursor position.

insert-with-wrap (No default binding)
    An internal command. Not useful via keyboard.

isearch-backward (C-r)
    Incremental search backward.  Interactively search as you type,
    and move the cursor to the closest occurrence of the string typed
    so far.  Not available inside keyboard macros; see search-backward
    for such use.

isearch-forward (C-s)
    Incremental search forward.  Interactively search as you type,
    and move the cursor to the closest occurrence of the string typed
    so far.  Not available inside keyboard macros see search-forward
    for such use.

just-one-space (No default binding)
    If executed, will make sure that there is at most 1 blank
    between the beginning of the line/next non-whitespace character
    from current position.

________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                              Page 9
------------------------------------------------------------------------

keyboard-quit (C-g)
    Abort an extended command.

kill-buffer (C-x k)
    Remove specified buffer from the buffer list.  If the buffer
    has been updated since last save to a file, you will be asked
    whether to save before quitting.

kill-current-buffer (No default binding)
    Same as kill-buffer, but remove current buffer.

kill-emacs (No default binding)
    Ask for confirmation, then exit without saving the contents of
    updated buffers.  No confirmation per buffer.
    See also: save-buffers-kill-emacs.

kill-line (No default binding)
    Kill the rest of the current line; if there are no non-blanks
    there, include the following newline character.

kill-paragraph (No default binding)
    Kill to the end of current or next paragraph.

kill-rectangle (No default binding)
    Kill text from rectangle between cursor and mark to the
    rectangle kill buffer.

kill-region (No default binding)
    Kill region between cursor and mark to the kill buffer.

kill-region-to-clipboard (No default binding)
    Cut region between cursor and mark to the Windows clipboard or
    X11 cutbuffer 0.

kill-word (M-d)
    Kill to the end of current or next word.








________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                             Page 10
------------------------------------------------------------------------

list-buffers (C-x C-b)
    Open a (new) screen pane containing list of available buffers.
    The following keymap is available in buffer list:
        u = Use (switch to) this buffer
        s = Save this buffer
        k = Kill this buffer
    
    Mouse-double click is equal to use-buffer.

list-key-names (C-h d)
    Print all legal key names.  Useful for startup file binding of
    'special named keys'.

load-buffer (No default binding)
    Evaluate (execute) commands given in current buffer.

load-file (No default binding)
    Evaluate (execute) given file.

local-set-key (No default binding)
    Syntax: (local-set-key "Sequence" 'extended-command)
    Assign key sequence to a specified command in current mode map.
    Modes available are: *, fill, indent, C, overwrite, help, dired,
    blist. See also: global-set-key, define-key.

local-unset-key (No default binding)
    Syntax: (local-unset-key "Sequence")
    Unassign specified key sequence from any command in current
    mode map.  See also: local-set-key, global-unset-key

make (No default binding)
    Spawn an external command with redirection to a log file, then
    optionally insert that log file into a separate buffer.  Default
    command can be specified with the MEMAKE environment variable;
    otherwise it is "nmake" under DOS/Windows, and "make" under
    Unix. Same as compile.

make-backup-files (No default binding)
    Syntax: (make-backup-files)
    Toggles whether to create backup files on/off.  Default: on.
    Same as toggle-make-backups.



________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                             Page 11
------------------------------------------------------------------------

negative-argument (No default binding)
    Specify negative argument for subsequent command.
    See also: universal-argument.

newline (C-m/RET)
    Insert a newline character at cursor position, and move
    the cursor to the beginning of the newly opened line.

newline-and-indent (C-j/LFD)
    Insert a newline character at cursor position; move cursor to
    the newly opened line, at the maximum column that satisfies both
    of the following requirements:
        1) No larger than the current column
        2) No larger than the column of the first non-white character
           in previous line.
    If auto-indent-mode is on, CR and LFD are swapped. CR will then be
    bound to newline-and-indent.

next-buffer-in-list (M-n)
    Switch to the next buffer in the buffer list.

next-error (C-x `)
    Visit next compilation error message and corresponding source
    code.  This operates on the log file output from the M-x compile
    or M-x make commands.  Supported for MSC 6 and 7, MSVC++, Borland
    C++, the MS compiler on NT, CC on Ultrix, DEC-OSF, HP-UX, and
    Solaris 2.1 with SunSoft compiler.

next-line (C-n)
    Move cursor one line down.

open-line (C-o)
    Insert a newline character at cursor position.

open-rectangle (No default binding)
    Inserts spaces into rectangle between cursor an mark.

other-window (C-x o)
    Move cursor to the next screen pane.

overwrite-mode (No default binding)
    Syntax: (overwrite-mode)
    Toggle overwrite mode on/off.  Default: off.

________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                             Page 12
------------------------------------------------------------------------

previous-buffer-in-list (M-p)
    Switch to the previous buffer in buffer list.

previous-line (C-p)
    Move cursor one line up.

previous-window (M-C-Up)
    Move cursor to previous screen pane.

print-buffer (No default binding)
    Send current buffer to printer/printer driver.

print-file (No default binding)
    Send specified file to printer/printer driver.

print-file-exit (No default binding)
    Send specified file to printer/printer driver, then exit NotGNU.

query-on-subtask-done (No default binding)
    Syntax: (query-on-subtask-done 'bool)
    If 1, ask for confirmation before inserting the output from
    subtasks such as compile into a separate buffer upon completion;
    otherwise insert automatically. Default: 1

query-replace (M-%)
    Replace one string with another, query on each replace.
    See also: replace-string, set-case

query-save-buffers (No default binding)
    Syntax: (query-save-buffers 'bool)
    If 1, ask for confirmation before killing any buffer (also
    *scratch*); otherwise ask only for those buffers that are
    associated with a file. Default: 1

quoted-insert (C-q)
    Read next input character and insert it raw.  Useful for
    inserting control characters.  You may also type up to 3 octal
    digits, to insert a character with that code.

recenter (C-l)
    Redraw screen with line that contains cursor in the center of
    current screen pane.


________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                             Page 13
------------------------------------------------------------------------

recover-file (No default binding)
    Get the contents from last auto-save of the file specified.

redraw-display (No default binding)
    Redraw screen.

replace-string (No default binding)
    Unconditional string replace.
    See also: query-replace, set-case.

reread-file (No default binding)
    Equal to killing w/o saving the current file, then revisiting.

revert-to-incremental (No default binding)
    Get the contents from last auto-save of the file specified. Same
    as M-x recover-file.

save-buffer (C-x C-s)
    Save the contents of current buffer to file.

save-buffers-kill-emacs (C-x C-c)
    Save unsaved buffers and exit emacs.

save-some-buffers (C-x s)
    For each modified buffer, query the user whether to save.

scroll-down (M-v, Page-Up)
    Move text in current buffer one screenful down.

scroll-one-line-down (Control-Up) (Hardwired)
    Move text in current buffer one line down.

scroll-one-line-up (Control-Down) (Hardwired)
    Move text in current buffer one line up.

scroll-other-window (No default binding)
    Scroll text in other window ARG lines up.
    See also: negative-argument, universal-argument.

scroll-up (C-v, Page-Down)
    Move text in current buffer one screenful up.



________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                             Page 14
------------------------------------------------------------------------

search-again (No default binding)
    Repeat last search-backward or search-forward.

search-backward (M-r)
    Search backward from cursor for given string.  Can be used
    inside keyboard macros rather than isearch-backward; also useful
    if using NotGNU remotely via a slow modem line.

search-forward (M-s)
    Search forward from cursor for given string.  Can be used inside
    keyboard macros rather than isearch-forward;  also useful if
    using NotGNU remotely via a slow modem line.

self-insert-command (SP .. ~, \200 .. \377)
    Insert typed character into current buffer at cursor.

set-autosave-inc (No default binding)
    Syntax: (set-autosave-inc 'value)
    Specify approximate interval between each auto-save, in seconds.
    Default: 15

set-bg-color (No default binding)
    Syntax: if X11 (set-bg-color 'color)
    Specify background color.  In Windows, bring up a dialogue box;
    should not be executed from the startup file.  Not available in
    DOS or Unix curses versions.

set-case (No default binding)
    Syntax: (set-case 'value)
    Specify whether replace-string and query-replace should do case
    insensitive search, and/or preserve case when replacing. The
    value given should be one of the following:
        00 - case insensitive search, case-match replace.
        01 - case exact search, case-match replace
        10 - case insensitive search, exact replace
        11 - case exact search, exact replace
    See also: query-replace, replace-string







________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                             Page 15
------------------------------------------------------------------------

set-default-mode (No default binding)
    Syntax: (set-default-mode 'mode)
    Toggle whether a mode is activated in subsequent buffers.
    The following modes are available: fill, indent, C, overwrite.
    Default: All except 'C' off, 'C' on if buffername ends with
    one of ".c", ".h", ".cpp", ".hpp".

set-fg-color (No default binding)
    Syntax: if X11 (set-fg-color 'color)
    Specify normal text color.  In Windows, bring up a dialogue box;
    should not be executed from the startup file.  Not available in
    DOS or Unix curses versions.

set-fg2-color (No default binding)
    Syntax: if X11 (set-fg2-color 'color)
    Specify touched text color.  In Windows, bring up a dialogue box;
    should not be executed from the startup file.  Not available in
    DOS or Unix curses versions.

set-fg3-color (No default binding)
    Syntax: if X11 (set-fg3-color 'color)
    Specify prompt and highlight color.  In Windows, bring up a
    dialogue box;  should not be executed from the startup file.
    Not available in DOS or Unix curses versions.

set-fill-column (C-x f)
    Syntax: (set-fill-column 'value)
    Set fill column for line wrapping to specified value. If called
    interactively, current column is used, or one can be specified
    via M-x universal-argument (C-u).

set-font (No default binding)
    Syntax: if X11 (set-font 'fontname)
    Specify text font. Only monospaced fonts should be used.
    In Windows, bring up a dialogue box;  should not be executed from
    the startup file.  Not available in DOS or Unix curses versions.

set-gnu (No default binding)
    Syntax: (set-gnu 'bool)
    Specify whether GNU-style autocompletion on commands and
    filenames should be used. Default: 0  (turned off).



________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                             Page 16
------------------------------------------------------------------------

set-mark-command (C-@, C-space)
    Set mark at current cursor position. After subsequent moves with
    cursor, area between mark and cursor will then become the current
    region. See also: kill-region, copy-region-as-kill, etc.

set-select-highlight (No default binding)
    Syntax: (set-select-highlight 'value)
    If value is "f", highlighted regions will be marked by changing
    the color of the text; if value is "b", marking is done by
    changing the background color. Default: b  (background)

set-tab-stop (No default binding)
    Syntax: (set-tab-stop 'value)
    Specify the maximum number of spaces between all tabstops.
    Legal range is 1 to 16, inclusive. Default: 8

set-text-color (No default binding)
    See set-fg-color.

set-touched-text-color (No default binding)
    See set-fg2-color.

set-window-color (No default binding)
    See set-bg-color.

set-window-size (No default binding)
    Syntax: (set-window-size 'rows,cols)
    Specify the size of the NotGNU window. In DOS version, rows is
    restricted to 25, 43, or 50, and cols is restricted to 40 or 80.
    Default: Depending on NotGNU version.

set-write-cr (No default binding)
    Specify whether to insert a CR before each newline character
    when writing the current buffer to file. Default is specified by
    M-x toggle-just-write-newline.

shell-command (No default binding)
    Executes the command that the MESHELL environment variable points
    to, or COMMAND.PIF, or command.com/cmd.exe, in that order of
    priority, with "/c command" as argument under DOS/Windows, or
    "command" as argument under Unix/X11.



________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                             Page 17
------------------------------------------------------------------------

shell-window (C-z)
    Executes the command that the MESHELL environment variable
    points to, or MESHELL.PIF, or command.com/cmd.exe, in that order
    of priority, with no arguments, in a separate window.

show-env (No default binding)
    In the minibuffer, print home and executables directories.

show-filename (No default binding)
    In the minibuffer, print the name of the file currently being
    edited.

show-region (No default binding)
    Highlight current region.

shrink-window (No default binding)
    Decrease the size of the current screen pane by one line. If
    called interactively with universal-argument (C-u), decrease by
    that number of lines.

soft-tab (No default binding)
    Insert spaces until the next tab stop.

split-window-vertically (C-x 2)
    Split current screen pane into two equally sized screen panes,
    separated by the modeline of the top pane.

start-kbd-macro (C-x ()
    Start recording key sequence. Subsequent keys will be stored
    in a macro, until M-x end-kbd-macro ("C-x )") is called. The
    recorded macro can then be executed (multiple) times via
    M-x universal-argument and M-x call-last-kbd-macro.
    See also: end-kbd-macro, call-last-kbd-macro, universal-argument.

switch-to-buffer (C-x b)
    Display another existing buffer in current screen pane.

switch-to-buffer-other-window (C-x 4 b)
    Display another existing buffer in other screen pane.

tabify (No default binding)
    Converts spaces to TABs between cursor and mark.
    See also: set-tab-stop

________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                             Page 18
------------------------------------------------------------------------

toggle-check-file-timestamp (No default binding)
    Toggle state of file timestamp checking. When enabled, each
    operation that would modify a buffer checks see that the file is
    not newer than the buffer content.  Useful if multiple tasks
    have access to the same files. Slow on floppy drives.
    Default: no.

toggle-just-write-newline (No default binding)
    Globally toggle whether files should be written to disk with a CR
    before each newline character. Can be overridden per buffer with
    set-write-cr. Default: Write CR under DOS/Windows, do not under
    Unix/X11.

toggle-keypad (No default binding)
    Toggle whether keypad characters should be bindable via
    global-set-key (names are Kp-0 .. Kp-9, Kp-/, Kp-*, Kp--, and
    Kp--), or whether they should insert their respective characters
    into the text.  When NumLock is off, Kp-0 .. Kp-9 will always be
    bindable.  Default: Bindable.

toggle-make-backups (No default binding)
    Toggle whether NotGNU should back up old files when saving.
    Default: yes.

toggle-modified-state (M-~)
    Toggle whether a buffer should be marked as modified (Symbolized
    with "*") or not.  May clear undo stack.

toggle-mouse-paste-where (No default binding)
    Toggle whether the right mouse button pastes at cursor or at
    mouse pointer.  Default: pointer

toggle-read-only (C-x C-q)
    Toggle whether the buffer should be marked read-only (no editing
    allowed).  Default: no.

toggle-show-linenumber (No default binding)
    Toggle whether line and column number should be displayed in
    modeline.





________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                             Page 19
------------------------------------------------------------------------

toggle-show-touched-lines (No default binding)
    Toggle whether modified lines should be displayed in a different
    color.  For supported versions, CURSES/Unix dependent on the
    curses library used. Default: yes.  See also: set-fg2-color.

toggle-window-menu (No default binding)
    Toggle whether a Windows menu bar should be displayed under
    Windows 3.x/NT.

transpose-chars (C-t)
    Swap position of character to the left of cursor and character
    under cursor; if not at end of line, move one character forward.

undo (No default binding)
    Multilevel undo.  Change the text and editor state back to
    what it was before last operation. Multiple undo's can be
    executed in a row to go back several levels.
    See also: undo-high-threshold, empty-undo-stacks.

undo-high-threshold (No default binding)
    Syntax: (undo-high-threshold 'value)
    Specify the maximum number of undo's available. The higher the
    number, the higher memory usage. The default for DOS is 500, for
    other versions virtually unlimited.

universal-argument (C-u)
    Specify an argument for the next command; usually the number of
    times to execute that command.  For instance, "C-u 79 -" will insert
    79 hyphens in the text. Limited to sizeof(int).

unix-exec (No default binding)
    Spawn a unix process without waiting for it to finish.

untabify (No default binding)
    Convert TABs to spaces between cursor and mark.

upcase-region (C-x C-u)
    Converts all characters between cursor and mark into uppercase.

upcase-word (M-u)
    Convert the following word, or the rest of the current word,
    into uppercase.


________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin

NotGNU function list                                             Page 20
------------------------------------------------------------------------

view-file (No default binding)
    Load a file as with find-file; mark buffer read-only.
    See also: find-file, toggle-read-only

what-cursor-position (C-x =)
    In the minibuffer, display information on the current character
    and offset from beginning of buffer in bytes, percent, lines,
    and columns.

what-line (No default binding)
    In minibuffer, display current line and column number.


win-exec (No default binding)
    Spawn a Windows program without waiting for completion.

write-file (C-x C-w)
    Save the contents of current buffer to a file; prompt for
    filename.

yank (C-y)
    Insert text from kill buffer at cursor position.

yank-from-clipboard (C-x g)
    Paste text from the Windows clipboard or X11 cutbuffer 0 at
    cursor position.

yank-rectangle (No default binding)
    Inserts text from the rectangle kill buffer into rectangle at
    cursor.














________________________________________________________________________
NotGNU 1.5                               Copyright (C) 1993 Julie Melbin
