/**********************************************************************
 XRAYfield reads a string off of the DOS window
    targ is the memory area where the string will be copied,
      it must be at least one byte larger then l.
    w is the XRAYWIN.COM DOS window number.
    r is the screen row starting at 0 (first row is 0, last row is 25).
    c is the column starting at 0 (0 to 79).
    l is the length of the field. Field lengths can wrap. For instance,
      to get the whole screen start from r=0,c=0 and make l = 2000
      (i.e. 25*80).
    XRAYfield returns non-zero on system failure. It will return a
      sring of the letter 'G' if XRAYWIN is not installed correctly.
**********************************************************************/
int far pascal XRAYfield(char far *targ,int w,int r,int c,int l);

/**********************************************************************
  XRAYGetCursor returns the cursor location.
    NOTE: This is ONLY available in the registered versions of XRAY
    w is the XRAYWIN.COM DOS window number.
    XRAYGetCursor returns the cursor location as an unsigned int.
    column is the high order byte, row the low order.
    column = location >> 8;
    row = location & 255;
**********************************************************************/
unsigned far pascal XRAYGetCursor(int w);

/**********************************************************************
  XRAYGetCursor returns the cursor location.
    NOTE: This is ONLY available in the registered versions of XRAY
    key is the keystroke to stuff. key has the scan code in the high
      byte and the ascii value in the low byte. Most programs will
      accept just the ascii value without a problem. Function keys,
      alt keys and cursor controls usually have a 0 in the low order
      byte and the scan code in the high order byte. The keys require
      using the defines below. Use DKEY.COM (available on my BBS)
      to find the shift and ascii values for other keys.
    w is the XRAYWIN.COM DOS window number.
    returns non zero if failure.
**********************************************************************/
int far pascal XRAYStuffKeyboard(unsigned key,int w);

/**********************************************************************
   Keystrokes for XRAYStuffKeyboard
**********************************************************************/
#define XF1      0x3b00
#define XF2      0x3c00
#define XF3      0x3d00
#define XF4      0x3e00
#define XF5      0x3f00
#define XF6      0x4000
#define XF7      0x4100
#define XF8      0x4200
#define XF9      0x4300
#define XF10     0x4400
#define XHOME    0x4700
#define XUP      0x4800
#define XPGUP    0x4900
#define XLEFT    0x4B00
#define XRIGHT   0x4D00
#define XEND     0x4F00
#define XDOWN    0x5000
#define XPGDN    0x5100
#define XINS     0x5200
#define XDEL     0x5300
#define XESC     0x011b
#define XRETURN  0x1c0d
#define XENTER   0x1c0d
