#ifndef ALERTOBJ_H
#define ALERTOBJ_H



/*------------------------------------------------------------------------------
   Copyright           : (c)1993 by Logical Operators
                         All Rights Reserved.
   Filename            : AlertObj.H
   Header File         : AlertObj.H
   Purpose             : Header file for the AlertableObject classes. An
                         AlertableObject object can use an AlertDriver object
                         to alert the user of errors or program conditions.
                         Because the AlertDriver object handles the details of
                         presenting the output to the user, descendants of
                         AlertableObject can be constructed to produce these
                         "user alerts" in a device-independent manner which can
                         then be determined or altered at run-time.
   Compiler Directives : None

   Modification History:
   Version   Date    Programmer and Description of Changes
   ------- --------  --------------------------------------------------------
    1.00   01/15/94  Original version by Warren J. Hairston.
   ---------------------------------------------------------------------------*/



   //included files
   //--------------
   #ifndef ALERTDRV_H
      #include <ALERTDRV.H>   //AlertDriver and related class declarations
   #endif   //ALERTDRV_H



   /*constants - used to denote common error, info, message, and warning
                 conditions for all classes*/
   //-------------------------------------------------------------------
   const long errOK = 0x00;    //no error
   const long infoOK = 0x00;   //no information
   const long msgOK = 0x00;    //no message
   const long warnOK = 0x00;   //no warning



   //class declarations
   //------------------
   class AlertableObject : public AlertDriverLink
   {
      public:
         //constructor(s)
         //--------------
         AlertableObject(void);

         //member functions
         //----------------
                 void           ChangeAlertProcFlags(
                                   const unsigned short newFlags,
                                   const unsigned short options =
                                      cfoCHAIN | cfoOVERWRITE);
                 void           ClearMessage(void) const {ReportMessage("");}
                 unsigned short GetAlertProcFlags(void) const
                                   {return ((linkedAlertDriver)
                                       ? linkedAlertDriver->GetProcFlags()
                                       : 0);}
         virtual void           GetErrorText(const long errorCode, char *text);
         virtual void           GetInfoText(const long infoCode, char *text);
         virtual void           GetMessageText(const long msgCode, char *text);
         virtual void           GetWarningText(const long warnCode, char *text);
                 void           HandleError(const long errorCode);
                 void           HandleInfo(const long infoCode);
                 void           HandleMessage(const long msgCode);
                 unsigned short HandleWarning(const long warnCode,
                                              const unsigned short
                                                 defaultChoice);
                 void           ReportError(const char *text) const;
                 void           ReportInfo(const char *text) const;
                 void           ReportMessage(const char *text) const;
                 unsigned short ReportWarning(const char *text,
                                              unsigned short defaultChoice)
                                   const;

         //platform-specific member functions
         //----------------------------------
         #ifdef BORLAND_CONTAIN
            virtual hashValueType hashValue() const {return 0;}
            virtual classType     isA() const {return 0;}
            virtual int           isEqual (const Object& testObject) const
                                     {return 0;}
            virtual char*         nameOf() const {return "AlertableObject";}
            virtual void          printOn(ostream& outputStream) const {}
         #endif   //BORLAND_CONTAIN
   };   //class AlertableObject



#endif //ALERTOBJ_H
