#ifndef INTEGER_H
#define INTEGER_H



/*------------------------------------------------------------------------------
   Copyright           : (c)1993 by Logical Operators
                         All Rights Reserved.
   Filename            : Integer.H
   Header File         : Integer.H
   Purpose             : Header file for the sample Integer class.
   Compiler Directives : None

   Modification History:
   Version   Date    Programmer and Description of Changes
   ------- --------  --------------------------------------------------------
    1.00   01/20/94  Original version by Warren J. Hairston.
   ---------------------------------------------------------------------------*/



   //included files
   //--------------
   #ifndef ALERTOBJ_H
      #include <ALERTOBJ.H>   //AlertableObject class declaration
   #endif   //ALERTOBJ_H



   /*constants - used to denote error, info, message, and warning
                 conditions for the Integer classes*/
   //-------------------------------------------------------------------
   const long errIntDivByZero = 1;
   const long errIntOverflow  = 2;
   const long infoIntConstruct = 1;
   const long msgIntDestruct = 1;
   const long warnIntChange = 1;



   //class declarations
   //------------------
   class Integer : public AlertableObject
   {
      public:
         //constructor(s)
         //--------------
         Integer(int aValue=0);

         //destructor
         //----------
         virtual ~Integer();

         //overridden operators
         //--------------------
         Integer& operator = (long aValue);
         Integer& operator = (Integer &anInt) {return *this = anInt.val;}
             long operator * (int aValue) {return ((long)val) * aValue;}
             long operator * (Integer &anInt) {return *this * anInt.val;}
              int operator / (int aValue);
              int operator / (Integer &anInt) {return *this / anInt.val;}

         //member functions
         //----------------
                  int Value(void) {return val;}
         virtual void GetErrorText(const long errorCode, char *text);
         virtual void GetInfoText(const long infoCode, char *text);
         virtual void GetMessageText(const long msgCode, char *text);
         virtual void GetWarningText(const long warnCode, char *text);
         virtual void TestAlertDriver(void);

      protected:
         //data members
         //------------
         int val;   //holds the value of this object
   };  //class Integer



#endif //INTEGER_H
