/*------------------------------------------------------------------------------
   Copyright           : (c)1993 by Logical Operators
                         All Rights Reserved.
   Filename            : Integer.CPP
   Header File         : Integer.H
   Purpose             : Sample AlertableObject which implements an Integer
                         class.
   Compiler Directives : None

   Modification History:
   Version   Date    Programmer and Description of Changes
   ------- --------  --------------------------------------------------------
    1.00   01/20/94  Original version by Warren J. Hairston.
   ---------------------------------------------------------------------------*/



   //included files
   //--------------
   #ifndef INTEGER_H
      #include <INTEGER.H>   //AlertableObject class declaration
   #endif   //!INTEGER_H

   #include <limits.h>     //for INT_MIN, INT_MAX declarations



/*============================================================================*/



   //Integer constructor(s)
   //----------------------



   Integer::Integer(int aValue) :
      AlertableObject()
   /*---------------------------------------------------------------------------
      Purpose:  Initializes the object.
      Parameters:  aValue = value to which the object will be initialized.
      Return Value:  None.
      ------------------------------------------------------------------------*/
   {
      val = aValue;
      HandleInfo(infoIntConstruct);
   };   //constructor for Integer



/*============================================================================*/



   //Integer destructor
   //------------------



   Integer::~Integer()
   /*---------------------------------------------------------------------------
      Purpose:  Destructs the object.
      Parameters:  None.
      Return Value:  None.
      ------------------------------------------------------------------------*/
   {
      HandleMessage(msgIntDestruct);
      ClearMessage();
   };   //destructor for Integer



/*============================================================================*/



   //Integer member function(s)
   //--------------------------



   Integer& Integer::operator = (long aValue)
   /*---------------------------------------------------------------------------
      Purpose:  Sets the variable to the specified value.
      Parameters:  aValue = value to which the object will be set.
      Return Value:  Reference to this object.
      ------------------------------------------------------------------------*/
   {
      unsigned short warningResult;



      warningResult = HandleWarning(warnIntChange, adsYES);
      if ((warningResult == adsYES) || (warningResult == adsNODRIVER))
      {
         if ((aValue >= INT_MIN) && (aValue <= INT_MAX))
         {
            val = aValue;
         }   //aValue is legal for an int
         else
         {
            HandleError(errIntOverflow);
            val = INT_MAX;
         };   //report an error here
      };   //user wants to change the value
      return *this;
   };   //overridden operator Integer::operator =



   int Integer::operator / (int aValue)
   /*---------------------------------------------------------------------------
      Purpose:  Divides the variable by the specified value.
      Parameters:  aValue = value by which the object will be divided.
      Return Value:  The value derived by dividing data member val by aValue.
      ------------------------------------------------------------------------*/
   {
      int result;   //holds the function result



      if (aValue)
      {
         result = val / aValue;
      }   //specified value is not 0
      else
      {
         HandleError(errIntDivByZero);
         result = INT_MAX;
      };   //specified value is 0
      return result;
   };   //overloaded operator Integer::operator /



   void Integer::GetErrorText(const long errorCode, char *text)
   /*---------------------------------------------------------------------------
      Purpose:  Converts the specified error code into a text string describing
                the error.
      Parameters:  errorCode = An errXXXX or user-defined code which denotes
                               the error to be handled.
                   text = Upon return from this function, text holds a string
                          describing the error referenced by errorCode.
      Return Value:  None.
      ------------------------------------------------------------------------*/
   {
      switch (errorCode)
      {
         case errIntDivByZero : strcpy(text,
                                       "Divide by zero in Integer object.");
                                break;
         case errIntOverflow  : strcpy(text,
                                       "Value too large for Integer object.");
                                break;
         default              : AlertableObject::GetErrorText(errorCode, text);
                                break;
      };   //switch statement to determine error text
   };   //member function Integer::GetErrorText



   void Integer::GetInfoText(const long infoCode, char *text)
   /*---------------------------------------------------------------------------
      Purpose:  Converts the specified info code into a text string describing
                the information.
      Parameters:  infoCode = An infoXXXX or user-defined code which denotes
                              the information to be handled.
                   text = Upon return from this function, text holds a string
                          describing the info referenced by infoCode.
      Return Value:  None.
      ------------------------------------------------------------------------*/
   {
      switch (infoCode)
      {
         case infoIntConstruct : strcpy(text, "Integer object constructed.");
                                 break;
         default               : AlertableObject::GetInfoText(infoCode, text);
                                 break;
      };   //switch statement to determine info text
   };   //member function Integer::GetInfoText



   void Integer::GetMessageText(const long msgCode, char *text)
   /*---------------------------------------------------------------------------
      Purpose:  Converts the specified message code into a text string
                describing the message.
      Parameters:  msgCode = An msgXXXX or user-defined code which denotes
                               the message to be handled.
                   text = Upon return from this function, text holds a string
                          describing the message referenced by msgCode.
      Return Value:  None.
      ------------------------------------------------------------------------*/
   {
      switch (msgCode)
      {
         case msgIntDestruct : strcpy(text, "Integer object destructed.");
                               break;
         default             : AlertableObject::GetMessageText(msgCode, text);
                               break;
      };   //switch statement to determine message text
   };   //member function Integer::GetMessageText



   void Integer::GetWarningText(const long warnCode, char *text)
   /*---------------------------------------------------------------------------
      Purpose:  Converts the specified warning code into a text string
                describing the warning.
      Parameters:  warnCode = A warnXXXX or user-defined code which denotes
                               the warning to be handled.
                   text = Upon return from this function, text holds a string
                          describing the warning referenced by warnCode. The
                          space allocated for holding this string must be
                          allocated outside this function.
      Return Value:  None.
      ------------------------------------------------------------------------*/
   {
      switch (warnCode)
      {
         case warnIntChange : strcpy(text,
           "Are you sure you want to change the value of this Integer object?");
                              break;
         default            : AlertableObject::GetWarningText(warnCode, text);
                              break;
      };   //switch statement to determine warning text
   };   //member function Integer::GetWarningText



   void Integer::TestAlertDriver(void)
   /*---------------------------------------------------------------------------
      Purpose:  Tests the AlertDriver for this object by reporting undefined
                codes and literal strings.
      Parameters:  None.
      Return Value:  None.
      ------------------------------------------------------------------------*/
   {
      //test undefined codes for the object
      HandleMessage(13);   /*this message stays on the screen until the next one
                             or until a call to ClearMessage()*/
      HandleError(14);
      HandleWarning(16,adsYES);

      //test literal strings
      ReportMessage("Literal:  This is a message string.");
      ReportError("Literal:  This is an error string.");
      ReportWarning("Literal:  Acknowledge this warning string?", adsNO);

      ClearMessage();
   };   //member function Integer::TestAlertDriver



