//***********************************************************************
//
//  File:   dial.h
//
//  Include file for the dial program
//
//***********************************************************************


#include <windows.h>
#include <string.h>
#include <mmsystem.h>
#include "resource.h"

#define DIALSTRLEN 35
#define WM_MYMSG WM_USER+100

LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK DlgSettingsProc( HWND, UINT, WPARAM, LPARAM );
BOOL CALLBACK DlgDialProc( HWND, UINT, WPARAM, LPARAM );
BOOL CALLBACK DlgHangupProc(HWND, UINT, WPARAM, LPARAM );

BOOL PASCAL DialProc(void);
BOOL PASCAL HangUp(void);
BOOL PASCAL WaitString(LPSTR, DWORD);
BOOL PASCAL OpenCommPort(void);

// global variables

HANDLE ghInstance;
int    idComDev;            //  comm port id

//  This structure is used to hold info about
//  dialing.  Here it has been defined statically, however,
//  in a real implementation, it may be desirable to 
//  have the fields be pointers to variables that can
//  be allocated as needed.

typedef struct tagDIALINFO
{

    char	szInit[DIALSTRLEN];
    char	szPrefix[DIALSTRLEN];
    char 	szSuffix[DIALSTRLEN];
    char	szEscape[DIALSTRLEN];
    char	szHangup[DIALSTRLEN];
    char 	szPhoneNo[DIALSTRLEN];
    UINT	uBaudRate;
    char	szComPort[5];
    
} DIALINFO;

//  declare the DialInfo variable globally and
//  initialize it...  

DIALINFO gDialInfo =
			{ "ATZ",
			  "ATDT",
			  "",
			  "+++",
			  "ATH0",
			  "",
			  9600,
			  "COM1"
			};  

