/* stdlib.h (emx+gcc) */

#if !defined (_STDLIB_H)
#define _STDLIB_H

#if defined (__cplusplus)
extern "C" {
#endif

#if !defined (_SIZE_T)
#define _SIZE_T
typedef unsigned long size_t;
#endif

#if !defined (NULL)
#define NULL ((void *)0)
#endif

#if !defined (_DIV_T)
#define _DIV_T
typedef struct _div_t
{
  int quot;
  int rem;
} div_t;
typedef struct _ldiv_t
{
  long quot;
  long rem;
} ldiv_t;
typedef struct
{
  unsigned long quot;
  unsigned long rem;
} _uldiv_t;
typedef struct
{
  long long quot;
  long long rem;
} _lldiv_t;
typedef struct
{
  unsigned long long quot;
  unsigned long long rem;
} _ulldiv_t;
#endif

#if !defined (RAND_MAX)
#define RAND_MAX 0x7fff
#endif

#if !defined (EXIT_SUCCESS)
#define EXIT_SUCCESS 0
#define EXIT_FAILURE 1
#endif

#if !defined (OS2_MODE)
#define DOS_MODE 0
#define OS2_MODE 1
#endif

#if !defined (_MAX_PATH)
#define _MAX_PATH   260
#define _MAX_DRIVE    3
#define _MAX_DIR    256
#define _MAX_FNAME  256
#define _MAX_EXT    256
#endif

#if !defined (_ERRNO)
#define _ERRNO
#if defined (__MT__)
extern int *_errno_fun (void);
#define errno (*_errno_fun ())
#else
extern int errno;
#endif
#endif

extern char **environ;

extern __const__ char * __const__ sys_errlist[];
extern __const__ int sys_nerr;

extern __const__ unsigned int _emx_vcmp;
extern __const__ unsigned int _emx_env;
extern __const__ unsigned int _emx_rev;
extern __const__ unsigned char _osminor;
extern __const__ unsigned char _osmajor;
extern __const__ unsigned char _osmode;
extern __const__ char _emx_vprt[5];

void abort (void) __attribute__ ((noreturn));
unsigned alarm (unsigned sec);
int atexit (void (*func)(void));
int atoi (__const__ char *string);
long atol (__const__ char *string);
long long _atoll (__const__ char *string);
double atof (__const__ char *string);
long double _atofl (__const__ char *string);
void *brk (void *addr);
void *bsearch (__const__ void *key, __const__ void *base,
    size_t num, size_t width,
    int (*compare)(__const__ void *key, __const__ void *element));
int chdir (__const__ char *name);
div_t div (int num, int den);
void exit (int ret) __attribute__ ((noreturn));
char *gcvt (double value, int digits, char *buffer);
char *getcwd (char *buffer, size_t size);
char *getenv (__const__ char *name);
int getpagesize (void);
char *getwd (char *buffer);
char *initstate (unsigned seed, char *state, int n);    /* BSD */
char *_itoa (int value, char *string, int radix);
ldiv_t ldiv (long num, long den);
char *_ltoa (long value, char *string, int radix);
int mkdir (__const__ char *name, long mode);
void perror (__const__ char *string);
int putenv (__const__ char *string);
void qsort (void *base, size_t num, size_t width,
    int (*compare)(__const__ void *x1, __const__ void *x2));
int rand (void);
long random (void);                                     /* BSD */
int rmdir (__const__ char *name);
void *sbrk (int incr);
char *setstate (char *state);                           /* BSD */
unsigned sleep (unsigned sec);
void srand (unsigned int seed);
void srandom (unsigned seed);                           /* BSD */
long strtol (__const__ char *string, char **end_ptr, int radix);
unsigned long strtoul (__const__ char *string, char **end_ptr, int radix);
double strtod (__const__ char *string, char **end_ptr);
long double _strtold (__const__ char *string, char **end_ptr);
void swab (__const__ void *src, void *dst, size_t n);
int system (__const__ char *command);
long ulimit (int cmd, long newlimit);
char *_ultoa (unsigned long value, char *string, int radix);

int _abspath (char *dst, __const__ char *src, int size);
int _chdir2 (__const__ char *name);
int _chdrive (char drive);
int _core (int handle);
void _defext (char *dst, __const__ char *ext);
void _envargs (int *argcp, char ***argvp, const char *name);
int _execname (char *buf, size_t bufsize);
void _exit (int ret) __attribute__ ((noreturn));
int _filesys (__const__ char *drive, char *name, size_t size);
int _fncmp (__const__ unsigned char *string1,
    __const__ unsigned char *string2);
char **_fnexplode (__const__ char *mask);
void _fnexplodefree (char **list);
char _fngetdrive (__const__ char *src);
int _fnisabs (__const__ char *name);
int _fnisrel (__const__ char *name);
void _fnlwr (char *name);
void _fnlwr2 (char *name, const char *base);
int _fullpath (char *dst, __const__ char *src, int size);
int _getcwd1 (char *buffer, char drive);
char *_getcwd2 (char *buffer, int size);
char _getdrive (void);
char *_getext (__const__ char *path);
char *_getext2 (__const__ char *path);
char *_getname (__const__ char *path);
_lldiv_t _lldiv (long long num, long long den);
char *_lltoa (long long value, char *string, int radix);
void _makepath (char *dst, __const__ char *drive, __const__ char *dir,
    __const__ char *fname, __const__ char *ext);
int _path (char *dst, __const__ char *name);
int _read_kbd (int echo, int wait, int sig);
void _remext (char *path);
void _rfnlwr (void);
void _response (int *argcp, char ***argvp);
void _scrsize (int *dst);
void _searchenv (__const__ char *file, __const__ char *var, char *path);
void _sfnlwr (__const__ char *name);
unsigned _sleep2 (unsigned millisec);
char ** _splitargs (char *string, int *count);
void _splitpath (__const__ char *src, char *drive, char *dir, char *fname,
    char *ext);
char _swchar (void);
int _syserrno (void);
_uldiv_t _uldiv (unsigned long num, unsigned long den);
_ulldiv_t _ulldiv (unsigned long long num, unsigned long long den);
char *_ulltoa (unsigned long long value, char *string, int radix);
void _wildcard (int *argcp, char ***argvp);

#if !defined (_ABS)                                      /* see also math.h */
#define _ABS
#if !defined (__GNUC__) || __GNUC__ >= 2
extern int abs (int n);
extern long labs (long n);
#else
static __inline__ int abs (int n) { return (n < 0 ? -n : n); }
static __inline__ long labs (long n) { return (n < 0 ? -n : n); }
#endif
#endif

#if defined (__MT__)
int _beginthread (void (*start)(void *arg), void *stack, unsigned stack_size,
    void *arg_list);
void _endthread (void);
void **_threadstore (void);
#endif

#if defined (__cplusplus)
}
#endif

#include <malloc.h>

#endif /* !defined (_STDLIB_H) */
