/* fnlwr.c (emx+gcc) -- Copyright (c) 1992-1994 by Eberhard Mattes */

#include <sys/emx.h>
#include <sys/nls.h>
#include <stdlib.h>
#include <ctype.h>

static char cache_curdrive = 0;
static char cache_filesys[26] =
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

void _fnlwr2 (char *name, const char *base)
{
  char c, dr[3], fs[16];
  int i;

  c = _fngetdrive (base);
  if (c == 0)
    {
      if (cache_curdrive == 0)
        cache_curdrive = _getdrive ();
      c = cache_curdrive;
    }
  else if (name == base)
    name[0] = (char)(c - 'A' + 'a');
  i = c - 'A';
  if (cache_filesys[i] == 0)
    {
      dr[0] = c;
      dr[1] = ':';
      dr[2] = 0;
      if (_filesys (dr, fs, sizeof (fs)) != 0)
        return;
      if (strcmp (fs, "HPFS") == 0 || strcmp (fs, "NFS") == 0)
        cache_filesys[i] = 'p';     /* case-preserving */
      else
        cache_filesys[i] = 'u';     /* upper-casing */
    }
  if (cache_filesys[i] == 'u')
    {
      if (!_nls_init_flag) _nls_init();
      _nls_strlwr (name);
    }
}


void _fnlwr (char *name)
{
  _fnlwr2 (name, name);
}


void _rfnlwr (void)
{
  int i;

  for (i = 0; i < 26; ++i)
    cache_filesys[i] = 0;
  cache_curdrive = 0;
}


void _sfnlwr (const char *name)
{
  cache_curdrive = _fngetdrive (name);
  if (cache_curdrive == 0)
    cache_curdrive = _getdrive ();
}
