// puzzlvw.h : interface of the CPuzzleView class
//
/////////////////////////////////////////////////////////////////////////////
#ifndef __PUZZLVW_H
#define __PUZZLVW_H
#include "piece.h"

class CPuzzleView : public CView
{
protected: // create from serialization only
    CPuzzleView();
    DECLARE_DYNCREATE(CPuzzleView)

// Attributes
public:
    CPuzzleDoc* GetDocument();

// Operations
public:

// Implementation
public:
    virtual ~CPuzzleView();
    virtual void OnDraw(CDC* pDC);  // overridden to draw this view
    //virtual BOOL PreCreateWindow(CREATESTRUCT&);
    
#ifdef _DEBUG
    virtual void AssertValid() const;
    virtual void Dump(CDumpContext& dc) const;
#endif

private:
  CObArray m_board;
  int      m_width;
  int      m_height;
  CPoint   m_mousePos;
  BOOL     m_bCaptured;
  
  CPiece*  m_selectedPiece;

  BOOL     CanMove(CPiece*);
  BOOL     OnBoard(CPoint&,CPiece*);
  BOOL     Conflict(CPoint&,CPiece*);
  void     ResetPieces(void);
  void     SizeToPuzzle(void);

// Generated message map functions
protected:
    //{{AFX_MSG(CPuzzleView)
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
    afx_msg void OnMouseMove(UINT nFlags, CPoint point);
    afx_msg void OnReset();
    afx_msg void OnUpdateReset(CCmdUI* pCmdUI);
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in puzzlvw.cpp
inline CPuzzleDoc* CPuzzleView::GetDocument()
   { return (CPuzzleDoc*) m_pDocument; }
#endif

#endif //__PUZZLVW_H

