#ifndef NULLF
#define NULLF (int (*)()) 0
#endif

/*
 *  These variables are assigned from within the panel_execute
 *  function.  They indicate the row, column and field where the
 *  cursor was positioned prior to the user pressing a response
 *  key.
 */
extern int pan_row, pan_col, pan_field_sub;
extern char pan_field_name[];

void      pan_init();

void      pan_activate(char []);
void      pan_destroy();
void      pan_error(int, int, char *);

unsigned  pan_execute(char [], int, int);
unsigned  pan_get_key();

void      pan_sound(int, int);
void      pan_get_field(char *, int, char []);
void      pan_put_field(char *, int, char []);
void      pan_delay(int);
void      pan_field_attr(char *, int, char []);

void      pan_idle_func(int (*)());
void      pan_resp_keys(unsigned *);

/*
 *  Functions and structures to support the creation of list picks.
 */

typedef struct PAN_ITEM {
    char *desc;               /* list option description */
    void *data;               /* pointer to misc data */
    struct PAN_ITEM *next,    /* next and previous list elements */
                    *prev;
    } PAN_OPT;

typedef struct {
    int  bg;                  /* background color code (0..7) */
    char nrm_attr[8];         /* normal panel attribute */
    char sel_attr[8];         /* selected panel attribute */
    int  border;              /* 0 = none, 1 = single, 2 = double */
    int  ul_row, ul_col;      /* upper left screen coordinates */
    int  lines;               /* number of lines visible for list */
    int  len;                 /* maximum length of each option line */
    PAN_OPT *head, *tail, *selected, *vfirst;
    } PAN_LIST;


PAN_LIST *pan_linit();
void      pan_ladd(PAN_LIST *, char *, void *);
void      pan_lfree(PAN_LIST *, int, int);
void      pan_lact(PAN_LIST *);
unsigned  pan_lexec(PAN_LIST *);

