#include <bios.h>
#include <conio.h>

/* pick_color function Copyright 1992 by Tay-Jee Software

This function presents a 16 by 8 character color selection chart
on the center of the screen.  The user positions the cursor over
a desired color combination and presses enter to select that color.
The decimal value of the selected attribute is returned.  Pressing
escape aborts the function with a return value of -1.  Screen
maintenance is left to the user (i.e., color display chart remains
on screen after function exit).                                   */



int pick_color()

{
	/* Define local variables */
	int row, column, input=0;
	
	/* Draw color chart on the screen */
	for (row=8;row<16;row++) {
		for (column=32;column<48;column++) {
			poscurs(row,column);
			writechs(7,(row-8)*16+(47-column),1);
		}
	}
	
	/* Initialize flashing cursor position */
	row=8;
	column=32;
	poscurs(row,column);
	writechs(15,row*16+47-column,1);
	
	/* Main input loop */
	while (input != 13 && input != 27) {

		input=getch();
		
		/* Check for extended keypress */
		if (input==0)
			input=300+getch();
	
		/* Restore normal cursor */
		poscurs(row,column);
		writechs(7,(row-8)*16+47-column,1);
	
		/* Increment/decrement row or cursor position */
		switch (input) {
			
			case 372: {  /* Cursor up */
				row--;
			}
			break;
			case 375: {  /* Cursor left */
				column--;
			}
			break;
			case 377: {  /* Cursor right */
				column++;
			}
			break;
			case 380: {  /* Cursor down */
				row++;
			}
			break;
			
		}
		
		/* Check for "wraparound" */
		if (row>15)
			row=8;
		else if (row<8)
			row=15;
		if (column>47)
			column=32;
		else if (column<32)
			column=47;
		
		/* Draw new flashing cursor */
		poscurs(row,column);
		writechs(15,row*16+47-column,1);
	}
	
	if (input==27)
		return -1;
	else
		return (row-8)*16+47-column;
	
}
