/* colortext2 library function copyright 1991 by Chuck Steenburgh */
/*  This function is identical to colortext except that the
    first character in the string text[] is printed with the
    attribute specified by hilite.  (This is useful in menus
    and other uses when you want to make the first letter of
    a word stand out.)  See file COLORTXM.C

#include <bios.h>
#include <string.h>
												   */
int colortext2(char *text, int r1, int c1, int color, int hilite, int hpos, max_rows)
{
	/* Local variable */
	int counter;
	
	/* Check for valid arguments */
	if (r1<0 || r1>max_rows || c1<0 || c1>79 || color<0 || color>255 || hilite<0 || hilite>255 || hpos<1 || hpos>strlen(text))
		return 1;
	
	poscurs(r1,c1);
	for (counter=0;counter<strlen(text);counter++) {
		poscurs(r1,c1+counter);
		
		/* Check for highlight character */
		if (counter == hpos-1)
			writechs(text[counter],hilite,1);
		else
			writechs(text[counter],color,1);
	}
	
	return 0;
}
