#include <ctype.h>
#include <string.h>

/* repchar function Copyright 1992 by Chuck Steenburgh

   This function will replace all instances of a given character
   in a string with another
   
   repchar accepts the following arguments:
   
   char *s - string in which character(s) are to be replaced
   char c  - character to be replaced
   char r  - replacement character
   
   Returns:  number of characters replaced
                                                                         */
                                                                       

int repchar(char *s, char c, char r)
	
{
	/* local variable */
	int counter=0;
	
	while (s = strchr(s,c)) {
		*s = r;
		counter++;
	}
	
	return counter;
}



/* remchar function Copyright 1993 by Chuck Steenburgh 

   This function will remove all instances of a given character
   in a string and NOT replace it
   
   repchar accepts the following arguments:
   
   char *s - string from which character(s) are to be removed
   char c  - character which is to be deleted
   
   Returns: number of characters removed                                 */


int remchar(char *s, char c)
	
{
	/* local variable */
	int counter=0, count, count2;
	
	for (count=0;count<strlen(s);count++) {
		
		if (s[count]==c) {
			
			for (count2=count;count2<strlen(s);count2++) 
				s[count2]=s[count2+1];
			
			counter++;
		}
	}
	
	return counter;
}


void remove_chars(char *in_line)

{
	/* Local variables */
	int counter2, counter3=0;
	char *out_line;

	for (counter2=0;counter2<strlen(in_line);counter2++) {
		if (isdigit(in_line[counter2])) {
			out_line[counter3++]=in_line[counter2];
		}
	}
	out_line[counter3++]='\n';
	strcpy(in_line,out_line);
}

	
	
void remove_digits(char *in_line)

{
	/* Local variables */
	int counter2, counter3=0;
	char *out_line;

	for (counter2=0;counter2<strlen(in_line);counter2++) {
		if (isprint(in_line[counter2])) {
			if (isdigit(in_line[counter2]) == 0)
				out_line[counter3++]=in_line[counter2];
		}
	}
	out_line[counter3++]='\n';
	strcpy(in_line,out_line);
}



void epsonize(char *s, int c)

{
	/* Local variables */
	int counter4;
	
	/* Check each character and replace as necessary */
	for (counter4=0;counter4<strlen(s);counter4++) {
		
		if (s[counter4] > 127) {
					
			switch(s[counter4]) {
						
				case 179: case 186:
					s[counter4] = 124;
				break;
				case 180: case 181: case 182: case 185: case 193: 
				case 194: case 195: case 197: case 198: case 199: 
				case 202: case 203: case 204: case 206: case 207: 
				case 208: case 209: case 210: case 215: case 216:
					s[counter4] = 43;
				break;
				case 183: case 184: case 187: case 188: case 189: 
				case 190: case 191: case 192: case 200: case 201: 
				case 211: case 212: case 213: case 214: case 217: 
				case 218:
					s[counter4] = 42;
				break;
				case 196: case 205:
					s[counter4] = 45;
				break;
				case 219: case 220: case 221: case 222: case 223:
					s[counter4] = 88;
				break;
				default:
					s[counter4]=c;
				break;
			}
		}
	}
}
	