
/* colortext library function copyright 1991 by Chuck Steenburgh */

/*  This function writes a string to the screen with color attributes. 
    The following arguments MUST be passed to the function:
    
	   text[]: this char array contains the string to be printed
	   
	   r1: this int variable contains the screen row in which the
		    text is to be printed.  Must lie between 0 and 24.
		    
	   c1: this int contains the screen column in which text printing
		    is to begin.  Must lie between 0 and 79.
		    
	   color: this int represents the background/foreground color which
		    is to be used ONLY for printing text[].  The rest of the 
		    screen is not affected.  The color value is arrived at by
		    the following method:
		    
		    Background colors:
		    
		    Black          0          Blue         16
		    Green         32          Cyan         48
		    Red           64          Magenta      80
		    Brown         96          White       112
		    
		    Foreground colors:

		    Black          0          Blue          1
		    Green          2          Cyan          3
		    Red            4          Magenta       5
		    Brown          6          White         7

    Add together the values listed for your choice of background and
foreground colors to obtain a value for color.  For special attributes,
add the following values:

				 Bold foreground        +8
				 Blinking foreground  +128
				 

     Returns: 0 if no error
              1 if passed invalid argument(s)

	Chuck Steenburgh
	Power C Users Group
	CIS IBM Programming Forum
	72330,1776                                                        */


#include <bios.h>

int colortext(char text[], int r1, int c1, int color, max_rows)
{
	/* Local variable */
	int counter;
	
	/* Check valid arguments */
	if (r1<0 || r1>max_rows || c1<0 || c1>79 || color<0 || color>255)
		return 1;
		
	poscurs(r1,c1);
	for (counter=0;counter<strlen(text);counter++) {
		writechs(text[counter],color,1);
		poscurs(r1,c1+counter+1);
	}
	
	return 0;
}
