/* text_box library function copyright 1991 by Chuck Steenburgh 
   This function fills a box defined by r1,c1,r2,c2 with
   character "fill" and attribute "color".  Works in text mode.
   
   Returns:   0 if box successfully drawn and filled             
              1 if passed invalid parameter                      */

#include <bios.h>

int text_box(int r1,c1,r2,c2,fill,color,max_rows)

{
     int counter;
     
     /* Check for valid row/column positions, fill character, and attribute */
     if (r1<0 || r1>r2 ||  r2>max_rows || c1<0 || c1>c2 || c2>79 || fill<0 || fill>255 || color<0 || color>255)
          return 1;

	/* Place fill on screen */
     for (counter=r1;counter<r2+1;counter++) {
          poscurs(counter,c1);
          writechs(fill,color,c2-c1+1);
     }
}
