// ----------------------------------------------------------------------------
//
//    L I . C
//
// ----------------------------------------------------------------------------
//
//    Purpose:
//       LI - CodeWright for Windows and Windows/NT command.  Version 1.00.
//       Copyright 1993, Thom Little Associates, all rights reserved.
//
//    Public functions:
//       LoadInclude( )    load selected C/C++ or MASM include file
//
//    Private functions:
//       liBufEditFile( )  load file for editing
//       liNextToken( )    find next token in string
//
//    Return codes:
//       TRUE              Normal completion
//       FALSE             All program errors
//       
//    History:
//       At                Thom Little Associates (Boston)
//       Using             msVisual C++ 1.10
//       Under             msDOS 6.20; msWindows 3.10
//                         msWindows/NT 3.10
//       By                Thom Little
//       Original          12/15/93
//       Revision          <unused>
//
// ----------------------------------------------------------------------------

#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "exports.h"
#include "cwstart.h"

BOOL liBufEditFile( LPSTR lpszFilename, LPSTR lpszMessage );
LPSTR liNextToken( LPSTR lpszString, LPSTR lpszToken, LPSTR lpszSep );

LIBMAIN	// establish: DLLEntry( ) if WIN32; LibMain( ) if WIN16 and Borland C.

// ----------------------------------------------------------------------------
//    _init( ) - register DLL routines
// ----------------------------------------------------------------------------

VOID DLL _init( VOID )
	{
	LibExport( "BOOL LoadInclude( VOID )" );
	}

// ----------------------------------------------------------------------------
//    LoadInclude( ) - load selected C/C++ or MASM include file
// ----------------------------------------------------------------------------

BOOL DLL LoadInclude( VOID )
	{
	LPSTR lpszLine ;
	LPSTR lpszFilename ;
	LPSTR lpszVol ;
	LPSTR lpszPath ;
	LPSTR lpszWork ;
	LPSTR lpszEnvp ;
	static LPSTR lpszRemove = " \t<>=;+=-)(*&^%!~`'?,\"" ;
	BOOL bReturn = FALSE ;
	int nWork ;

// get current line
	MarkSavePos( );
	MovHome( );
	lpszLine = BufReadStr( 0x7FFFFFFF );
	MarkRestorePos( );
	lpszWork = lpszLine ;

// verify line is an include statement
	while ( isspace( *lpszWork ) )
		++lpszWork ;
	if ( ! strncmp( lpszWork, "#include", 8 ) )
		lpszWork += 8 ;
	else
		if ( ! strncmp( lpszWork, "INCLUDE", 7 )
			|| ! strncmp( lpszWork, "include", 7 ) )
				lpszWork += 7;
		else
			{
			MsgWarning( "Not C/C++ or MASM include statement." );
			return ( bReturn );
			}

// get filename from include statement
	while ( *lpszWork && strchr( lpszRemove, (int) *lpszWork ) )
		++lpszWork ;
	nWork = 0 ;
	while ( nWork < _MAX_PATH - 1
		&& lpszWork[nWork]
		&& ! strchr( lpszRemove, (int) lpszWork[nWork] ) )
			++nWork ;
	lpszWork[nWork] = '\0' ;

// attempt "absolute reference" load
	if ( FileExists( lpszWork ) )
		{
		bReturn = liBufEditFile( _fstrlwr( lpszWork ), "absolute" );
		StrFree( lpszLine );
		return ( bReturn );
		}               

// attempt "current file" load
	lpszFilename= BufQFilename( );
	StrSplitpath( lpszFilename, &lpszVol, &lpszPath, NIL, NIL );
	lpszFilename = StrNNew( lpszVol, _MAX_PATH );
	strcat( lpszFilename, ":" );
	strcat( lpszFilename, lpszPath );
	strcat( lpszFilename, "\\" );
	strcat( lpszFilename, lpszWork );
	_fstrlwr(  lpszFilename );
	StrFree( lpszVol );
	StrFree( lpszPath );
	if ( FileExists( lpszFilename ) )
		bReturn = liBufEditFile( lpszFilename, "current file" );

// attempt "include path" load
	else
		{
		if ( ! ( lpszEnvp = SysGetEnv( "INCLUDE" ) ) )
			MsgWarning( "INCLUDE environment variable not set." );
		else
			{
			while ( lpszEnvp = liNextToken( lpszEnvp, lpszFilename, ";" ) )
				{
				strcat( lpszFilename, "\\" );
				strcat( lpszFilename, lpszWork );
				_fstrlwr( lpszFilename );
				if ( FileExists( lpszFilename )  )
					bReturn = liBufEditFile( lpszFilename, "include path" );
				}
			if ( ! bReturn )
				MsgPrintf( 1, "%s - not found.", lpszWork );
			}
		}

	StrFree( lpszLine );
	StrFree( lpszFilename );
	return ( bReturn );
	}

// ----------------------------------------------------------------------------
//    liBufEditFile( ) - load file for editing
// ----------------------------------------------------------------------------

PRIVATE BOOL liBufEditFile( LPSTR lpszFilename, LPSTR lpszMessage )
	{
	if ( ! BufEditFile( lpszFilename ) )
		{
		MsgPrintf( 1, "%s - open failed.", lpszFilename );
		return ( FALSE );
		}
	MsgPrintf( 0, "%s - %s reference.", lpszFilename, lpszMessage );
	return ( TRUE );
	}

// ----------------------------------------------------------------------------
//    liNextToken( ) - find next token in string
// ----------------------------------------------------------------------------

PRIVATE LPSTR liNextToken( LPSTR lpszString, LPSTR lpszToken, LPSTR lpszSep )
	{
	LPSTR lpszTokenStart ;
	
	lpszTokenStart = lpszToken ;
	if ( ! lpszString || ! *lpszString || ! lpszToken )
		return ( NULL );
	if ( ! lpszSep )
		lpszSep = "" ;
	while ( strchr( lpszSep, *lpszString ) )
		++lpszString ;
	if ( ! *lpszString )
		return ( NULL );
	while ( *lpszString && ! strchr( lpszSep, *lpszString ) )
		*lpszToken++ = *lpszString++ ;
	*lpszToken = NULL ;
	return ( ( lpszToken == lpszTokenStart ) ? NULL : lpszString );
	}

