/*
 * CSplit.h
 * 08/31/93  Fred Cole     original
 */

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef  __STDC__
#include "portable.h"
#endif

#define VERSION   "2.0"

enum { FALSE = 0, TRUE };
enum { NOERR = 0, SYNTAX, ABORT, MEMORY, FILEIO, PROCESS };

#define FNAMELEN  12    /* 8.3 filespec character count     */
#define LENDEF    90    /* default source lines per section */ /* TS */
#define LENMAX   256    /* maximum source lines per section */
#define LENMIN    25    /* minimum source lines per section */
#define PATHMAX   80    /* maximum path spec length         */
#define TABDEF     4    /* default spaces per tab char      */
#define TABMAX    16    /* maximum spaces per tab char      */
#define TABMIN     2    /* minimum spaces per tab char      */
#define WIDDEF    75    /* default source chars per line    */
#define WIDMAX   255    /* maximum source chars per line    */
#define WIDMIN    55    /* minimum source chars per line    */

#define SEP_CHAR '>'
#define SEP_BF   "Begin file "
#define SEP_BP   "Begin part "
#define SEP_EF   "End file "
#define SEP_EP   "End part "
#define SEP_ID   "CSplit: "
#define SEP_VR   "Version "

typedef struct _slst
{
  char srcfile[FNAMELEN + 1];     /* no path support */
  struct _slst *next;
} SLST;

SLST *add_list  (char *);
void  cleanup   (void);
char *csp_fgets (char *, int, FILE *, int);
void  disp_help (void);
int   extr_file (char *, char);
void  free_list (void);
int   init_list (int, char **, int);
int   split_src (SLST *, char *, int, int, int, char);
unsigned short updcrc (unsigned short, unsigned char *, unsigned int);
void  initcrctab (void);
