/*
   Copyright (C) 1988-1994 The GAP Development Company

   All Rights Reserved
   
   This source code is considered to be confidential information proprietary
   to The GAP Development Company.  It is prohibited and punishable by law
   to use or duplicate any part of this information.
 

   GAPSTRUC.H

   Header file for GAPCDR modules
*/

#if !defined(__GAPSTRUC_H__)
   #define __GAPSTRUC_H__

#ifdef __cplusplus
extern "C" {
#endif 

#if (_MSC_VER)
   #pragma pack(1)                        // All structs must be packed
#else
   #pragma option -a1
#endif


   /******************************************************************/
   /*  Record Structure For GAP'S USERS.DAT.                         */
   /*                                                                */
   /*  There are 4 indexes: IDX 1 = lname + fname (unique)           */
   /*                       IDX 2 = lname + level (dupes allowed)    */
   /*                       IDX 3 = handle (unique)                  */
   /*                       IDX 4 = usernum (sequence #, unique)     */
   /*                                                                */
   /*  The Flags are defined as follows:                             */
   /*    bit 7 - 0x80 : User wants to include Main Board in QWK      */
   /*    bit 6 - 0x40 : User has QWK Network Status                  */
   /*    bit 5 - 0x20 : Undefined                                    */
   /*    bit 4 - 0x10 : Undefined                                    */
   /*    bit 3 - 0x08 : Undefined                                    */
   /*    bit 2 - 0x04 : Undefined                                    */
   /*    bit 1 - 0x02 : Undefined                                    */
   /*    bit 0 - 0x01 : Undefined                                    */
   /******************************************************************/

   struct GAP_USER
      {
      char fname     [16];                // first name
      char lname     [16];                // last name
      char handle    [16];                // handle for MPART!
      char passwd    [13];                // password
      char hphone    [16];                // homephone
      char bphone    [16];                // work/data phone
      char subscribe  [9];                // subscription date
      short  level;                       // security - up to 255
      long usernum;                       // user's sequence number
      long timeson;                       // times on - over 2 billion
      char lastdate   [9];                // last date on - mm/dd/yy
      char lasttime   [6];                // last time on - hh:mm
      long ttlmins;                       // total mins on - 2+ billion
      short  minutes;                     // # of minutes last call
      long uploads;                       // # of uploads - 2+ billion
      long downloads;                     // # of downloads - 2+ billion
      long ttlbytes;                      // total bytes downloaded
      long curbytes;                      // bytes downloaded this call
      char privuser;                       // allow on private nodes?
      char protocol   [3];                // transfer protocol
      short  page;                        // page length - to 23
      char lastdir    [9];                // date last looked at dir
      long lastmsg;                       // last message read - 99999 max
      long mesread;                       // total msgs read - 2+ billion
      long mesleft;                       // total messages left
      long forum_joined;                  // total forums joined
      long blts_read;                     // total bulletins read
      long doors_opened;                  // total doors opened
      unsigned short lastconf;            // last forum in
      char expert;                        // novice = N, expert = Y
      char sysop;                         // sysop record, 1 = Y, 0 = N
      long upbytes;                       // total bytes uploaded
      short curdown;                      // total files downed today
      char birthdate  [9];                // user's birthdate
      char comment   [51];                // comment about user
      char add1      [26];                // Company or address
      char add2      [26];                // Address
      char city      [26];                // City
      char state     [11];                // State
      char zip       [11];                // Zip
      char country   [16];                // Country
      char regis_date [9];                // Date 1st signed on
      char enf_time;                      // Y = enforce time limit, N = dont
      char editor;                        // V = visual, L = line, A = Ask
      char chat;                          // Y/N if available for chat
      char msgclr;                        // Y = clear screen between msgs
      short newmsg;                       // > 0 if new mail in Main
      short timecredit;                   // any time credits user might have
      short expired;                      // Expired Subscription level
      char pub_forums;                    // Y = when expired, remove from private forums
      short discons;                      // number of disconnects (ALT-H)
      long per_time;                      // time used during sub period
      long nu;                            // to go with above at some point
      unsigned char flags;                // misc status flags
      char nu1        [9];                // later additions
      };                                  // 424 bytes

   struct PCBSYS14                        // structure of PCBOARD.SYS    
      {
      char display      [2];              // display on/off -1=on,0=off  
      char printer      [2];              // printer on/off -1=on,0=off  
      char pagebell     [2];              // page bell      -1=on,0=off  
      char calleralarm  [2];              // caller alarm   -1=on,0=off  
      char sysopnext;                     // sysop on next  N,X,space    
      char errcorrect   [2];              // ecc modem      -1=yes,0=no  
      char color;                         // color toggle   Y,N,7        
      char nu;                            // node chat, not provided     
      char baud         [5];              // com port bps rate           
      char userbaud     [5];              // call bps rate               
      short  userrec;                     // user record position        
      char userfirst   [15];              // caller's first name         
      char password    [12];              // users password              
      short timeon;                       // time user logged on (mins)  
      short timeused;                     // time user has used that day 
      char ctime        [5];              // time user logged on hh:mm   
      short timeallowed;                  // allowed time in minutes     
      short ttlbytes;                     // total bytes available /1024 
      char forumnum;                      // forum user was in "0" = main
      char nu1          [5];              // areas been in, not provided 
      char nu2          [5];              // areas scanned, not provided 
      short timegiven;                    // highest forum time given    
      short timecredit;                   // time credit in minutes      
      char nu3          [4];              // language being used         
      char username    [25];              // name of caller              
      short minsleft;                     // minutes left for caller     
      char node;                          // node number (short int)     
      char event        [5];              // event time hh:mm            
      char event_active [2];              // event active  -1=yes,0=no   
      char slide_event  [2];              // slide event   -1=yes,0=no   
      char nu4          [4];              // memorized mess #, not prov  
      char port;                          // com port, '0','1','2'       
      char nu5          [2];              // not used                    
      };


   //****************************************************************
   //  you will need to consult the pcb documentation for a more     
   //  detailed explanation of these fields.  Note that any          
   //  double or float fields will have to be converted with the     
   //  appropriate C conversion function.                            
   //****************************************************************

   struct PCBUSER14                       // structure for PCB USERS     
      {
      char name         [25];             // users full name             
      char city         [24];             // users home town             
      char passwd       [12];             // users password              
      char bphone       [13];             // users data phone number     
      char hphone       [13];             // users home phone number     
      char lastdate      [6];             // last date on as yymmdd (sic)
      char lasttime      [5];             // last time on as hh:mm       
      char expert;                        // expert mode                 
      char protocol;                      // protol being used           
      char nu;                            // not used                    
      char lastdir       [6];             // last directory date yymmdd  
      char level;                         // users level as short int    
      short  timeson;                     // # of times on               
      char page;                          // page length as short int    
      short  uploads;                     // # of uploads                
      short  downloads;                   // # of downloads              
      double curdown;                     // current down bytes          
      char comment1     [30];             // comment                     
      char comment2     [30];             // comment                     
      short elap;                         // elapsed time                  
      char regisdate     [6];             // registration date yymmdd    
      char exp_level;                     // expired security level      
      char lastconf;                      // last forum in               
      char forum_regis   [5];             // you figure it out cause     
      char forum_exp     [5];             // these fields are definately 
      char forum_scan    [5];             // NOT bit maps!               
      double downbytes;                   // total downbytes             
      double upbytes;                     // total upbytes               
      char deleted;                       // deleted user                
      float lastmsg;                      // last msg read               
      float lastmsg1    [39];             // last msg read in forums     
      char nu1          [15];             // not used                    
      };                                  // 400 bytes                   


#define YES 1                             // used when calling show_mess()   
#define NO  0


#define TAB  9
#define ESC  0x1b

#define F1  59 + 0x100
#define F2  60 + 0x100
#define F3  61 + 0x100
#define F4  62 + 0x100
#define F5  63 + 0x100
#define F6  64 + 0x100
#define F7  65 + 0x100
#define F8  66 + 0x100
#define F9  67 + 0x100
#define F10 68 + 0x100
#define F11 171 + 0x100
#define F12 172 + 0x100
#define CF10 103 + 0x100

#define HOME_KEY  71 + 0x100
#define END_KEY   79 + 0x100
#define PGUP      73 + 0x100
#define PGDN      81 + 0x100
#define CUR_LEFT  75 + 0x100
#define CUR_RIGHT 77 + 0x100
#define CUR_UP    72 + 0x100
#define CUR_DOWN  80 + 0x100
#define AF1       104+ 0x100
#define AF2       105+ 0x100
#define AF3       106+ 0x100
#define AF4       107+ 0x100
#define AF5       108+ 0x100
#define AF6       109+ 0x100
#define AF7       110+ 0x100
#define AF8       111+ 0x100
#define AF9       112+ 0x100
#define AF10      113+ 0x100

#define CTRLK   11
#define CTRLX   24

#define ON 1
#define OFF 0
#define TIMEOUT -10

//  ASCII Protocol Characters

#define NUL 0
#define SOH 1
#define STX 2
#define ETX 3
#define EOT 4
#define ACK 6
#define DLE 0x10
#define DC1 0x11
#define DC2 0x12
#define DC3 0x13
#define DC4 0x14
#define NAK 0x15
#define ETB 0x17
#define CAN 0x18
#define XON 0x11
#define XOFF 0x13


   // prototypes for GAPCDR functions 

   extern  void __pascal check_rip(void);
   extern  void __pascal ansi(char *ansicolor);
   extern  void __pascal backspace(short howmany);
   extern  void __pascal do_chat(void );
   extern  void __pascal update_clock(void );
   extern  void __pascal clear_scrn(void );
   extern  void __pascal elap_time(void );
   extern  void __pascal time_left(void );
   extern  void __pascal empty(char *str,short len);
   extern  FILE * __pascal read_cnf(char *fname);
   extern  short __pascal read_doorsys(void );
   extern  short __pascal init_door(void );
   extern  void __pascal no_carrier(void );
   extern  void __pascal leave(short how);
   extern  short __pascal read_gapuser(char *path );
   extern  short __pascal write_gapuser(char *path );
   extern  short __pascal getakey(void );
   extern  void __pascal get_string(char *fld);
   extern  void __pascal more(void );
   extern  void __pascal nl(char howmany);
   extern  void __pascal pagesysop(void );
   extern  void __pascal pause(void );
   extern  short __pascal read_pcbsys(void );
   extern  short __pascal write_pcbsys(void );
   extern  short __pascal read_pcbuser(char *path);
   extern  short __pascal write_pcbuser(char *path );
   extern  void __pascal write_score(char *datfile,unsigned long score);
   extern  short __pascal read_score(char *datfile,char *message);
   extern  void __pascal show_file(char *filename);
   extern  short __pascal send_ripfile(char *filename);
   extern  void __pascal show_mess(char *vstring,char flag,char newline);
   extern  void __pascal set_status(short update);
   extern  void __pascal time_credit(short how);
   extern  char *trim(char *str);
   extern void __pascal cls(void);
   extern void __pascal cls_all(void);
   extern void  __pascal dv_pause(void);
   extern short __pascal dv_here(void);


   // prototypes for private GAPCDR functions 

   extern  void __pascal init_com(void );
   extern  void __pascal wrap_word(void );
   extern  void __pascal putkey(short c);
   extern  short __pascal get_random(short low,short high);
   extern void __pascal make_sound(unsigned short f, short dur);
   extern short __pascal getkeyc(void);
   extern short __pascal access1(char *fname);
   extern short __pascal strwrd(const char *strng,const char *sub_strng);

   extern void __pascal gapputs(char *string);
    extern void __pascal gapputc(short ch);
   extern void __pascal lputs(char *str);
   extern void __pascal lputc(short ch);
   extern void __pascal curson(void);
   extern void __pascal cursoff(void);
   extern void __pascal timer(unsigned short tics);

   extern void __pascal init_ansi(void);
   extern void __pascal fix_color(void);

   extern void __pascal set_int10(void);
   extern void __pascal rest_int10(void);
   extern void __pascal set_cord(unsigned char topr, unsigned char topc, unsigned char botr, unsigned char botc);
   extern void __pascal set_attr(unsigned char forg, unsigned char back);
   extern void __pascal get_attr(void);
   extern void __pascal save_screen(short row1, short col1, short row2, short col2, unsigned short savemem);
   extern void __pascal restore_screen(short row1, short col1, short row2, short col2, unsigned short savemem);
   extern void __pascal set_int29(void);
   extern void __pascal rest_int29(void);


   extern void __pascal set_cbreak(void);
   extern void __pascal rest_cbreak(void);


   // prototypes for Communications routines

   short  __pascal setport(short  bufsize,short  irq,short  base);
   void   __pascal reset_port(void);
   short  __pascal init_port(short  parity,short  data);

   extern  short __pascal ckeypress(void );
   extern  short __pascal comgetc(void );
   extern  void __pascal __near is_carrier(void );
   extern  void __pascal clr_buf(void );
   extern  short __pascal comgetd(short secs);
   extern  void __pascal computc(unsigned char ch);
   extern  void __pascal computs(const unsigned char *str);
   extern  void __pascal computb(const unsigned char *str, short length);
   extern  void __pascal dtr(short how);
   extern  void __pascal rts(short how);
   extern  short __pascal iscd(void );
   extern  short __pascal isring(void );
   extern  short __pascal rxempty(void );
   extern  short __pascal __near check_port(void );


   // DigiBoard specific routines


   extern void __pascal setdigi(void);

   // called by regular COM routines to set the Digi Flag to 0


   extern short __pascal dsetup(short base,short port,short chnl,long baud,short parity,short data,short stop);

   // used to setup Direct DigiBoard Programming support
   // RESETDIG.EXE must have already been run in the AUTOEXEC.BAT or this
   // function will fail

   // base   = Memory Window
   // port   = I/O Port
   // chnl   = DigiBoard Channel # (1 - 8)
   // baud   = baudrate (long)
   // parity = 0 = None, 1 = Odd, 2 = Even
   // data   = 6, 7, or 8
   // stop   = 1 or 2

   // Return 0 = success
   //        1 = no board
   //        2 = Can't talk to board
   //        3 = Invalid Parameter
   //        4 = EPROM too old


   extern short __pascal int14set(short chnl,long baud,short parity,short data,short stop);

   // used to setup DigiBoard via INT14/EBIOS Device Driver
   // The Device Driver must be installed and configured for EBIOS Support
   // or this function will fail

   // chnl   = DigiBoard Channel # (usually 4 - 11)
   // baud   = baudrate (long)
   // parity = 0 = None, 1 = Odd, 2 = Even
   // data   = 6, 7, or 8
   // stop   = 1 or 2

   // Return 0 = success
   //        1 = Device Driver Not installed or board not installed
   //        2 = EBIOS not configured
   //        3 = Invalid Parameter


   // all other Digi Functions work with either Direct Programming or
   // Int14/EBIOS


   extern void __pascal dmodem(long baud,short parity,short data,short stop);

   // used to change online modem parameters
   // normally not used with a BBS, but with Term program

   // baud   = baudrate (long)
   // parity = 0 = None, 1 = Odd, 2 = Even
   // data   = 6, 7, or 8
   // stop   = 1 or 2


   extern void __pascal drestore(void);

   // Resets The Modem attached to the DigiBoard
   // don't call if you want DTR to stay up


   extern short __pascal dgtxfree(void);

   // get number of free bytes in Transmit Buffer
   // returns 0 = No characters, otherwise number of bytes


   extern short __pascal dmodstat(void);

   // Returns Modem Status in AL


   extern void __pascal dclrtx(void);

   // Flushes the Digi Transmit Buffer
   // no need to call if user has "Send Break To Clear Modem" set on
   // since the Break Routine automatically clears the xmit buffer


   // Fossil specific routines

   extern short __pascal fos_setport(short port);

   // Tells the Fossil we want to use the port

   extern void __pascal fos_resetport(void);

   // Tells the Fossil we are done with the port

   extern short __pascal fos_initport(long baud,short parity,short data,short stop);

   // Sets the Fossil Baud, Parity, Data, and Stop bits

   extern void __pascal fos_clrtx(void);

   // Clears the Fossil Transmit Buffer
   // no need to call if user has "Send Break To Clear Modem" set on
   // since the Break Routine automatically clears the xmit buffer


#if (_MSC_VER)
   #pragma pack()                         // restore default packing
#else
   #pragma option -a.                     // restore default packing
#endif

#ifdef __cplusplus
}
#endif 

#endif                                    // __GAPSTRUC_H__ defined
