extproc perl -S -x
    
#!perl

$| = 1;

foreach (<man*>)
{
    if (-d $_) {
	foreach (<$_/*>) {
	    if (/^([^\/]+\/[^.]+)\.[^.]+$/) {
		if (defined $man{$1}) {
		    print "Error: There are two $1\n";
		}
		$man{$1} = $_;
	    } else {
		print "Error: $_ is not a good name for a man page\n";
	    }
	}
    }
}

foreach (sort keys %man)
{
    if (/(.+)\/(.+)/) {
	$dirs{$1} .= $_ . "\n";
	$pagename{$_} = $2;
    } else {
	die;
    }
}

foreach (sort keys %man)
{
    $fname = $_;
    $manpagename = $pagename{$fname};
    open (F, $man{$fname});
    $names = "";
    mainloop: while (<F>) {
	if (/^\.SH/) {
	    $macro{$fname} = "-man";
	    die "$fname: Bad manpage format" 
		if (! /^.SH\s+NAME/);
	    while (<F>) {
		last if (/^\.SH/);
		die "$fname: Bad manpage format"
		    if (/^\./);
		s/\s*\\-.*//;
		s/[, \t]+/ /g;
		s/\s*$/ /;
		$names .= $_;
	    }
	    last;
	} elsif (/^\.Sh/) {
	    $macro{$fname} = "-mandoc";
	    die "$fname: Bad manpage format"
		if (! /^.Sh NAME/);
	    while (<F>) {
		last if (/^\.Sh/);
		if (/^\.Nm\s+(\S.*)$/) {
		    $names .= join(" ", split (/[,\s]+/, $1));
		    $names .= " ";
		}
	    }
	    last;
	}
    }
    die "Failed to read names from $fname"
	if ($names eq "");
    close(F);
#    print "$fname -> $names\n";
    $all_names{$fname} = $names;
}

open(F, ">PMMAN.DIR");
foreach (keys %dirs)
{
    $directory = $_;
    print F "Directory: cat", substr($_, 3), "\n";
    foreach (split(/[ \t\n]+/, $dirs{$directory})) {
	$manpagename = $_;
	foreach (split(/\s+/, $all_names{$manpagename})) {
	    print F $_, " ", $pagename{$manpagename}, "\n";
	}
    }
}
close(F);

foreach (sort keys %man)
{
    $mansource = $man{$_};
    $manfmt = "cat" . substr($_, 3);
    $cmd = "groff $macro{$_} $mansource > $manfmt";
    print $cmd, "\n";
    system $cmd;
}

0;
