// ========================================================================
//  TODB LIBRARY
//    demo.cpp
//
//    Demonstration program
//
//    Version: see TODB.H file
//
//    Copyright 1993 Christian Thrien
//    All rights reserved
// ========================================================================

#include "demo.h"
#include "schema.h"
#include "schset.h"
#include <string.h>
#include <fstream.h>
#include <stdlib.h>

void Load();
void Clear();
void Search();
Boolean LoadBibNote( char * fn );
Boolean DeleteBibNote( char * fn );

// key set database
TODB * ksDB = NULL;
// application framework
TODBmgr * db = NULL;


void main()
{
    Load();		   // loads key set database
    cout << "+++++++++++++ First search : " << endl << endl;
    Search();
    Clear();		   // cleans up the database
    cout << "+++++++++++++ Second search : " << endl;
    Search();
}

void Load()
{
    db = new TODBmgr;
    db->DeleteDB( String( "DEMODB" ) );
    if ( db->OpenNew( String( "DEMODB" ) ) == False ) {
	delete db;
	return;
    }

    if ( db->isOpen() == True )
	LoadBibNote( "DEMO.DAT" );

    delete db;
}

void Clear()
{
    db = new TODBmgr;
    if ( db->OpenExist( String( "DEMODB" ) ) == False ) {
	delete db;
	return;
    }

    if ( db->isOpen() == True )
	DeleteBibNote( "DEMO.DAT" );

    delete db;
}

void Search()
{
    db = new TODBmgr;
    if ( db->OpenExist( String( "DEMODB" ) ) == False ) {
	delete db;
	return;
    }

    SearchSet s1( ksDB ), s2( ksDB ), s3( ksDB );

    cout << "=============" << endl;
    s1.FindExact( BIBNOTE, AUTHOR, "MADSEN" );
    cout << endl << "  Search of MADSEN (BIBNOTE, AUTHOR),        set length : " << s1.Card() << endl;

    cout << "=============" << endl;
    s2.FindPattern( BIBNOTE, AUTHOR, "MA*" );
    cout << endl << "  Search of MA*    (BIBNOTE, AUTHOR),        set length : " << s2.Card() << endl;

    cout << "=============" << endl;
    s3 = s2 - s1;
    cout << endl << "  MA* - MADSEN,                              set length : " << s3.Card() << endl;

    cout << "=============" << endl;
    s1.FindAll( BIBNOTE, PUBLISHER );
    cout << endl << "  Search all PUBLISHER (BIBNOTE, PUBLISHER), set length : " << s1.Card() << endl;

    cout << "=============" << endl;

    delete db;
}

Boolean LoadBibNote( char * fn )
{
    char line[ 2048 ];
    ifstream tagf;
    char c;
    BibNote * bibn = NULL;

    tagf.open( fn, ios::nocreate );
    if ( !tagf ) return False;

    // Empty file?
    tagf.get( c );
    if ( tagf.eof() ) return False;
    tagf.putback( c );

    tagf.getline( line, 2048, '\n' );
    if ( strstr( line, "$KEY  : " ) == NULL ) return False;

    // Load Count class instance
    Count cnt;

    // create the first BibNote
    bibn = new BibNote( cnt.IncCNote() );

    while ( !tagf.eof() ) {
	tagf.getline( line, 2048, '\n' );
	if ( strstr( line, "$KEY  : " ) != NULL ) {
	    cout << "Loading BibNote no. " << cnt.CNote() << endl;
	    bibn->ChangeIdx();
	    delete bibn;
	    // Next BibNote
	    bibn = new BibNote( cnt.IncCNote() );
	}
	if ( strstr( line, "AUTHOR: ") != NULL) {
	    bibn->author += line + 8;
	    bibn->author += " ";
	}
	if ( strstr( line, "SHELFM: ") != NULL) {
	    bibn->shelf_mark += line + 8;
	    bibn->shelf_mark += " ";
	}
	if ( strstr( line, "DATE  : ") != NULL) {
	    bibn -> date += line + 8;
	    bibn -> date += " ";
	}
	if ( strstr( line, "KEYWDS: ") != NULL) {
	    bibn->keywords += line + 8;
	    bibn->keywords += " ";
	}
	if ( strstr( line, "PUBL  : ") != NULL) {
	    bibn->publisher += line + 8;
	    bibn->publisher += " ";
	}
	if ( strstr( line, "ISSN  : ") != NULL) {
	    bibn->issn += line + 8;
	    bibn->issn += " ";
	}
	if ( strstr( line, "ISBN  : ") != NULL) {
	    bibn->isbn += line + 8;
	    bibn->isbn += " ";
	}
	if ( strstr( line, "PUBLPL: ") != NULL) {
	    bibn -> publishing_place += line + 8;
	    bibn -> publishing_place += " ";
	}
	if ( strstr( line, "PAGING: ") != NULL) {
	    bibn->paging += line + 8;
	    bibn->paging += " ";
	}
	if ( strstr( line, "ARTSUB: ") != NULL) {
	    bibn->article_subtitle += line + 8;
	    bibn->article_subtitle += " ";
	}
	if ( strstr( line, "ARTIT : ") != NULL) {
	    bibn->article_title += line + 8;
	    bibn->article_title += " ";
	}
	if ( strstr( line, "TITLE : ") != NULL) {
	    bibn->title += line + 8;
	    bibn->title += " ";
	}
	if ( strstr( line, "SUBTIT: ") != NULL) {
	    bibn->subtitle += line + 8;
	    bibn->subtitle += " ";
	}
    }
    cout << "Loading BibNote no. " << cnt.CNote() << endl;
    bibn->ChangeIdx();
    delete bibn;

    tagf.close();
    return True;
}

Boolean DeleteBibNote( char * fn )
{
    char line[ 2048 ];
    ifstream tagf;
    char c;
    BibNote * bibn = NULL;

    tagf.open( fn, ios::nocreate );
    if ( !tagf ) return False;

    // Empty file?
    tagf.get( c );
    if ( tagf.eof() ) return False;
    tagf.putback( c );

    tagf.getline( line, 2048, '\n' );
    if ( strstr( line, "$KEY  : " ) == NULL ) return False;

    KeyType key = 1;

    bibn = new BibNote( key );

    while ( !tagf.eof() ) {
	tagf.getline( line, 2048, '\n' );
	if ( strstr( line, "$KEY  : " ) != NULL ) {
	    cout << "Deleting BibNote no. " << key << endl;
	    bibn->Delete();
	    delete bibn;
	    bibn = new BibNote( ++key );
	}
	if ( strstr( line, "AUTHOR: ") != NULL) {
	    bibn->author += line + 8;
	    bibn->author += " ";
	}
	if ( strstr( line, "SHELFM: ") != NULL) {
	    bibn->shelf_mark += line + 8;
	    bibn->shelf_mark += " ";
	}
	if ( strstr( line, "DATE  : ") != NULL) {
	    bibn -> date += line + 8;
	    bibn -> date += " ";
	}
	if ( strstr( line, "KEYWDS: ") != NULL) {
	    bibn->keywords += line + 8;
	    bibn->keywords += " ";
	}
	if ( strstr( line, "PUBL  : ") != NULL) {
	    bibn->publisher += line + 8;
	    bibn->publisher += " ";
	}
	if ( strstr( line, "ISSN  : ") != NULL) {
	    bibn->issn += line + 8;
	    bibn->issn += " ";
	}
	if ( strstr( line, "ISBN  : ") != NULL) {
	    bibn->isbn += line + 8;
	    bibn->isbn += " ";
	}
	if ( strstr( line, "PUBLPL: ") != NULL) {
	    bibn -> publishing_place += line + 8;
	    bibn -> publishing_place += " ";
	}
	if ( strstr( line, "PAGING: ") != NULL) {
	    bibn->paging += line + 8;
	    bibn->paging += " ";
	}
	if ( strstr( line, "ARTSUB: ") != NULL) {
	    bibn->article_subtitle += line + 8;
	    bibn->article_subtitle += " ";
	}
	if ( strstr( line, "ARTIT : ") != NULL) {
	    bibn->article_title += line + 8;
	    bibn->article_title += " ";
	}
	if ( strstr( line, "TITLE : ") != NULL) {
	    bibn->title += line + 8;
	    bibn->title += " ";
	}
	if ( strstr( line, "SUBTIT: ") != NULL) {
	    bibn->subtitle += line + 8;
	    bibn->subtitle += " ";
	}
    }
    cout << "Deleting BibNote no. " << key << endl;
    bibn->Delete();
    delete bibn;

    tagf.close();
    return True;
}

//-------------------------------------------------------------------------
// TODBmgr class
//-------------------------------------------------------------------------

TODBmgr::TODBmgr()
{
    open_ = False;
}

TODBmgr::~TODBmgr()
{
    if ( open_ == True ) Close();
}

// Open an empty database
Boolean TODBmgr::OpenNew( String & fname )
{
    open_ = False;

    ksDB = new TODB;
    if ( ksDB->Open( fname + String( ".KEY" ),
		     fname + String( ".IDX" ),
		     IDX_CREAT | IDX_APPEND ) == False )
	return False;

    Count * cnt = new Count( 0 );
    cnt->SetVersion( String( "MyVersion: 1.0" ) );
    cnt->SetDirty();
    cnt->SetCNote( 0 );
    cnt->AddObject();
    delete cnt;

    return ( open_ = True );
}

// if exist, open the database
Boolean TODBmgr::OpenExist( String & fname )
{
    ksDB = new TODB;
    if ( ksDB->Open( fname + String( ".KEY" ),
		     fname + String( ".IDX" ),
		     IDX_EXIST ) == False )
	return ( open_ = False );

    // check the dirty bit value
    Count * cnt = new Count;
    if ( cnt->Dirty() == True ) {
	delete cnt;
	delete ksDB;
	FileError();
    }
    else {
	delete cnt;
	return ( open_ = True );
    }

    return ( open_ = False );
}

Boolean TODBmgr::isOpen()
{
    return open_;
}

Boolean TODBmgr::Close()
{
    if ( open_ == True ) {
	Count * cnt = new Count;
	cnt->ResetDirty();
	delete cnt;
	delete ksDB;
	open_ = False;
	return True;
    }
    return False;
}

void TODBmgr::DeleteDB( String & fname )
{
    remove( fname + String( ".KEY" ) );
    remove( fname + String( ".IDX" ) );
}

void TODBmgr::FileError()
{
    cerr << "\n FATAL ERROR - TODBmgr: dirty bit is set, file .KEY corrupted";
    exit( EXIT_FAILURE );
}
