// ========================================================================
//  TODB LIBRARY
//    icoll.h
//
//    Indexed Collection
//    MakeToken class, IdxString class, IdxColl class
//
//    Version: see TODB.H file
//
//    Copyright 1993 Christian Thrien
//    All rights reserved
// ========================================================================

#ifndef _ICOLL_H
#define _ICOLL_H

#include "boolean.h"
#include "strn.h"
#include "ptodb.h"

class TIndex;
class TODB;
class ErrReporter;

//-------------------------------------------------------------------------
// MakeToken class (abstract base class)
//-------------------------------------------------------------------------

class MakeToken
{
public:
    virtual ~MakeToken();
    virtual void Put( const char * s ) = 0;
    virtual int First( char * token ) = 0;
    virtual int Next( char * token ) = 0;
};

//-------------------------------------------------------------------------
// IdxString class
//-------------------------------------------------------------------------

class IdxString : public String
{
friend class IdxColl;

public:
    IdxString();
    IdxString( const IdxString & istr );
    IdxString( const String & str );

    ~IdxString();

    // -- assignment
    IdxString & operator = ( const IdxString & istr );
    IdxString & operator = ( const String & str );

    // -- update operator
    IdxString & operator /= ( const String & str );

private:
    String old_str_;
    Boolean dirty_;

    // -- returns old string
    String OldStr() const;
    // -- returns state
    Boolean Dirty() const;
};

inline IdxString::~IdxString()
{
}

inline String IdxString::OldStr() const
{
    return old_str_;
}

inline Boolean IdxString::Dirty() const
{
    return dirty_;
}

//-------------------------------------------------------------------------
// IdxColl class (abstract base class)
//     "Indexed collection"
//-------------------------------------------------------------------------

class IdxColl
{
public:
    IdxColl( TODB & db, IdType cid );

    virtual ~IdxColl();

    void SaveIdx();
    void ChangeIdx();
    void DeleteIdx();

    void IndexObject( KeyType key, IdType idxid,
		      MakeToken & mt,
		      const IdxString & str );

protected:
    virtual void Index() = 0;

private:
    TODB & todb_;
    TIndex & btree_;
    char * token_;
    char * entry_;
    IdType curcid_;
    Boolean changed_;
    Boolean deleted_;

    IdxColl( const IdxColl & ic );
    IdxColl & operator = ( const IdxColl & ic );

    void MakePrefix( IdType cid, IdType idxid );
    void NormID( char * buf );

    void NewSet( KeyType key );
    void AddIndexes( KeyType key, IdType idxid, MakeToken & mt,
		     const IdxString & str );
    void DeleteIndexes( KeyType key, IdType idxid, MakeToken & mt,
			const IdxString & str );
    void RemoveIndexes( KeyType key, IdType idxid, MakeToken & mt,
			const String & str );
};

inline void IdxColl::ChangeIdx()
{
    changed_ = True;
}

inline void IdxColl::DeleteIdx()
{
    deleted_ = True;
}

#endif // _ICOLL_H
