// ========================================================================
//  TODB LIBRARY
//    todb.h
//
//    TODB class
//
//    Version: 1.01
//
//    Copyright 1993 Christian Thrien
//    All rights reserved
// ========================================================================

#ifndef _TODB_H
#define _TODB_H

#include "ptodb.h"
#include "boolean.h"
#include <stdio.h>

class String;
class TIndex;
class ErrReporter;

typedef ObjAdr BlockNbr;
typedef KeyType KeyNbr;

enum TODBError
{
    TODBE_ALLOC,
    TODBE_OPENFAIL,
    TODBE_READ,
    TODBE_CLOSE
};

const int IDX_CREAT  =	0x01;
const int IDX_EXIST  =	0x02;
const int IDX_APPEND =	0x04;

class TODB
{
friend class IdxColl;
friend class SearchSet;
friend class Block;
friend class KSPersistent;
friend void CloseFromError();

public:
    TODB();

    ~TODB();

    // -- open a key set database
    Boolean Open( String & fname_key, String & fname_idx, int omode );
    // -- close a key set database
    void Close();
    // -- database state
    Boolean isOpen() const;

    // error control
    static void SetErrOut( ErrReporter * er );

protected:
    void SetErrorTrap();
    void ResetErrorTrap();

private:
    Boolean open_;			 // true if files are opened
    Boolean append_;			 // true if opened in append mode
    TIndex * tindex_;			 // the b-tree
    FILE * dataf_;			 // key set database file
    Boolean newf_;			 // true if files are new
    BlockNbr deletedblock_;		 // first deleted block
    BlockNbr highestblock_;		 // highest assigned block
    BlockNbr origdeletedblock_;		 // original first deleted block
    BlockNbr orighighestblock_;		 // original highest assigned block

    TIndex * TIndexFile();
    FILE * DataFile();

    BlockNbr NewBlock();
    void SetDeletedBlock( BlockNbr block );
    BlockNbr DeletedBlock() const;
    Boolean Append() const;

    TODB( const TODB & db );
    TODB & operator = ( const TODB & db );

    // error control
    static ErrReporter * ErrOut;
    static int ErrorTrapEnable;
    static TODB * thisTODB;
    static void ErrorHandler( TODBError err );
    void SetGlobalErrorTrap();
    static int MemError( size_t nm );
};

inline Boolean TODB::isOpen() const
{
    return open_;
}

inline Boolean TODB::Append() const
{
    return append_;
}

inline void TODB::SetDeletedBlock( BlockNbr block )
{
    deletedblock_ = block;
}

inline BlockNbr TODB::DeletedBlock() const
{
    return deletedblock_;
}

inline TIndex * TODB::TIndexFile()
{
    return tindex_;
}

inline FILE * TODB::DataFile()
{
    return dataf_;
}

#endif // _TODB_H
