// ========================================================================
//  TODB LIBRARY
//    strn.h
//
//    String class
//
//    Version: see TODB.H file
//
//    Copyright 1993 Christian Thrien
//    All rights reserved
// ========================================================================

#ifndef _STRN_H
#define _STRN_H

#include <stddef.h>

class String
{
public:
    // constructor
    String();
    String( const String & str );
    String( const char * cstr );
    String( size_t count, char fillCh = '\0' );

    // destructor
    ~String();

    // string length
    size_t Length() const;

    // return a c string
    operator char * () const;

    // assignment
    String & operator = ( const String & str );
    String & operator = ( const char * str );

    // concatenation (3 operands)
    friend String operator + ( const String & str1, const String & str2 );
    // concatenation (2 operands)
    void operator += ( const String & str );

private:
    size_t len_; // string length
    char * buf_; // pointer to string
};

inline String::~String()
{
    delete [] buf_;
}

inline size_t String::Length() const
{
    return len_;
}

inline void String::operator += ( const String & str )
{
    *this = *this + str;
}

inline String::operator char * () const
{
    return buf_;
}

#endif // _STRN_H
