// ========================================================================
//  TODB LIBRARY
//    ptodb.h
//
//    Global type and parameters
//
//    Version: see TODB.H file
//
//    Copyright 1993 Christian Thrien
//    All rights reserved
// ========================================================================

#ifndef _PTODB_H
#define _PTODB_H

// -- Parameters

// File block length
// -----------------
// A key cannot spill over a file block.  For this reason, the block length
// value must respect these constraints:
//
// 1) For the first block in a key set thread
//    block length = 2 * sizeof( BlockNbr ) + sizeof( ObjHeader )
//		     + X1 * sizeof( KeyType );
//    X1 is the number of keys saved in the first block.
//
// 2) For the next block in a key set thread
//    block length = sizeof( BlockNbr ) + sizeof( ObjHeader )
//		     + X2 * sizeof( KeyType );
//    X2 is the number of keys saved in the next block.
//
// Where:
//    sizeof( ObjHeader ) = sizeof( IdType ) + sizeof( KeyType );
//
// In general:
//    X2 = X1 + 1 or
//    X2 = X1 + 2
//
// Example:
//    You need 120 keys by block, a key is four bytes long.
//    sizeof( IdType ) is always = 2
//    sizeof( KeyNbr ) = sizeof( KeyType ) = 4
//    sizeof( ObjHeader ) = 2 + 4 = 6
//    First block:
//	2 * 4 + 6 + (X1 = 119) * 4 = 490
//    Next block:
//	4 + 6 + (X2 = 120) * 4 = 490
//    Block length = 490

const int blocklength = 70;

// Key length
// ----------
// KeyType defines the type of the keys saved in the database.
// We strongly recommend the use of unsigned type.

typedef unsigned int KeyType;

// Class and index identification
// ------------------------------
// IdType defines the type of class and index identification.
// The value of sizeof( IdType ) must be two.  Depending on your
// computer architecture, set the needed value for this type.

typedef int IdType;

// -- Global type

// KSPersistent Object address
// ---------------------------
// The type of KSPersistent object address is define by ObjAdr.

typedef long ObjAdr;

#endif // _PTODB_H
